/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.KerberosDetails;
import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.serveraction.kerberos.Component;
import id.onyx.obdp.server.serveraction.kerberos.KerberosAdminAuthenticationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosIdentityDataFileWriter;
import id.onyx.obdp.server.serveraction.kerberos.KerberosInvalidConfigurationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosMissingAdminCredentialsException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.kerberos.KerberosConfigurationDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public interface KerberosHelper {
    public static final String DIRECTIVE_MANAGE_KERBEROS_IDENTITIES = "manage_kerberos_identities";
    public static final String DIRECTIVE_REGENERATE_KEYTABS = "regenerate_keytabs";
    public static final String DIRECTIVE_HOSTS = "regenerate_hosts";
    public static final String DIRECTIVE_COMPONENTS = "regenerate_components";
    public static final String DIRECTIVE_IGNORE_CONFIGS = "ignore_config_updates";
    public static final String DIRECTIVE_CONFIG_UPDATE_POLICY = "config_update_policy";
    public static final String DIRECTIVE_FORCE_TOGGLE_KERBEROS = "force_toggle_kerberos";
    public static final String SECURITY_ENABLED_CONFIG_TYPE = "cluster-env";
    public static final String SECURITY_ENABLED_PROPERTY_NAME = "security_enabled";
    public static final String KDC_ADMINISTRATOR_CREDENTIAL_ALIAS = "kdc.admin.credential";
    public static final String AMBARI_SERVER_HOST_NAME = "obdp_server";
    public static final String KERBEROS_ENV = "kerberos-env";
    public static final String AMBARI_SERVER_KERBEROS_IDENTITY_NAME = "obdp-server";
    public static final String CREATE_AMBARI_PRINCIPAL = "create_obdp_principal";
    public static final String MANAGE_IDENTITIES = "manage_identities";
    public static final String DEFAULT_REALM = "realm";
    public static final String KDC_TYPE = "kdc_type";
    public static final String MANAGE_AUTH_TO_LOCAL_RULES = "manage_auth_to_local";
    public static final String INCLUDE_ALL_COMPONENTS_IN_AUTH_TO_LOCAL_RULES = "include_all_components_in_auth_to_local_rules";
    public static final String CASE_INSENSITIVE_USERNAME_RULES = "case_insensitive_username_rules";
    public static final String PRECONFIGURE_SERVICES = "preconfigure_services";
    public static final String ALLOW_RETRY = "allow_retry_on_failure";
    public static final String CLUSTER_HOST_INFO = "clusterHostInfo";

    public RequestStageContainer toggleKerberos(Cluster var1, SecurityType var2, RequestStageContainer var3, Boolean var4) throws OBDPException, KerberosOperationException;

    public RequestStageContainer executeCustomOperations(Cluster var1, Map<String, String> var2, RequestStageContainer var3, Boolean var4) throws OBDPException, KerberosOperationException;

    public RequestStageContainer ensureIdentities(Cluster var1, Map<String, ? extends Collection<String>> var2, Set<String> var3, Collection<String> var4, Set<String> var5, RequestStageContainer var6, Boolean var7) throws OBDPException, KerberosOperationException;

    public RequestStageContainer deleteIdentities(Cluster var1, Map<String, ? extends Collection<String>> var2, Set<String> var3, Collection<String> var4, RequestStageContainer var5, Boolean var6) throws OBDPException, KerberosOperationException;

    public void deleteIdentities(Cluster var1, List<Component> var2, Set<String> var3) throws OBDPException, KerberosOperationException;

    public void configureServices(Cluster var1, Map<String, Collection<String>> var2) throws OBDPException, KerberosInvalidConfigurationException;

    public Map<String, Map<String, String>> getServiceConfigurationUpdates(Cluster var1, Map<String, Map<String, String>> var2, Map<String, Set<String>> var3, Map<String, Collection<String>> var4, Set<String> var5, boolean var6, boolean var7) throws KerberosInvalidConfigurationException, OBDPException;

    public Map<String, Map<String, String>> applyStackAdvisorUpdates(Cluster var1, Set<String> var2, Map<String, Map<String, String>> var3, Map<String, Map<String, String>> var4, Map<String, Set<String>> var5, Map<String, Set<String>> var6, boolean var7) throws OBDPException;

    public boolean ensureHeadlessIdentities(Cluster var1, Map<String, Map<String, String>> var2, Set<String> var3) throws KerberosInvalidConfigurationException, OBDPException;

    public RequestStageContainer createTestIdentity(Cluster var1, Map<String, String> var2, RequestStageContainer var3) throws KerberosOperationException, OBDPException;

    public RequestStageContainer deleteTestIdentity(Cluster var1, Map<String, String> var2, RequestStageContainer var3) throws KerberosOperationException, OBDPException;

    public void validateKDCCredentials(Cluster var1) throws KerberosMissingAdminCredentialsException, KerberosAdminAuthenticationException, KerberosInvalidConfigurationException, OBDPException;

    public void setAuthToLocalRules(Cluster var1, KerberosDescriptor var2, String var3, Map<String, Set<String>> var4, Map<String, Map<String, String>> var5, Map<String, Map<String, String>> var6, boolean var7) throws OBDPException;

    public List<ServiceComponentHost> getServiceComponentHostsToProcess(Cluster var1, KerberosDescriptor var2, Map<String, ? extends Collection<String>> var3, Collection<String> var4) throws OBDPException;

    public Set<String> getHostsWithValidKerberosClient(Cluster var1) throws OBDPException;

    public KerberosDescriptor getKerberosDescriptor(Cluster var1, boolean var2) throws OBDPException;

    public KerberosDescriptor getKerberosDescriptor(Cluster var1, boolean var2, @Nullable KerberosDescriptor var3, @Nullable Map<String, DesiredConfig> var4) throws OBDPException;

    public KerberosDescriptor getKerberosDescriptor(KerberosDescriptorType var1, Cluster var2, boolean var3, Collection<String> var4, boolean var5, @Nullable KerberosDescriptor var6, @Nullable Map<String, DesiredConfig> var7) throws OBDPException;

    public KerberosDescriptor getKerberosDescriptor(KerberosDescriptorType var1, Cluster var2, StackId var3, boolean var4, @Nullable KerberosDescriptor var5) throws OBDPException;

    public Map<String, Map<String, String>> mergeConfigurations(Map<String, Map<String, String>> var1, Map<String, KerberosConfigurationDescriptor> var2, Map<String, Map<String, String>> var3, Set<String> var4) throws OBDPException;

    public Map<String, Map<String, String>> processPreconfiguredServiceConfigurations(Map<String, Map<String, String>> var1, Map<String, Map<String, String>> var2, Cluster var3, KerberosDescriptor var4) throws OBDPException;

    public int addIdentities(KerberosIdentityDataFileWriter var1, Collection<KerberosIdentityDescriptor> var2, Collection<String> var3, String var4, Long var5, String var6, String var7, Map<String, Map<String, String>> var8, Map<String, Map<String, String>> var9, Map<String, ResolvedKerberosKeytab> var10, String var11) throws IOException;

    public Map<String, Map<String, String>> calculateConfigurations(Cluster var1, String var2, KerberosDescriptor var3, boolean var4, boolean var5, Map<String, String> var6, @Nullable Map<String, DesiredConfig> var7) throws OBDPException;

    public Map<String, Map<String, String>> calculateConfigurations(Cluster var1, String var2, KerberosDescriptor var3, KerberosDescriptor var4, boolean var5, boolean var6, Map<String, String> var7, @Nullable Map<String, DesiredConfig> var8) throws OBDPException;

    public Map<String, Map<String, String>> calculateConfigurations(Cluster var1, String var2, KerberosDescriptor var3, boolean var4, boolean var5, @Nullable Map<String, DesiredConfig> var6) throws OBDPException;

    public boolean isClusterKerberosEnabled(Cluster var1);

    public boolean shouldExecuteCustomOperations(SecurityType var1, Map<String, String> var2);

    public Boolean getManageIdentitiesDirective(Map<String, String> var1);

    public boolean getForceToggleKerberosDirective(Map<String, String> var1);

    public Map<String, Map<String, String>> getIdentityConfigurations(List<KerberosIdentityDescriptor> var1);

    public Map<String, Collection<KerberosIdentityDescriptor>> getActiveIdentities(String var1, String var2, String var3, String var4, boolean var5, Map<String, Map<String, Map<String, String>>> var6, KerberosDescriptor var7, @Nullable Map<String, DesiredConfig> var8) throws OBDPException;

    public List<KerberosIdentityDescriptor> getAmbariServerIdentities(KerberosDescriptor var1) throws OBDPException;

    public boolean createAmbariIdentities(Map<String, String> var1);

    public PrincipalKeyCredential getKDCAdministratorCredentials(String var1) throws OBDPException;

    public void createResolvedKeytab(ResolvedKerberosKeytab var1, List<KerberosKeytabPrincipalEntity> var2);

    public void removeStaleKeytabs(Collection<ResolvedKerberosKeytab> var1);

    public File createTemporaryDirectory() throws OBDPException;

    public Map<String, Set<String>> translateConfigurationSpecifications(Collection<String> var1);

    public KerberosDetails getKerberosDetails(Cluster var1, Boolean var2) throws KerberosInvalidConfigurationException, OBDPException;

    public KerberosDescriptor getKerberosDescriptorUpdates(Cluster var1);

    public static interface Command<T, A> {
        public T invoke(A var1) throws OBDPException;
    }

    public static enum KerberosDescriptorType {
        STACK,
        USER,
        COMPOSITE;

    }
}

