/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HostsMap {
    private static final Logger LOG = LoggerFactory.getLogger(HostsMap.class);
    private String hostsMapFile;
    private Properties hostsMap;

    @Inject
    public HostsMap(Configuration conf) {
        this.hostsMapFile = conf.getHostsMapFile();
        this.setupMap();
    }

    public HostsMap(String file) {
        this.hostsMapFile = file;
    }

    public void setupMap() {
        InputStream inputStream = null;
        LOG.info("Using hostsmap file " + this.hostsMapFile);
        try {
            if (this.hostsMapFile != null) {
                this.hostsMap = new Properties();
                inputStream = new FileInputStream(new File(this.hostsMapFile));
                this.hostsMap.load(inputStream);
            }
        }
        catch (FileNotFoundException fnf) {
            LOG.info("No configuration file " + this.hostsMapFile + " found in classpath.", (Throwable)fnf);
        }
        catch (IOException ie) {
            throw new IllegalArgumentException("Can't read configuration file " + this.hostsMapFile, ie);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException fnf) {}
            }
        }
    }

    public String getHostMap(String hostName) {
        if (this.hostsMapFile == null) {
            return hostName;
        }
        return this.hostsMap.getProperty(hostName, hostName);
    }
}

