/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.agent.AgentEnv;
import id.onyx.obdp.server.agent.DiskInfo;
import id.onyx.obdp.server.agent.RecoveryReport;
import id.onyx.obdp.server.controller.ApiModel;
import id.onyx.obdp.server.state.AgentVersion;
import id.onyx.obdp.server.state.HostConfig;
import id.onyx.obdp.server.state.HostHealthStatus;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.MaintenanceState;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HostResponse {
    private String hostname;
    private String clusterName;
    private String ipv4;
    private long cpuCount;
    private long phCpuCount;
    private String osArch;
    private String osFamily;
    private String osType;
    private long totalMemBytes;
    private List<DiskInfo> disksInfo;
    private long lastHeartbeatTime;
    private AgentEnv lastAgentEnv;
    private long lastRegistrationTime;
    private String rackInfo;
    private Map<String, String> hostAttributes;
    private AgentVersion agentVersion;
    private HostHealthStatus healthStatus;
    private RecoveryReport recoveryReport;
    private String recoverySummary = "DISABLED";
    private String publicHostname;
    private HostState hostState;
    private Map<String, HostConfig> desiredHostConfigs;
    private String status;
    private MaintenanceState maintenanceState;

    public HostResponse(String hostname, String clusterName, String ipv4, int cpuCount, int phCpuCount, String osArch, String osType, long totalMemBytes, List<DiskInfo> disksInfo, long lastHeartbeatTime, long lastRegistrationTime, String rackInfo, Map<String, String> hostAttributes, AgentVersion agentVersion, HostHealthStatus healthStatus, HostState hostState, String status) {
        this.hostname = hostname;
        this.clusterName = clusterName;
        this.ipv4 = ipv4;
        this.cpuCount = cpuCount;
        this.phCpuCount = phCpuCount;
        this.osArch = osArch;
        this.osType = osType;
        this.totalMemBytes = totalMemBytes;
        this.disksInfo = disksInfo;
        this.lastHeartbeatTime = lastHeartbeatTime;
        this.lastRegistrationTime = lastRegistrationTime;
        this.rackInfo = rackInfo;
        this.hostAttributes = hostAttributes;
        this.agentVersion = agentVersion;
        this.healthStatus = healthStatus;
        this.hostState = hostState;
        this.status = status;
    }

    public HostResponse(String hostname) {
        this(hostname, "", "", 0, 0, "", "", 0L, new ArrayList<DiskInfo>(), 0L, 0L, "", new HashMap<String, String>(), null, null, null, null);
    }

    @ApiModelProperty(name="host_name")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @ApiModelProperty(name="cluster_name")
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @ApiModelProperty(name="ip")
    public String getIpv4() {
        return this.ipv4;
    }

    public void setIpv4(String ipv4) {
        this.ipv4 = ipv4;
    }

    @ApiModelProperty(name="cpu_count")
    public long getCpuCount() {
        return this.cpuCount;
    }

    public void setCpuCount(long cpuCount) {
        this.cpuCount = cpuCount;
    }

    @ApiModelProperty(name="ph_cpu_count")
    public long getPhCpuCount() {
        return this.phCpuCount;
    }

    public void setPhCpuCount(long phCpuCount) {
        this.phCpuCount = phCpuCount;
    }

    @ApiModelProperty(name="os_arch")
    public String getOsArch() {
        return this.osArch;
    }

    public void setOsArch(String osArch) {
        this.osArch = osArch;
    }

    @ApiModelProperty(name="os_family")
    public String getOsFamily() {
        return this.osFamily;
    }

    public void setOsFamily(String osFamily) {
        this.osFamily = osFamily;
    }

    @ApiModelProperty(name="os_type")
    public String getOsType() {
        return this.osType;
    }

    public void setOsType(String osType) {
        this.osType = osType;
    }

    @ApiModelProperty(name="total_mem")
    public long getTotalMemBytes() {
        return this.totalMemBytes;
    }

    public void setTotalMemBytes(long totalMemBytes) {
        this.totalMemBytes = totalMemBytes;
    }

    @ApiModelProperty(name="disk_info")
    public List<DiskInfo> getDisksInfo() {
        return this.disksInfo;
    }

    public void setDisksInfo(List<DiskInfo> disksInfo) {
        this.disksInfo = disksInfo;
    }

    @ApiModelProperty(name="last_heartbeat_time")
    public long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    public void setLastHeartbeatTime(long lastHeartbeatTime) {
        this.lastHeartbeatTime = lastHeartbeatTime;
    }

    @ApiModelProperty(name="last_registration_time")
    public long getLastRegistrationTime() {
        return this.lastRegistrationTime;
    }

    public void setLastRegistrationTime(long lastRegistrationTime) {
        this.lastRegistrationTime = lastRegistrationTime;
    }

    @ApiModelProperty(name="rack_info")
    public String getRackInfo() {
        return this.rackInfo;
    }

    public void setRackInfo(String rackInfo) {
        this.rackInfo = rackInfo;
    }

    @ApiModelProperty(hidden=true)
    public Map<String, String> getHostAttributes() {
        return this.hostAttributes;
    }

    public void setHostAttributes(Map<String, String> hostAttributes) {
        this.hostAttributes = hostAttributes;
    }

    @ApiModelProperty(hidden=true)
    public AgentVersion getAgentVersion() {
        return this.agentVersion;
    }

    public void setAgentVersion(AgentVersion agentVersion) {
        this.agentVersion = agentVersion;
    }

    @ApiModelProperty(name="host_health_report")
    public String getHealthReport() {
        return this.healthStatus.getHealthReport();
    }

    public void setHealthStatus(HostHealthStatus healthStatus) {
        this.healthStatus = healthStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostResponse other = (HostResponse)o;
        return Objects.equals(this.hostname, other.hostname);
    }

    public int hashCode() {
        return Objects.hashCode(this.hostname);
    }

    @ApiModelProperty(name="public_host_name")
    public String getPublicHostName() {
        return this.publicHostname;
    }

    public void setPublicHostName(String name) {
        this.publicHostname = name;
    }

    @ApiModelProperty(name="host_state")
    public HostState getHostState() {
        return this.hostState;
    }

    public void setHostState(HostState hostState) {
        this.hostState = hostState;
    }

    @ApiModelProperty(name="last_agent_env")
    public AgentEnv getLastAgentEnv() {
        return this.lastAgentEnv;
    }

    public void setLastAgentEnv(AgentEnv agentEnv) {
        this.lastAgentEnv = agentEnv;
    }

    @ApiModelProperty(name="desired_configs")
    public Map<String, HostConfig> getDesiredHostConfigs() {
        return this.desiredHostConfigs;
    }

    public void setDesiredHostConfigs(Map<String, HostConfig> desiredHostConfigs) {
        this.desiredHostConfigs = desiredHostConfigs;
    }

    @ApiModelProperty(name="host_status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMaintenanceState(MaintenanceState state) {
        this.maintenanceState = state;
    }

    @ApiModelProperty(name="maintenance_state")
    public MaintenanceState getMaintenanceState() {
        return this.maintenanceState;
    }

    @ApiModelProperty(name="recovery_summary")
    public String getRecoverySummary() {
        return this.recoverySummary;
    }

    public void setRecoverySummary(String recoverySummary) {
        this.recoverySummary = recoverySummary;
    }

    @ApiModelProperty(name="recovery_report")
    public RecoveryReport getRecoveryReport() {
        return this.recoveryReport;
    }

    public void setRecoveryReport(RecoveryReport recoveryReport) {
        this.recoveryReport = recoveryReport;
    }

    public static interface HostResponseWrapper
    extends ApiModel {
        @ApiModelProperty(name="Hosts")
        public HostResponse getHostResponse();
    }
}

