/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecuteActionRequest {
    private final String clusterName;
    private final String commandName;
    private final List<RequestResourceFilter> resourceFilters;
    private RequestOperationLevel operationLevel = null;
    private String actionName;
    private Map<String, String> parameters;
    private boolean exclusive;

    public ExecuteActionRequest(String clusterName, String commandName, String actionName, List<RequestResourceFilter> resourceFilters, RequestOperationLevel operationLevel, Map<String, String> parameters, boolean exclusive) {
        this(clusterName, commandName, parameters, exclusive);
        this.actionName = actionName;
        if (resourceFilters != null) {
            this.resourceFilters.addAll(resourceFilters);
        }
        this.operationLevel = operationLevel;
    }

    public ExecuteActionRequest(String clusterName, String commandName, Map<String, String> parameters, boolean exclusive) {
        this.clusterName = clusterName;
        this.commandName = commandName;
        this.actionName = null;
        this.parameters = new HashMap<String, String>();
        if (parameters != null) {
            this.parameters.putAll(parameters);
        }
        this.resourceFilters = new ArrayList<RequestResourceFilter>();
        this.exclusive = exclusive;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public List<RequestResourceFilter> getResourceFilters() {
        return this.resourceFilters;
    }

    public RequestOperationLevel getOperationLevel() {
        return this.operationLevel;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.exclusive = isExclusive;
    }

    public Boolean isCommand() {
        return this.actionName == null || this.actionName.isEmpty();
    }

    public synchronized String toString() {
        return "isCommand :" + this.isCommand() + ", action :" + this.actionName + ", command :" + this.commandName + ", inputs :" + this.parameters + ", resourceFilters: " + this.resourceFilters + ", exclusive: " + this.exclusive + ", clusterName :" + this.clusterName;
    }
}

