/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.gson.reflect.TypeToken;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.ActionExecutionContext;
import id.onyx.obdp.server.controller.OBDPCustomCommandExecutionHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.OrderedRequestStageContainer;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.StackServiceRequest;
import id.onyx.obdp.server.controller.StackServiceResponse;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.serveraction.ServerAction;
import id.onyx.obdp.server.serveraction.kerberos.AbstractPrepareKerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.Component;
import id.onyx.obdp.server.serveraction.kerberos.DestroyPrincipalsServerAction;
import id.onyx.obdp.server.serveraction.kerberos.KDCType;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostServerActionEvent;
import id.onyx.obdp.server.utils.StageUtils;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

class DeleteIdentityHandler {
    public static final String COMPONENT_FILTER = "component_filter";
    private final OBDPCustomCommandExecutionHelper customCommandExecutionHelper;
    private final Integer taskTimeout;
    private final StageFactory stageFactory;
    private final OBDPManagementController ambariManagementController;

    public DeleteIdentityHandler(OBDPCustomCommandExecutionHelper customCommandExecutionHelper, Integer taskTimeout, StageFactory stageFactory, OBDPManagementController ambariManagementController) {
        this.customCommandExecutionHelper = customCommandExecutionHelper;
        this.taskTimeout = taskTimeout;
        this.stageFactory = stageFactory;
        this.ambariManagementController = ambariManagementController;
    }

    public void addDeleteIdentityStages(Cluster cluster, OrderedRequestStageContainer stageContainer, CommandParams commandParameters, boolean manageIdentities) throws OBDPException {
        ServiceComponentHostServerActionEvent event = new ServiceComponentHostServerActionEvent(RootComponent.OBDP_SERVER.name(), StageUtils.getHostName(), System.currentTimeMillis());
        String hostParamsJson = StageUtils.getGson().toJson(this.customCommandExecutionHelper.createDefaultHostParams(cluster, cluster.getDesiredStackVersion()));
        if (manageIdentities) {
            this.addPrepareDeleteIdentity(cluster, hostParamsJson, event, commandParameters, stageContainer);
            this.addDeleteKeytab(cluster, commandParameters.getAffectedHostNames(), hostParamsJson, commandParameters, stageContainer);
            this.addDestroyPrincipals(cluster, hostParamsJson, event, commandParameters, stageContainer);
        }
        this.addFinalize(cluster, hostParamsJson, event, stageContainer, commandParameters);
    }

    private void addPrepareDeleteIdentity(Cluster cluster, String hostParamsJson, ServiceComponentHostServerActionEvent event, CommandParams commandParameters, OrderedRequestStageContainer stageContainer) throws OBDPException {
        Stage stage = this.createServerActionStage(stageContainer.getLastStageId(), cluster, stageContainer.getId(), "Prepare delete identities", "{}", hostParamsJson, PrepareDeleteIdentityServerAction.class, event, commandParameters.asMap(), "Prepare delete identities", this.taskTimeout);
        stageContainer.addStage(stage);
    }

    private void addDestroyPrincipals(Cluster cluster, String hostParamsJson, ServiceComponentHostServerActionEvent event, CommandParams commandParameters, OrderedRequestStageContainer stageContainer) throws OBDPException {
        Stage stage = this.createServerActionStage(stageContainer.getLastStageId(), cluster, stageContainer.getId(), "Destroy Principals", "{}", hostParamsJson, DestroyPrincipalsServerAction.class, event, commandParameters.asMap(), "Destroy Principals", Math.max(36000, this.taskTimeout));
        stageContainer.addStage(stage);
    }

    private void addDeleteKeytab(Cluster cluster, Set<String> hostFilter, String hostParamsJson, CommandParams commandParameters, OrderedRequestStageContainer stageContainer) throws OBDPException {
        Set hostNames;
        Set set = hostNames = CollectionUtils.isEmpty(hostFilter) ? null : hostFilter.stream().filter(hostname -> this.ambariManagementController.getClusters().hostExists((String)hostname)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(hostNames)) {
            Stage stage = this.createNewStage(stageContainer.getLastStageId(), cluster, stageContainer.getId(), "Delete Keytabs", commandParameters.asJson(), hostParamsJson);
            HashMap<String, String> requestParams = new HashMap<String, String>();
            ArrayList<RequestResourceFilter> requestResourceFilters = new ArrayList<RequestResourceFilter>();
            RequestResourceFilter reqResFilter = new RequestResourceFilter("KERBEROS", "KERBEROS_CLIENT", new ArrayList<String>(hostNames));
            requestResourceFilters.add(reqResFilter);
            ActionExecutionContext actionExecContext = new ActionExecutionContext(cluster.getClusterName(), "REMOVE_KEYTAB", requestResourceFilters, requestParams);
            this.customCommandExecutionHelper.addExecutionCommandsToStage(actionExecContext, stage, requestParams, null);
            stageContainer.addStage(stage);
        }
    }

    private void addFinalize(Cluster cluster, String hostParamsJson, ServiceComponentHostServerActionEvent event, OrderedRequestStageContainer requestStageContainer, CommandParams commandParameters) throws OBDPException {
        Stage stage = this.createServerActionStage(requestStageContainer.getLastStageId(), cluster, requestStageContainer.getId(), "Finalize Operations", "{}", hostParamsJson, DeleteDataDirAction.class, event, commandParameters.asMap(), "Finalize Operations", 300);
        requestStageContainer.addStage(stage);
    }

    private Stage createNewStage(long id, Cluster cluster, long requestId, String requestContext, String commandParams, String hostParams) {
        Stage stage = this.stageFactory.createNew(requestId, "/tmp/obdp" + File.pathSeparator + requestId, cluster.getClusterName(), cluster.getClusterId(), requestContext, commandParams, hostParams);
        stage.setStageId(id);
        return stage;
    }

    private Stage createServerActionStage(long id, Cluster cluster, long requestId, String requestContext, String commandParams, String hostParams, Class<? extends ServerAction> actionClass, ServiceComponentHostServerActionEvent event, Map<String, String> commandParameters, String commandDetail, Integer timeout) throws OBDPException {
        Stage stage = this.createNewStage(id, cluster, requestId, requestContext, commandParams, hostParams);
        stage.addServerActionCommand(actionClass.getName(), null, Role.AMBARI_SERVER_ACTION, RoleCommand.EXECUTE, cluster.getClusterName(), event, commandParameters, commandDetail, this.ambariManagementController.findConfigurationTagsWithOverrides(cluster, null, null), timeout, false, false);
        return stage;
    }

    public static class CommandParams {
        private final List<Component> components;
        private final Set<String> identities;
        private final String authName;
        private final File dataDirectory;
        private final String defaultRealm;
        private final KDCType kdcType;

        public CommandParams(List<Component> components, Set<String> identities, String authName, File dataDirectory, String defaultRealm, KDCType kdcType) {
            this.components = components;
            this.identities = identities;
            this.authName = authName;
            this.dataDirectory = dataDirectory;
            this.defaultRealm = defaultRealm;
            this.kdcType = kdcType;
        }

        public Map<String, String> asMap() {
            HashMap<String, String> commandParameters = new HashMap<String, String>();
            commandParameters.put("authenticated_user_name", this.authName);
            commandParameters.put("default_realm", this.defaultRealm);
            commandParameters.put("kdc_type", this.kdcType.name());
            commandParameters.put("identity_filter", StageUtils.getGson().toJson(this.identities));
            commandParameters.put(DeleteIdentityHandler.COMPONENT_FILTER, StageUtils.getGson().toJson(this.components));
            commandParameters.put("service_component_filter", StageUtils.getGson().toJson(this.toServiceComponentFilter(this.components)));
            commandParameters.put("host_filter", StageUtils.getGson().toJson(this.toHostFilter(this.components)));
            commandParameters.put("data_directory", this.dataDirectory.getAbsolutePath());
            return commandParameters;
        }

        public Set<String> getAffectedHostNames() {
            return this.components.stream().map(Component::getHostName).collect(Collectors.toSet());
        }

        public String asJson() {
            return StageUtils.getGson().toJson(this.asMap());
        }

        private Map<String, ? extends Collection<String>> toServiceComponentFilter(List<Component> components) {
            if (components == null) {
                return null;
            }
            return components.stream().collect(Collectors.groupingBy(Component::getServiceName, Collectors.mapping(Component::getServiceComponentName, Collectors.toSet())));
        }

        private Set<String> toHostFilter(List<Component> components) {
            if (components == null) {
                return null;
            }
            return components.stream().map(Component::getHostName).collect(Collectors.toSet());
        }
    }

    public static class PrepareDeleteIdentityServerAction
    extends AbstractPrepareKerberosServerAction {
        @Override
        public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
            KerberosDescriptor kerberosDescriptor = this.getKerberosDescriptor();
            this.processServiceComponents(this.getCluster(), kerberosDescriptor, this.componentFilter(), this.getIdentityFilter(), this.dataDirectory(), this.calculateConfig(kerberosDescriptor, this.serviceNames()), new HashMap<String, Map<String, String>>(), false, new HashMap<String, Set<String>>());
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
        }

        private Set<String> serviceNames() {
            return this.componentFilter().stream().map(Component::getServiceName).collect(Collectors.toSet());
        }

        private List<Component> componentFilter() {
            Type jsonType = new TypeToken<List<Component>>(){}.getType();
            return (List)StageUtils.getGson().fromJson(this.getCommandParameterValue(DeleteIdentityHandler.COMPONENT_FILTER), jsonType);
        }

        private Map<String, Map<String, String>> calculateConfig(KerberosDescriptor kerberosDescriptor, Set<String> serviceNames) throws OBDPException {
            Map<String, Map<String, String>> actualConfig = this.getKerberosHelper().calculateConfigurations(this.getCluster(), null, kerberosDescriptor, false, false, null);
            this.extendWithDeletedConfigOfService(actualConfig, serviceNames);
            return actualConfig;
        }

        private void extendWithDeletedConfigOfService(Map<String, Map<String, String>> configToBeExtended, Set<String> serviceNames) throws OBDPException {
            Set<String> deletedConfigTypes = serviceNames.stream().flatMap(serviceName -> this.configTypesOfService((String)serviceName).stream()).collect(Collectors.toSet());
            for (Config deletedConfig : this.getCluster().getLatestConfigsWithTypes(deletedConfigTypes)) {
                configToBeExtended.put(deletedConfig.getType(), deletedConfig.getProperties());
            }
        }

        private Set<String> configTypesOfService(String serviceName) {
            try {
                StackId stackId = this.getCluster().getCurrentStackVersion();
                StackServiceRequest stackServiceRequest = new StackServiceRequest(stackId.getStackName(), stackId.getStackVersion(), serviceName);
                return ((StackServiceResponse)OBDPServer.getController().getStackServices(Collections.singleton(stackServiceRequest)).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find stack service " + serviceName))).getConfigTypes().keySet();
            }
            catch (OBDPException e) {
                throw new RuntimeException(e);
            }
        }

        private String dataDirectory() {
            return PrepareDeleteIdentityServerAction.getCommandParameterValue(this.getCommandParameters(), "data_directory");
        }

        private KerberosDescriptor getKerberosDescriptor() throws OBDPException {
            return this.getKerberosHelper().getKerberosDescriptor(this.getCluster(), false);
        }

        @Override
        protected boolean pruneServiceFilter() {
            return false;
        }
    }

    private static class DeleteDataDirAction
    extends KerberosServerAction {
        private DeleteDataDirAction() {
        }

        @Override
        public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
            this.deleteDataDirectory(this.getCommandParameterValue("data_directory"));
            return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
        }

        @Override
        protected boolean pruneServiceFilter() {
            return false;
        }

        @Override
        protected CommandReport processIdentity(ResolvedKerberosPrincipal resolvedPrincipal, KerberosOperationHandler operationHandler, Map<String, String> kerberosConfiguration, boolean includedInFilter, Map<String, Object> requestSharedDataContext) throws OBDPException {
            return null;
        }
    }
}

