/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.persist.PersistModule;
import com.google.inject.persist.jpa.OBDPJpaPersistModule;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import id.onyx.obdp.server.EagerSingleton;
import id.onyx.obdp.server.OBDPService;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.ActionDBAccessor;
import id.onyx.obdp.server.actionmanager.ActionDBAccessorImpl;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapperFactory;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactoryImpl;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.actionmanager.StageFactoryImpl;
import id.onyx.obdp.server.checks.DatabaseConsistencyCheckHelper;
import id.onyx.obdp.server.checks.UpgradeCheckRegistry;
import id.onyx.obdp.server.checks.UpgradeCheckRegistryProvider;
import id.onyx.obdp.server.cleanup.ClasspathScannerUtils;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.configuration.OBDPServerConfiguration;
import id.onyx.obdp.server.controller.AbstractRootServiceResponseFactory;
import id.onyx.obdp.server.controller.HostsMap;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.KerberosHelperImpl;
import id.onyx.obdp.server.controller.OBDPCustomCommandExecutionHelper;
import id.onyx.obdp.server.controller.OBDPHandlerList;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPManagementControllerImpl;
import id.onyx.obdp.server.controller.ResourceProviderFactory;
import id.onyx.obdp.server.controller.RootServiceResponseFactory;
import id.onyx.obdp.server.controller.internal.AlertTargetResourceProvider;
import id.onyx.obdp.server.controller.internal.AuthResourceProvider;
import id.onyx.obdp.server.controller.internal.ClusterStackVersionResourceProvider;
import id.onyx.obdp.server.controller.internal.ComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.CredentialResourceProvider;
import id.onyx.obdp.server.controller.internal.HostComponentResourceProvider;
import id.onyx.obdp.server.controller.internal.HostKerberosIdentityResourceProvider;
import id.onyx.obdp.server.controller.internal.HostResourceProvider;
import id.onyx.obdp.server.controller.internal.KerberosDescriptorResourceProvider;
import id.onyx.obdp.server.controller.internal.MemberResourceProvider;
import id.onyx.obdp.server.controller.internal.RepositoryVersionResourceProvider;
import id.onyx.obdp.server.controller.internal.RootServiceComponentConfigurationResourceProvider;
import id.onyx.obdp.server.controller.internal.ServiceResourceProvider;
import id.onyx.obdp.server.controller.internal.UpgradeResourceProvider;
import id.onyx.obdp.server.controller.internal.UserAuthenticationSourceResourceProvider;
import id.onyx.obdp.server.controller.internal.UserResourceProvider;
import id.onyx.obdp.server.controller.internal.ViewInstanceResourceProvider;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelperFactory;
import id.onyx.obdp.server.controller.logging.LoggingRequestHelperFactoryImpl;
import id.onyx.obdp.server.controller.metrics.MetricPropertyProviderFactory;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheEntryFactory;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheProvider;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.utilities.KerberosChecker;
import id.onyx.obdp.server.events.AgentConfigsUpdateEvent;
import id.onyx.obdp.server.events.OBDPEvent;
import id.onyx.obdp.server.hooks.AmbariEventFactory;
import id.onyx.obdp.server.hooks.HookContext;
import id.onyx.obdp.server.hooks.HookContextFactory;
import id.onyx.obdp.server.hooks.HookService;
import id.onyx.obdp.server.hooks.users.PostUserCreationHookContext;
import id.onyx.obdp.server.hooks.users.UserCreatedEvent;
import id.onyx.obdp.server.hooks.users.UserHookService;
import id.onyx.obdp.server.metadata.CachedRoleCommandOrderProvider;
import id.onyx.obdp.server.metadata.RoleCommandOrderProvider;
import id.onyx.obdp.server.metrics.system.MetricsService;
import id.onyx.obdp.server.metrics.system.impl.MetricsServiceImpl;
import id.onyx.obdp.server.mpack.MpackManagerFactory;
import id.onyx.obdp.server.notifications.DispatchFactory;
import id.onyx.obdp.server.notifications.NotificationDispatcher;
import id.onyx.obdp.server.notifications.dispatchers.AlertScriptDispatcher;
import id.onyx.obdp.server.notifications.dispatchers.AmbariSNMPDispatcher;
import id.onyx.obdp.server.notifications.dispatchers.SNMPDispatcher;
import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.DBAccessorImpl;
import id.onyx.obdp.server.orm.PersistenceType;
import id.onyx.obdp.server.scheduler.ExecutionScheduler;
import id.onyx.obdp.server.scheduler.ExecutionSchedulerImpl;
import id.onyx.obdp.server.security.SecurityHelper;
import id.onyx.obdp.server.security.SecurityHelperImpl;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.internal.InternalAuthenticationInterceptor;
import id.onyx.obdp.server.security.authorization.internal.RunWithInternalSecurityContext;
import id.onyx.obdp.server.security.encryption.AESEncryptionService;
import id.onyx.obdp.server.security.encryption.AgentConfigUpdateEncryptor;
import id.onyx.obdp.server.security.encryption.ConfigPropertiesEncryptor;
import id.onyx.obdp.server.security.encryption.CredentialStoreService;
import id.onyx.obdp.server.security.encryption.CredentialStoreServiceImpl;
import id.onyx.obdp.server.security.encryption.EncryptionService;
import id.onyx.obdp.server.security.encryption.Encryptor;
import id.onyx.obdp.server.security.encryption.OBDPServerConfigurationEncryptor;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandlerFactory;
import id.onyx.obdp.server.serveraction.users.CollectionPersisterService;
import id.onyx.obdp.server.serveraction.users.CollectionPersisterServiceFactory;
import id.onyx.obdp.server.serveraction.users.CsvFilePersisterService;
import id.onyx.obdp.server.stack.StackManagerFactory;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContextFactory;
import id.onyx.obdp.server.stageplanner.RoleGraphFactory;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.ConfigFactory;
import id.onyx.obdp.server.state.ConfigImpl;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentFactory;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceComponentHostFactory;
import id.onyx.obdp.server.state.ServiceComponentImpl;
import id.onyx.obdp.server.state.ServiceFactory;
import id.onyx.obdp.server.state.ServiceImpl;
import id.onyx.obdp.server.state.cluster.ClusterFactory;
import id.onyx.obdp.server.state.cluster.ClusterImpl;
import id.onyx.obdp.server.state.cluster.ClustersImpl;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import id.onyx.obdp.server.state.configgroup.ConfigGroupFactory;
import id.onyx.obdp.server.state.configgroup.ConfigGroupImpl;
import id.onyx.obdp.server.state.host.HostFactory;
import id.onyx.obdp.server.state.host.HostImpl;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptorFactory;
import id.onyx.obdp.server.state.scheduler.RequestExecution;
import id.onyx.obdp.server.state.scheduler.RequestExecutionFactory;
import id.onyx.obdp.server.state.scheduler.RequestExecutionImpl;
import id.onyx.obdp.server.state.stack.OsFamily;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostImpl;
import id.onyx.obdp.server.topology.BlueprintFactory;
import id.onyx.obdp.server.topology.DefaultStackFactory;
import id.onyx.obdp.server.topology.PersistedState;
import id.onyx.obdp.server.topology.PersistedStateImpl;
import id.onyx.obdp.server.topology.SecurityConfigurationFactory;
import id.onyx.obdp.server.topology.StackFactory;
import id.onyx.obdp.server.topology.addservice.RequestValidatorFactory;
import id.onyx.obdp.server.topology.tasks.ConfigureClusterTaskFactory;
import id.onyx.obdp.server.utils.PasswordUtils;
import id.onyx.obdp.server.utils.ThreadPools;
import id.onyx.obdp.server.view.ViewInstanceHandlerList;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.eclipse.jetty.server.session.SessionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.StandardPasswordEncoder;
import org.springframework.util.ClassUtils;
import org.springframework.web.filter.DelegatingFilterProxy;

public class ControllerModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerModule.class);
    private static final String AMBARI_PACKAGE = "id.onyx.obdp.server";
    private final Configuration configuration;
    private final OsFamily os_family;
    private final HostsMap hostsMap;
    private final ThreadPools threadPools;
    private boolean dbInitNeeded;
    private final Gson prettyGson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();

    public ControllerModule() throws Exception {
        this.configuration = new Configuration();
        this.hostsMap = new HostsMap(this.configuration);
        this.os_family = new OsFamily(this.configuration);
        this.threadPools = new ThreadPools(this.configuration);
    }

    public ControllerModule(Properties properties) throws Exception {
        this.configuration = new Configuration(properties);
        this.hostsMap = new HostsMap(this.configuration);
        this.os_family = new OsFamily(this.configuration);
        this.threadPools = new ThreadPools(this.configuration);
    }

    public static Properties getPersistenceProperties(Configuration configuration) {
        Properties properties = new Properties();
        Configuration.DatabaseType databaseType = configuration.getDatabaseType();
        LOG.info("Detected {} as the database type from the JDBC URL", (Object)databaseType);
        switch (configuration.getPersistenceType()) {
            case IN_MEMORY: {
                properties.setProperty("jakarta.persistence.jdbc.url", Configuration.JDBC_IN_MEMORY_URL);
                properties.setProperty("jakarta.persistence.jdbc.driver", "org.h2.Driver");
                properties.setProperty("jakarta.persistence.jdbc.user", "sa");
                properties.setProperty("jakarta.persistence.jdbc.password", "");
                properties.setProperty("eclipselink.ddl-generation", "create-tables");
                properties.setProperty("eclipselink.orm.throw.exceptions", "true");
                break;
            }
            case REMOTE: {
                properties.setProperty("jakarta.persistence.jdbc.url", configuration.getDatabaseUrl());
                properties.setProperty("jakarta.persistence.jdbc.driver", configuration.getDatabaseDriver());
                break;
            }
            case LOCAL: {
                properties.setProperty("jakarta.persistence.jdbc.url", configuration.getLocalDatabaseUrl());
                properties.setProperty("jakarta.persistence.jdbc.driver", Configuration.SERVER_JDBC_DRIVER.getDefaultValue());
            }
        }
        Properties customDatabaseDriverProperties = configuration.getDatabaseCustomProperties();
        properties.putAll((Map<?, ?>)customDatabaseDriverProperties);
        Properties customPersistenceProperties = configuration.getPersistenceCustomProperties();
        properties.putAll((Map<?, ?>)customPersistenceProperties);
        boolean isConnectionPoolingExternal = false;
        Configuration.ConnectionPoolType connectionPoolType = configuration.getConnectionPoolType();
        if (connectionPoolType == Configuration.ConnectionPoolType.C3P0) {
            isConnectionPoolingExternal = true;
        }
        if (databaseType == Configuration.DatabaseType.MYSQL) {
            isConnectionPoolingExternal = true;
        }
        if (isConnectionPoolingExternal) {
            LOG.info("Using c3p0 {} as the EclipsLink DataSource", (Object)ComboPooledDataSource.class.getSimpleName());
            String testQuery = "SELECT 1";
            if (databaseType == Configuration.DatabaseType.ORACLE) {
                testQuery = "SELECT 1 FROM DUAL";
            }
            ComboPooledDataSource dataSource = new ComboPooledDataSource();
            try {
                dataSource.setDriverClass(configuration.getDatabaseDriver());
            }
            catch (PropertyVetoException pve) {
                LOG.warn("Unable to initialize c3p0", (Throwable)pve);
                return properties;
            }
            dataSource.setJdbcUrl(configuration.getDatabaseUrl());
            dataSource.setUser(configuration.getDatabaseUser());
            dataSource.setPassword(configuration.getDatabasePassword());
            dataSource.setMinPoolSize(configuration.getConnectionPoolMinimumSize());
            dataSource.setInitialPoolSize(configuration.getConnectionPoolMinimumSize());
            dataSource.setMaxPoolSize(configuration.getConnectionPoolMaximumSize());
            dataSource.setAcquireIncrement(configuration.getConnectionPoolAcquisitionSize());
            dataSource.setAcquireRetryAttempts(configuration.getConnectionPoolAcquisitionRetryAttempts());
            dataSource.setAcquireRetryDelay(configuration.getConnectionPoolAcquisitionRetryDelay());
            dataSource.setMaxConnectionAge(configuration.getConnectionPoolMaximumAge());
            dataSource.setMaxIdleTime(configuration.getConnectionPoolMaximumIdle());
            dataSource.setMaxIdleTimeExcessConnections(configuration.getConnectionPoolMaximumExcessIdle());
            dataSource.setPreferredTestQuery(testQuery);
            dataSource.setIdleConnectionTestPeriod(configuration.getConnectionPoolIdleTestInternval());
            properties.put("jakarta.persistence.nonJtaDataSource", dataSource);
        }
        return properties;
    }

    protected void configure() {
        this.installFactories();
        SessionHandler sessionHandler = new SessionHandler();
        this.bind(SessionHandler.class).toInstance((Object)sessionHandler);
        this.bind(KerberosOperationHandlerFactory.class);
        this.bind(KerberosDescriptorFactory.class);
        this.bind(KerberosServiceDescriptorFactory.class);
        this.bind(KerberosHelper.class).to(KerberosHelperImpl.class);
        this.bind(CredentialStoreService.class).to(CredentialStoreServiceImpl.class);
        this.bind(EncryptionService.class).to(AESEncryptionService.class);
        if (this.configuration.shouldEncryptSensitiveData()) {
            this.bind((TypeLiteral)new TypeLiteral<Encryptor<Config>>(){}).annotatedWith((Annotation)Names.named((String)"ConfigPropertiesEncryptor")).to(ConfigPropertiesEncryptor.class);
            this.bind((TypeLiteral)new TypeLiteral<Encryptor<AgentConfigsUpdateEvent>>(){}).annotatedWith((Annotation)Names.named((String)"AgentConfigEncryptor")).to(AgentConfigUpdateEncryptor.class);
            this.bind((TypeLiteral)new TypeLiteral<Encryptor<OBDPServerConfiguration>>(){}).annotatedWith((Annotation)Names.named((String)"OBDPServerConfigurationEncryptor")).to(OBDPServerConfigurationEncryptor.class);
        } else {
            this.bind((TypeLiteral)new TypeLiteral<Encryptor<Config>>(){}).annotatedWith((Annotation)Names.named((String)"ConfigPropertiesEncryptor")).toInstance((Object)Encryptor.NONE);
            this.bind((TypeLiteral)new TypeLiteral<Encryptor<AgentConfigsUpdateEvent>>(){}).annotatedWith((Annotation)Names.named((String)"AgentConfigEncryptor")).toInstance((Object)Encryptor.NONE);
            this.bind((TypeLiteral)new TypeLiteral<Encryptor<OBDPServerConfiguration>>(){}).annotatedWith((Annotation)Names.named((String)"OBDPServerConfigurationEncryptor")).toInstance((Object)Encryptor.NONE);
        }
        this.bind(Configuration.class).toInstance((Object)this.configuration);
        this.bind(OsFamily.class).toInstance((Object)this.os_family);
        this.bind(ThreadPools.class).toInstance((Object)this.threadPools);
        this.bind(HostsMap.class).toInstance((Object)this.hostsMap);
        this.bind(PasswordEncoder.class).toInstance((Object)new StandardPasswordEncoder());
        this.bind(DelegatingFilterProxy.class).toInstance((Object)new DelegatingFilterProxy(){
            {
                this.setTargetBeanName("springSecurityFilterChain");
            }
        });
        this.bind(Gson.class).annotatedWith((Annotation)Names.named((String)"prettyGson")).toInstance((Object)this.prettyGson);
        this.install((Module)this.buildJpaPersistModule());
        this.bind(Gson.class).in(Scopes.SINGLETON);
        this.bind(SecureRandom.class).in(Scopes.SINGLETON);
        this.bind(Clusters.class).to(ClustersImpl.class);
        this.bind(OBDPCustomCommandExecutionHelper.class);
        this.bind(ActionDBAccessor.class).to(ActionDBAccessorImpl.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"schedulerSleeptime")).to(this.configuration.getExecutionSchedulerWait().longValue());
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"actionTimeout")).to(600000L);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"alertServiceCorePoolSize")).to(this.configuration.getAlertServiceCorePoolSize());
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"dbInitNeeded")).to(this.dbInitNeeded);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"statusCheckInterval")).to(5000L);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"executionCommandCacheSize")).to(this.configuration.getExecutionCommandsCacheSize());
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"hostRoleCommandStatusSummaryCacheEnabled")).to(this.configuration.getHostRoleCommandStatusSummaryCacheEnabled());
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"hostRoleCommandStatusSummaryCacheSize")).to(this.configuration.getHostRoleCommandStatusSummaryCacheSize());
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"hostRoleCommandStatusCacheExpiryDurationMins")).to(this.configuration.getHostRoleCommandStatusSummaryCacheExpiryDuration());
        this.bind(OBDPManagementController.class).to(OBDPManagementControllerImpl.class);
        this.bind(AbstractRootServiceResponseFactory.class).to(RootServiceResponseFactory.class);
        this.bind(ExecutionScheduler.class).to(ExecutionSchedulerImpl.class);
        this.bind(DBAccessor.class).to(DBAccessorImpl.class);
        this.bind(ViewInstanceHandlerList.class).to(OBDPHandlerList.class);
        this.bind(TimelineMetricCacheProvider.class);
        this.bind(TimelineMetricCacheEntryFactory.class);
        this.bind(SecurityConfigurationFactory.class).in(Scopes.SINGLETON);
        this.bind(PersistedState.class).to(PersistedStateImpl.class);
        this.bind(LoggingRequestHelperFactory.class).to(LoggingRequestHelperFactoryImpl.class);
        this.bind(MetricsService.class).to(MetricsServiceImpl.class).in(Scopes.SINGLETON);
        this.requestStaticInjection(new Class[]{DatabaseConsistencyCheckHelper.class});
        this.requestStaticInjection(new Class[]{KerberosChecker.class});
        this.requestStaticInjection(new Class[]{AuthorizationHelper.class});
        this.requestStaticInjection(new Class[]{PasswordUtils.class});
        this.bindByAnnotation(null);
        this.bindNotificationDispatchers(null);
        this.bind(UpgradeCheckRegistry.class).toProvider(UpgradeCheckRegistryProvider.class).in(Singleton.class);
        this.bind(HookService.class).to(UserHookService.class);
        InternalAuthenticationInterceptor ambariAuthenticationInterceptor = new InternalAuthenticationInterceptor();
        this.requestInjection(ambariAuthenticationInterceptor);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(RunWithInternalSecurityContext.class), new MethodInterceptor[]{ambariAuthenticationInterceptor});
    }

    private PersistModule buildJpaPersistModule() {
        PersistenceType persistenceType = this.configuration.getPersistenceType();
        OBDPJpaPersistModule jpaPersistModule = new OBDPJpaPersistModule("obdp-server");
        Properties persistenceProperties = ControllerModule.getPersistenceProperties(this.configuration);
        if (!persistenceType.equals((Object)PersistenceType.IN_MEMORY)) {
            persistenceProperties.setProperty("jakarta.persistence.jdbc.user", this.configuration.getDatabaseUser());
            persistenceProperties.setProperty("jakarta.persistence.jdbc.password", this.configuration.getDatabasePassword());
            switch (this.configuration.getJPATableGenerationStrategy()) {
                case CREATE: {
                    persistenceProperties.setProperty("eclipselink.ddl-generation", "create-tables");
                    this.dbInitNeeded = true;
                    break;
                }
                case DROP_AND_CREATE: {
                    persistenceProperties.setProperty("eclipselink.ddl-generation", "drop-and-create-tables");
                    this.dbInitNeeded = true;
                    break;
                }
                case CREATE_OR_EXTEND: {
                    persistenceProperties.setProperty("eclipselink.ddl-generation", "create-or-extend-tables");
                    break;
                }
            }
            persistenceProperties.setProperty("eclipselink.ddl-generation.output-mode", "both");
            persistenceProperties.setProperty("eclipselink.create-ddl-jdbc-file-name", "DDL-create.jdbc");
            persistenceProperties.setProperty("eclipselink.drop-ddl-jdbc-file-name", "DDL-drop.jdbc");
        }
        jpaPersistModule.properties(persistenceProperties);
        return jpaPersistModule;
    }

    private void installFactories() {
        this.install(new FactoryModuleBuilder().implement(Cluster.class, ClusterImpl.class).build(ClusterFactory.class));
        this.install(new FactoryModuleBuilder().implement(Host.class, HostImpl.class).build(HostFactory.class));
        this.install(new FactoryModuleBuilder().implement(id.onyx.obdp.server.state.Service.class, ServiceImpl.class).build(ServiceFactory.class));
        this.install(new FactoryModuleBuilder().implement(ResourceProvider.class, (Annotation)Names.named((String)"host"), HostResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"hostComponent"), HostComponentResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"service"), ServiceResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"component"), ComponentResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"member"), MemberResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"repositoryVersion"), RepositoryVersionResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"hostKerberosIdentity"), HostKerberosIdentityResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"user"), UserResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"userAuthenticationSource"), UserAuthenticationSourceResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"credential"), CredentialResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"kerberosDescriptor"), KerberosDescriptorResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"upgrade"), UpgradeResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"clusterStackVersion"), ClusterStackVersionResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"alertTarget"), AlertTargetResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"viewInstance"), ViewInstanceResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"rootServiceHostComponentConfiguration"), RootServiceComponentConfigurationResourceProvider.class).implement(ResourceProvider.class, (Annotation)Names.named((String)"auth"), AuthResourceProvider.class).build(ResourceProviderFactory.class));
        this.install(new FactoryModuleBuilder().implement(ServiceComponent.class, ServiceComponentImpl.class).build(ServiceComponentFactory.class));
        this.install(new FactoryModuleBuilder().implement(ServiceComponentHost.class, ServiceComponentHostImpl.class).build(ServiceComponentHostFactory.class));
        this.install(new FactoryModuleBuilder().implement(Config.class, ConfigImpl.class).build(ConfigFactory.class));
        this.install(new FactoryModuleBuilder().implement(ConfigGroup.class, ConfigGroupImpl.class).build(ConfigGroupFactory.class));
        this.install(new FactoryModuleBuilder().implement(RequestExecution.class, RequestExecutionImpl.class).build(RequestExecutionFactory.class));
        this.bind(StageFactory.class).to(StageFactoryImpl.class);
        this.bind(RoleCommandOrderProvider.class).to(CachedRoleCommandOrderProvider.class);
        this.install(new FactoryModuleBuilder().build(RoleGraphFactory.class));
        this.install(new FactoryModuleBuilder().build(RequestFactory.class));
        this.install(new FactoryModuleBuilder().build(StackManagerFactory.class));
        this.install(new FactoryModuleBuilder().build(ExecutionCommandWrapperFactory.class));
        this.install(new FactoryModuleBuilder().build(MetricPropertyProviderFactory.class));
        this.install(new FactoryModuleBuilder().build(UpgradeContextFactory.class));
        this.install(new FactoryModuleBuilder().build(MpackManagerFactory.class));
        this.install(new FactoryModuleBuilder().build(RequestValidatorFactory.class));
        this.bind(HostRoleCommandFactory.class).to(HostRoleCommandFactoryImpl.class);
        this.bind(SecurityHelper.class).toInstance((Object)SecurityHelperImpl.getInstance());
        this.bind(StackFactory.class).to(DefaultStackFactory.class);
        this.bind(BlueprintFactory.class);
        this.install(new FactoryModuleBuilder().implement(OBDPEvent.class, (Annotation)Names.named((String)"userCreated"), UserCreatedEvent.class).build(AmbariEventFactory.class));
        this.install(new FactoryModuleBuilder().implement(HookContext.class, PostUserCreationHookContext.class).build(HookContextFactory.class));
        this.install(new FactoryModuleBuilder().implement(CollectionPersisterService.class, CsvFilePersisterService.class).build(CollectionPersisterServiceFactory.class));
        this.install(new FactoryModuleBuilder().build(ConfigureClusterTaskFactory.class));
    }

    protected Set<Class<?>> bindByAnnotation(Set<Class<?>> matchedClasses) {
        if (null == matchedClasses) {
            ArrayList classes = new ArrayList();
            classes.add(EagerSingleton.class);
            classes.add(StaticallyInject.class);
            classes.add(OBDPService.class);
            LOG.info("Searching package {} for annotations matching {}", (Object)AMBARI_PACKAGE, classes);
            matchedClasses = ClasspathScannerUtils.findOnClassPath(AMBARI_PACKAGE, new ArrayList(), classes);
            if (null == matchedClasses || matchedClasses.size() == 0) {
                LOG.warn("No instances of {} found to register", classes);
                return matchedClasses;
            }
        }
        HashSet<Service> services = new HashSet<Service>();
        for (Class<?> clazz : matchedClasses) {
            if (null != clazz.getAnnotation(EagerSingleton.class)) {
                this.bind(clazz).asEagerSingleton();
                LOG.debug("Eagerly binding singleton {}", clazz);
            }
            if (null != clazz.getAnnotation(StaticallyInject.class)) {
                this.requestStaticInjection(new Class[]{clazz});
                LOG.debug("Statically injecting {} ", clazz);
            }
            if (null == clazz.getAnnotation(OBDPService.class)) continue;
            if (!Service.class.isAssignableFrom(clazz)) {
                String message = MessageFormat.format("Unable to register service {0} because it is not a Service which can be scheduled", clazz);
                LOG.error(message);
                throw new RuntimeException(message);
            }
            Service service = null;
            try {
                service = (Service)clazz.newInstance();
                this.bind(clazz).toInstance((Object)service);
                services.add(service);
                LOG.info("Registering service {} ", clazz);
            }
            catch (Exception exception) {
                LOG.error("Unable to register {} as a service", clazz, (Object)exception);
                throw new RuntimeException(exception);
            }
        }
        ServiceManager manager = new ServiceManager(services);
        this.bind(ServiceManager.class).toInstance((Object)manager);
        return matchedClasses;
    }

    protected Set<BeanDefinition> bindNotificationDispatchers(Set<BeanDefinition> beanDefinitions) {
        DispatchFactory dispatchFactory = DispatchFactory.getInstance();
        this.bind(DispatchFactory.class).toInstance((Object)dispatchFactory);
        if (null == beanDefinitions || beanDefinitions.isEmpty()) {
            String packageName = AlertScriptDispatcher.class.getPackage().getName();
            LOG.info("Searching package {} for dispatchers matching {}", (Object)packageName, NotificationDispatcher.class);
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            AssignableTypeFilter filter = new AssignableTypeFilter(NotificationDispatcher.class);
            scanner.addIncludeFilter((TypeFilter)filter);
            beanDefinitions = scanner.findCandidateComponents(packageName);
        }
        if (null == beanDefinitions || beanDefinitions.size() == 0) {
            LOG.error("No instances of {} found to register", NotificationDispatcher.class);
            return null;
        }
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String className = beanDefinition.getBeanClassName();
            if (className != null) {
                Class clazz = ClassUtils.resolveClassName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
                try {
                    NotificationDispatcher dispatcher = clazz.equals(AmbariSNMPDispatcher.class) ? (NotificationDispatcher)clazz.getConstructor(Integer.class).newInstance(this.configuration.getAmbariSNMPUdpBindPort()) : (clazz.equals(SNMPDispatcher.class) ? (NotificationDispatcher)clazz.getConstructor(Integer.class).newInstance(this.configuration.getSNMPUdpBindPort()) : (NotificationDispatcher)clazz.newInstance());
                    dispatchFactory.register(dispatcher.getType(), dispatcher);
                    this.bind(clazz).toInstance((Object)dispatcher);
                    LOG.info("Binding and registering notification dispatcher {}", (Object)clazz);
                }
                catch (Exception exception) {
                    LOG.error("Unable to bind and register notification dispatcher {}", (Object)clazz, (Object)exception);
                }
                continue;
            }
            LOG.error("Binding and registering notification dispatcher is not possible for beanDefinition: {} in the absence of className", (Object)beanDefinition);
        }
        return beanDefinitions;
    }
}

