/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.utils.SecretReference;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigurationResponse {
    private final String clusterName;
    private final StackId stackId;
    private final String type;
    private String versionTag;
    private Long version;
    private List<Long> serviceConfigVersions;
    private Map<String, String> configs;
    private Map<String, Map<String, String>> configAttributes;
    private Map<PropertyInfo.PropertyType, Set<String>> propertiesTypes;

    public ConfigurationResponse(String clusterName, StackId stackId, String type, String versionTag, Long version, Map<String, String> configs, Map<String, Map<String, String>> configAttributes) {
        this.clusterName = clusterName;
        this.stackId = stackId;
        this.configs = configs;
        this.type = type;
        this.versionTag = versionTag;
        this.version = version;
        this.configAttributes = configAttributes;
        SecretReference.replacePasswordsWithReferencesForCustomProperties(configAttributes, configs, type, version);
    }

    public ConfigurationResponse(String clusterName, StackId stackId, String type, String versionTag, Long version, Map<String, String> configs, Map<String, Map<String, String>> configAttributes, Map<PropertyInfo.PropertyType, Set<String>> propertiesTypes) {
        this.clusterName = clusterName;
        this.stackId = stackId;
        this.configs = configs;
        this.type = type;
        this.versionTag = versionTag;
        this.version = version;
        this.configAttributes = configAttributes;
        this.propertiesTypes = propertiesTypes;
        SecretReference.replacePasswordsWithReferences(propertiesTypes, configs, type, version);
        SecretReference.replacePasswordsWithReferencesForCustomProperties(configAttributes, configs, type, version);
    }

    public ConfigurationResponse(String clusterName, Config config) {
        this(clusterName, config.getStackId(), config.getType(), config.getTag(), config.getVersion(), config.getProperties(), config.getPropertiesAttributes(), config.getPropertiesTypes());
    }

    @ApiModelProperty(name="tag")
    public String getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    @ApiModelProperty(name="properties")
    public Map<String, String> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<String, String> configs) {
        this.configs = configs;
    }

    @ApiModelProperty(name="properties_attributes")
    public Map<String, Map<String, String>> getConfigAttributes() {
        return this.configAttributes;
    }

    public void setConfigAttributes(Map<String, Map<String, String>> configAttributes) {
        this.configAttributes = configAttributes;
    }

    @ApiModelProperty(name="type")
    public String getType() {
        return this.type;
    }

    @ApiModelProperty(name="Config/cluster_name")
    public String getClusterName() {
        return this.clusterName;
    }

    @ApiModelProperty(name="version")
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    @ApiModelProperty(name="Config/stack_id", dataType="String")
    public StackId getStackId() {
        return this.stackId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationResponse that = (ConfigurationResponse)o;
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.stackId != null ? !this.stackId.equals(that.stackId) : that.stackId != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.clusterName != null ? this.clusterName.hashCode() : 0;
        result = 31 * result + (this.stackId != null ? this.stackId.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    @ApiModelProperty(hidden=true)
    public List<Long> getServiceConfigVersions() {
        return this.serviceConfigVersions;
    }

    public void setServiceConfigVersions(List<Long> serviceConfigVersions) {
        this.serviceConfigVersions = serviceConfigVersions;
    }

    @ApiModelProperty(hidden=true)
    public Map<PropertyInfo.PropertyType, Set<String>> getPropertiesTypes() {
        return this.propertiesTypes;
    }

    public void setPropertiesTypes(Map<PropertyInfo.PropertyType, Set<String>> propertiesTypes) {
        this.propertiesTypes = propertiesTypes;
    }
}

