/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.controller.ApiModel;
import id.onyx.obdp.server.controller.ServiceConfigVersionResponse;
import id.onyx.obdp.server.state.ClusterHealthReport;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.State;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ClusterResponse {
    private final long clusterId;
    private final String clusterName;
    private final Set<String> hostNames;
    private final String desiredStackVersion;
    private final State provisioningState;
    private final SecurityType securityType;
    private final int totalHosts;
    private Map<String, DesiredConfig> desiredConfigs;
    private Map<String, Collection<ServiceConfigVersionResponse>> desiredServiceConfigVersions;
    private ClusterHealthReport clusterHealthReport;
    private Map<String, String> credentialStoreServiceProperties;

    public ClusterResponse(long clusterId, String clusterName, State provisioningState, SecurityType securityType, Set<String> hostNames, int totalHosts, String desiredStackVersion, ClusterHealthReport clusterHealthReport) {
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.hostNames = hostNames;
        this.totalHosts = totalHosts;
        this.desiredStackVersion = desiredStackVersion;
        this.clusterHealthReport = clusterHealthReport;
        this.provisioningState = null != provisioningState ? provisioningState : State.UNKNOWN;
        this.securityType = null == securityType ? SecurityType.NONE : securityType;
    }

    @ApiModelProperty(name="cluster_id")
    public long getClusterId() {
        return this.clusterId;
    }

    @ApiModelProperty(name="cluster_name")
    public String getClusterName() {
        return this.clusterName;
    }

    @ApiModelProperty(name="provisioning_state")
    public State getProvisioningState() {
        return this.provisioningState;
    }

    @ApiModelProperty(name="security_type")
    public SecurityType getSecurityType() {
        return this.securityType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ clusterName=").append(this.clusterName).append(", clusterId=").append(this.clusterId).append(", provisioningState=").append((Object)this.provisioningState).append(", desiredStackVersion=").append(this.desiredStackVersion).append(", totalHosts=").append(this.totalHosts).append(", hosts=[");
        if (this.hostNames != null) {
            int i = 0;
            for (String hostName : this.hostNames) {
                if (i != 0) {
                    sb.append(",");
                }
                ++i;
                sb.append(hostName);
            }
        }
        sb.append("], clusterHealthReport= ").append(this.clusterHealthReport).append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterResponse other = (ClusterResponse)o;
        return Objects.equals(this.clusterId, other.clusterId) && Objects.equals(this.clusterName, other.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.clusterId, this.clusterName);
    }

    @ApiModelProperty(name="version")
    public String getDesiredStackVersion() {
        return this.desiredStackVersion;
    }

    public void setDesiredConfigs(Map<String, DesiredConfig> configs) {
        this.desiredConfigs = configs;
    }

    @ApiModelProperty(name="desired_configs")
    public Map<String, DesiredConfig> getDesiredConfigs() {
        return this.desiredConfigs;
    }

    @ApiModelProperty(name="total_hosts")
    public int getTotalHosts() {
        return this.totalHosts;
    }

    @ApiModelProperty(name="health_report")
    public ClusterHealthReport getClusterHealthReport() {
        return this.clusterHealthReport;
    }

    @ApiModelProperty(name="desired_service_config_versions")
    public Map<String, Collection<ServiceConfigVersionResponse>> getDesiredServiceConfigVersions() {
        return this.desiredServiceConfigVersions;
    }

    public void setDesiredServiceConfigVersions(Map<String, Collection<ServiceConfigVersionResponse>> desiredServiceConfigVersions) {
        this.desiredServiceConfigVersions = desiredServiceConfigVersions;
    }

    public void setCredentialStoreServiceProperties(Map<String, String> credentialServiceProperties) {
        this.credentialStoreServiceProperties = credentialServiceProperties;
    }

    @ApiModelProperty(name="credential_store_properties")
    public Map<String, String> getCredentialStoreServiceProperties() {
        return this.credentialStoreServiceProperties;
    }

    public static interface ClusterResponseWrapper
    extends ApiModel {
        @ApiModelProperty(name="Clusters")
        public ClusterResponse getClusterResponse();
    }
}

