/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.controller.ConfigurationRequest;
import id.onyx.obdp.server.controller.ServiceConfigVersionRequest;
import id.onyx.obdp.server.state.SecurityType;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterRequest {
    private final Long clusterId;
    private final String clusterName;
    private final String stackVersion;
    private final String provisioningState;
    private SecurityType securityType;
    private Set<String> hostNames;
    private List<ConfigurationRequest> configs;
    private ServiceConfigVersionRequest serviceConfigVersionRequest;
    private final Map<String, Object> sessionAttributes;

    public ClusterRequest(Long clusterId, String clusterName, String stackVersion, Set<String> hostNames) {
        this(clusterId, clusterName, null, null, stackVersion, hostNames);
    }

    public ClusterRequest(Long clusterId, String clusterName, String provisioningState, SecurityType securityType, String stackVersion, Set<String> hostNames) {
        this(clusterId, clusterName, provisioningState, securityType, stackVersion, hostNames, null);
    }

    public ClusterRequest(Long clusterId, String clusterName, String provisioningState, SecurityType securityType, String stackVersion, Set<String> hostNames, Map<String, Object> sessionAttributes) {
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.provisioningState = provisioningState;
        this.securityType = securityType;
        this.stackVersion = stackVersion;
        this.hostNames = hostNames;
        this.sessionAttributes = sessionAttributes;
    }

    @ApiModelProperty(name="cluster_id")
    public Long getClusterId() {
        return this.clusterId;
    }

    @ApiModelProperty(name="cluster_name")
    public String getClusterName() {
        return this.clusterName;
    }

    @ApiModelProperty(name="provisioning_state")
    public String getProvisioningState() {
        return this.provisioningState;
    }

    @ApiModelProperty(name="security_type")
    public SecurityType getSecurityType() {
        return this.securityType;
    }

    @ApiModelProperty(name="version")
    public String getStackVersion() {
        return this.stackVersion;
    }

    @ApiModelProperty(hidden=true)
    public Set<String> getHostNames() {
        return this.hostNames;
    }

    public void setDesiredConfig(List<ConfigurationRequest> configRequests) {
        this.configs = configRequests;
    }

    @ApiModelProperty(name="desired_configs")
    public List<ConfigurationRequest> getDesiredConfig() {
        return this.configs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ clusterName=").append(this.clusterName).append(", clusterId=").append(this.clusterId).append(", provisioningState=").append(this.provisioningState).append(", securityType=").append((Object)this.securityType).append(", stackVersion=").append(this.stackVersion).append(", desired_scv=").append(this.serviceConfigVersionRequest).append(", hosts=[").append(this.hostNames != null ? String.join((CharSequence)",", this.hostNames) : "").append("] }");
        return sb.toString();
    }

    @ApiModelProperty(name="desired_service_config_versions")
    public ServiceConfigVersionRequest getServiceConfigVersionRequest() {
        return this.serviceConfigVersionRequest;
    }

    @ApiModelProperty(hidden=true)
    public Map<String, Object> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setServiceConfigVersionRequest(ServiceConfigVersionRequest serviceConfigVersionRequest) {
        this.serviceConfigVersionRequest = serviceConfigVersionRequest;
    }
}

