/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class AuthToLocalBuilder
implements Cloneable {
    public static final ConcatenationType DEFAULT_CONCATENATION_TYPE = ConcatenationType.NEW_LINES;
    private Set<Rule> setRules = new TreeSet<Rule>();
    private final String defaultRealm;
    private final Set<String> additionalRealms;
    private boolean caseInsensitiveUser;

    public AuthToLocalBuilder(String defaultRealm, String additionalRealms, boolean caseInsensitiveUserSupport) {
        this(defaultRealm, AuthToLocalBuilder.splitDelimitedString(additionalRealms), caseInsensitiveUserSupport);
    }

    public AuthToLocalBuilder(String defaultRealm, Collection<String> additionalRealms, boolean caseInsensitiveUserSupport) {
        this.defaultRealm = defaultRealm;
        this.additionalRealms = additionalRealms == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(additionalRealms));
        this.caseInsensitiveUser = caseInsensitiveUserSupport;
    }

    public Object clone() throws CloneNotSupportedException {
        AuthToLocalBuilder copy = (AuthToLocalBuilder)super.clone();
        copy.setRules = new TreeSet<Rule>(this.setRules);
        return copy;
    }

    public AuthToLocalBuilder addRules(String authToLocalRules) {
        if (!StringUtils.isEmpty((String)authToLocalRules)) {
            String[] rules;
            for (String r : rules = authToLocalRules.split("RULE:|DEFAULT")) {
                Rule rule;
                if ((r = r.trim()).isEmpty() || this.setRules.contains((rule = this.createRule(r)).caseSensitivityInverted())) continue;
                this.setRules.add(rule);
            }
        }
        return this;
    }

    public AuthToLocalBuilder addRule(String principal, String localUsername) {
        if (!StringUtils.isEmpty((String)principal) && !StringUtils.isEmpty((String)localUsername)) {
            Principal p = new Principal(principal);
            if (p.getRealm() == null) {
                throw new IllegalArgumentException("Attempted to add a rule for a principal with no realm: " + principal);
            }
            Rule rule = this.createHostAgnosticRule(p, localUsername);
            this.setRules.add(rule);
        }
        return this;
    }

    public String generate() {
        return this.generate(null);
    }

    public String generate(ConcatenationType concatenationType) {
        StringBuilder builder = new StringBuilder();
        if (!StringUtils.isEmpty((String)this.defaultRealm)) {
            this.setRules.remove(this.createDefaultRealmRule(this.defaultRealm, !this.caseInsensitiveUser));
            this.setRules.add(this.createDefaultRealmRule(this.defaultRealm, this.caseInsensitiveUser));
        }
        for (String additionalRealm : this.additionalRealms) {
            this.setRules.remove(this.createDefaultRealmRule(additionalRealm, !this.caseInsensitiveUser));
            this.setRules.add(this.createDefaultRealmRule(additionalRealm, this.caseInsensitiveUser));
        }
        if (concatenationType == null) {
            concatenationType = DEFAULT_CONCATENATION_TYPE;
        }
        for (Rule rule : this.setRules) {
            this.appendRule(builder, rule.toString(), concatenationType);
        }
        this.appendRule(builder, "DEFAULT", concatenationType);
        return builder.toString();
    }

    private void appendRule(StringBuilder stringBuilder, String rule, ConcatenationType concatenationType) {
        if (stringBuilder.length() > 0) {
            switch (concatenationType) {
                case NEW_LINES: {
                    stringBuilder.append('\n');
                    break;
                }
                case NEW_LINES_ESCAPED: {
                    stringBuilder.append("\\\n");
                    break;
                }
                case SPACES: {
                    stringBuilder.append(" ");
                    break;
                }
                case COMMA: {
                    stringBuilder.append(",");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("The auth-to-local rule concatenation type is not supported: %s", concatenationType.name()));
                }
            }
        }
        stringBuilder.append(rule);
    }

    private Rule createHostAgnosticRule(Principal principal, String localUser) {
        List<String> principalComponents = principal.getComponents();
        int componentCount = principalComponents.size();
        return new Rule(MatchingRule.ignoreHostWhenComponentCountIs(componentCount), new Principal(principal.getComponent(1) + "@" + principal.getRealm()), new Substitution(".*", localUser, "", false));
    }

    private Rule createDefaultRealmRule(String realm, boolean caseInsensitive) {
        return new Rule(MatchingRule.ignoreHostWhenComponentCountIs(1), new Principal(".*@" + realm), new Substitution("@.*", "", "", caseInsensitive));
    }

    private Rule createRule(String rule) {
        return Rule.parse(rule.startsWith("RULE:") ? rule : String.format("RULE:%s", rule));
    }

    private static Collection<String> splitDelimitedString(String string) {
        HashSet<String> collection = null;
        if (!StringUtils.isEmpty((String)string)) {
            collection = new HashSet<String>();
            for (String realm : string.split("\\s*(?:\\r?\\n|,)\\s*")) {
                if ((realm = realm.trim()).isEmpty()) continue;
                collection.add(realm);
            }
        }
        return collection;
    }

    private static class Rule
    implements Comparable<Rule> {
        private static final Pattern PATTERN_RULE_PARSE = Pattern.compile("RULE:\\s*\\[\\s*(\\d)\\s*:\\s*(.+?)(?:@(.+?))??\\s*\\]\\s*\\((.+?)\\)\\s*s/(.*?)/(.*?)/([a-zA-Z]*)((/L)?)(?:.|\n)*");
        private final MatchingRule matchingRule;
        private final Principal principal;
        private final Substitution substitution;

        public static Rule parse(String rule) {
            Matcher m = PATTERN_RULE_PARSE.matcher(rule);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid rule: " + rule);
            }
            int expectedComponentCount = Integer.parseInt(m.group(1));
            String matchPattern = m.group(2);
            String optionalPatternRealm = m.group(3);
            String matchingRegexp = m.group(4);
            String replacementPattern = m.group(5);
            String replacementReplacement = m.group(6);
            String replacementModifier = m.group(7);
            String caseSensitivity = m.group(8);
            return new Rule(new MatchingRule(expectedComponentCount, matchPattern, optionalPatternRealm), new Principal(matchingRegexp), new Substitution(replacementPattern, replacementReplacement, replacementModifier, !caseSensitivity.isEmpty()));
        }

        public Rule(MatchingRule matchingRule, Principal principal, Substitution substitution) {
            this.matchingRule = matchingRule;
            this.principal = principal;
            this.substitution = substitution;
        }

        public String toString() {
            return String.format("RULE:%s(%s)%s", this.matchingRule, this.principal, this.substitution);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule rule = (Rule)o;
            return new EqualsBuilder().append((Object)this.matchingRule, (Object)rule.matchingRule).append((Object)this.principal, (Object)rule.principal).append((Object)this.substitution, (Object)rule.substitution).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.matchingRule).append((Object)this.principal).append((Object)this.substitution).toHashCode();
        }

        @Override
        public int compareTo(Rule other) {
            int retVal = this.matchingRule.expectedComponentCount - other.matchingRule.expectedComponentCount;
            if (retVal == 0 && (retVal = other.matchingRule.matchComponentCount() - this.matchingRule.matchComponentCount()) == 0) {
                if (this.principal.equals(other.principal)) {
                    retVal = this.toString().compareTo(other.toString());
                } else {
                    String otherRealm;
                    String realm = this.principal.getRealm();
                    retVal = this.compareValueWithWildcards(realm, otherRealm = other.principal.getRealm());
                    if (retVal == 0) {
                        String otherComponent1;
                        String component1;
                        for (int i = 1; i <= this.matchingRule.matchComponentCount() && (retVal = this.compareValueWithWildcards(component1 = this.principal.getComponent(1), otherComponent1 = other.principal.getComponent(1))) == 0; ++i) {
                        }
                    }
                }
            }
            return retVal;
        }

        private int compareValueWithWildcards(String s1, String s2) {
            if (s1 == null) {
                if (s2 == null) {
                    return 0;
                }
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            if (s1.equals(s2)) {
                return 0;
            }
            if (s1.equals(".*")) {
                return 1;
            }
            if (s2.equals(".*")) {
                return -1;
            }
            return s1.compareTo(s2);
        }

        public Rule caseSensitivityInverted() {
            return new Rule(this.matchingRule, this.principal, this.substitution.caseSensitivityInverted());
        }
    }

    private static class Principal {
        private static final Pattern p = Pattern.compile("([^@]+)(?:@(.*))?");
        private String principal;
        private String realm;
        private List<String> components;

        public Principal(String principal) {
            this.principal = principal;
            Matcher m = p.matcher(principal);
            if (m.matches()) {
                String allComponents = m.group(1);
                if (allComponents == null) {
                    this.components = Collections.emptyList();
                } else {
                    allComponents = allComponents.startsWith("/") ? allComponents.substring(1) : allComponents;
                    this.components = Arrays.asList(allComponents.split("/"));
                }
            } else {
                throw new IllegalArgumentException("Invalid Principal: " + principal);
            }
            this.realm = m.group(2);
        }

        public List<String> getComponents() {
            return this.components;
        }

        public String getComponent(int position) {
            if (position > this.components.size()) {
                return null;
            }
            return this.components.get(position - 1);
        }

        public String getRealm() {
            return this.realm;
        }

        public String toString() {
            return this.principal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Principal principal1 = (Principal)o;
            return this.components.equals(principal1.components) && this.principal.equals(principal1.principal) && !(this.realm == null ? principal1.realm != null : !this.realm.equals(principal1.realm));
        }

        public int hashCode() {
            int result = this.principal.hashCode();
            result = 31 * result + (this.realm != null ? this.realm.hashCode() : 0);
            result = 31 * result + this.components.hashCode();
            return result;
        }
    }

    public static enum ConcatenationType {
        NEW_LINES,
        NEW_LINES_ESCAPED,
        SPACES,
        COMMA;


        public static ConcatenationType translate(String value) {
            if (value != null && !(value = value.trim()).isEmpty()) {
                return ConcatenationType.valueOf(value.toUpperCase());
            }
            return DEFAULT_CONCATENATION_TYPE;
        }
    }

    private static class MatchingRule {
        private final int expectedComponentCount;
        private final String matchPattern;
        private final String realmPattern;

        public static MatchingRule ignoreHostWhenComponentCountIs(int expectedComponentCount) {
            return new MatchingRule(expectedComponentCount, "$1", "$0");
        }

        public MatchingRule(int expectedComponentCount, String matchPattern, @Nullable String realmPattern) {
            this.expectedComponentCount = expectedComponentCount;
            this.matchPattern = matchPattern;
            this.realmPattern = realmPattern;
        }

        public int matchComponentCount() {
            return (this.matchPattern.startsWith("$") ? this.matchPattern.substring(1) : this.matchPattern).split("\\$").length;
        }

        public String toString() {
            return this.realmPattern != null ? String.format("[%d:%s@%s]", this.expectedComponentCount, this.matchPattern, this.realmPattern) : String.format("[%d:%s]", this.expectedComponentCount, this.matchPattern);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchingRule that = (MatchingRule)o;
            return new EqualsBuilder().append(this.expectedComponentCount, that.expectedComponentCount).append((Object)this.matchPattern, (Object)that.matchPattern).append((Object)this.realmPattern, (Object)that.realmPattern).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.expectedComponentCount).append((Object)this.matchPattern).append((Object)this.realmPattern).toHashCode();
        }
    }

    private static class Substitution {
        private final String pattern;
        private final String replacement;
        private final String modifier;
        private final boolean caseInsensitiveUser;

        public Substitution(String pattern, String replacement, String modifier, boolean caseInsensitiveUser) {
            this.pattern = pattern;
            this.replacement = replacement;
            this.modifier = modifier;
            this.caseInsensitiveUser = caseInsensitiveUser;
        }

        public String toString() {
            return String.format("s/%s/%s/%s%s", this.pattern, this.replacement, this.modifier, this.caseInsensitiveUser ? "/L" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Substitution that = (Substitution)o;
            return new EqualsBuilder().append(this.caseInsensitiveUser, that.caseInsensitiveUser).append((Object)this.pattern, (Object)that.pattern).append((Object)this.replacement, (Object)that.replacement).append((Object)this.modifier, (Object)that.modifier).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.pattern).append((Object)this.replacement).append((Object)this.modifier).append(this.caseInsensitiveUser).toHashCode();
        }

        public Substitution caseSensitivityInverted() {
            return new Substitution(this.pattern, this.replacement, this.modifier, !this.caseInsensitiveUser);
        }
    }
}

