/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.orm.dao.ExtensionDAO;
import id.onyx.obdp.server.orm.dao.ExtensionLinkDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.ExtensionEntity;
import id.onyx.obdp.server.orm.entities.ExtensionLinkEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.stack.ExtensionHelper;
import id.onyx.obdp.server.stack.StackManager;
import id.onyx.obdp.server.state.ExtensionInfo;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.stack.ExtensionMetainfoXml;
import id.onyx.obdp.server.utils.VersionUtils;
import jakarta.persistence.RollbackException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AmbariManagementHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AmbariManagementHelper.class);
    private ExtensionLinkDAO linkDAO;
    private ExtensionDAO extensionDAO;
    private StackDAO stackDAO;

    @Inject
    public AmbariManagementHelper(StackDAO stackDAO, ExtensionDAO extensionDAO, ExtensionLinkDAO linkDAO) {
        this.stackDAO = stackDAO;
        this.extensionDAO = extensionDAO;
        this.linkDAO = linkDAO;
    }

    public void createExtensionLink(StackManager stackManager, StackInfo stackInfo, ExtensionInfo extensionInfo) throws OBDPException {
        this.validateCreateExtensionLinkRequest(stackInfo, extensionInfo);
        ExtensionHelper.validateCreateLink(stackManager, stackInfo, extensionInfo);
        ExtensionLinkEntity linkEntity = this.createExtensionLinkEntity(stackInfo, extensionInfo);
        stackManager.linkStackToExtension(stackInfo, extensionInfo);
        try {
            this.linkDAO.create(linkEntity);
        }
        catch (RollbackException e) {
            String message = "Unable to create extension link";
            LOG.debug(message, (Throwable)e);
            String errorMessage = message + ", stackName=" + stackInfo.getName() + ", stackVersion=" + stackInfo.getVersion() + ", extensionName=" + extensionInfo.getName() + ", extensionVersion=" + extensionInfo.getVersion();
            LOG.warn(errorMessage);
            throw new OBDPException(errorMessage, (Throwable)e);
        }
    }

    public void createExtensionLinks(StackManager stackManager, List<ExtensionInfo> extensions) throws OBDPException {
        Map<String, List<StackInfo>> stackMap = stackManager.getStacksByName();
        for (List<StackInfo> stacks : stackMap.values()) {
            Collections.sort(stacks);
            Collections.reverse(stacks);
        }
        Collections.sort(extensions);
        Collections.reverse(extensions);
        for (ExtensionInfo extension : extensions) {
            if (extension.isActive() && extension.isAutoLink()) {
                LOG.debug("Autolink - looking for matching stack versions for extension:{}/{} ", (Object)extension.getName(), (Object)extension.getVersion());
                for (ExtensionMetainfoXml.Stack supportedStack : extension.getStacks()) {
                    List<StackInfo> stacks = stackMap.get(supportedStack.getName());
                    for (StackInfo stack : stacks) {
                        if (stack.getExtension(extension.getName()) == null && VersionUtils.compareVersions((String)stack.getVersion(), (String)supportedStack.getVersion()) > -1) {
                            LOG.debug("Autolink - extension: {}/{} stack: {}/{}", new Object[]{extension.getName(), extension.getVersion(), stack.getName(), stack.getVersion()});
                            this.createExtensionLink(stackManager, stack, extension);
                            continue;
                        }
                        LOG.debug("Autolink - not a match extension: {}/{} stack: {}/{}", new Object[]{extension.getName(), extension.getVersion(), stack.getName(), stack.getVersion()});
                    }
                }
                continue;
            }
            LOG.debug("Autolink - skipping extension: {}/{}.  It is either not active or set to autolink.", (Object)extension.getName(), (Object)extension.getVersion());
        }
    }

    private void validateCreateExtensionLinkRequest(StackInfo stackInfo, ExtensionInfo extensionInfo) throws OBDPException {
        if (stackInfo == null) {
            throw new IllegalArgumentException("Stack should be provided");
        }
        if (extensionInfo == null) {
            throw new IllegalArgumentException("Extension should be provided");
        }
        if (StringUtils.isBlank((String)stackInfo.getName()) || StringUtils.isBlank((String)stackInfo.getVersion()) || StringUtils.isBlank((String)extensionInfo.getName()) || StringUtils.isBlank((String)extensionInfo.getVersion())) {
            throw new IllegalArgumentException("Stack name, stack version, extension name and extension version should be provided");
        }
        ExtensionLinkEntity entity = this.linkDAO.findByStackAndExtension(stackInfo.getName(), stackInfo.getVersion(), extensionInfo.getName(), extensionInfo.getVersion());
        if (entity != null) {
            throw new OBDPException("The stack and extension are already linked, stackName=" + stackInfo.getName() + ", stackVersion=" + stackInfo.getVersion() + ", extensionName=" + extensionInfo.getName() + ", extensionVersion=" + extensionInfo.getVersion());
        }
    }

    public void updateExtensionLink(StackManager stackManager, ExtensionLinkEntity linkEntity, StackInfo stackInfo, ExtensionInfo oldExtensionInfo, ExtensionInfo newExtensionInfo) throws OBDPException {
        ExtensionHelper.validateUpdateLink(stackManager, stackInfo, oldExtensionInfo, newExtensionInfo);
        ExtensionEntity extension = this.extensionDAO.find(newExtensionInfo.getName(), newExtensionInfo.getVersion());
        linkEntity.setExtension(extension);
        try {
            linkEntity = this.linkDAO.merge(linkEntity);
        }
        catch (RollbackException e) {
            String message = "Unable to update extension link";
            LOG.debug(message, (Throwable)e);
            String errorMessage = message + ", stackName=" + stackInfo.getName() + ", stackVersion=" + stackInfo.getVersion() + ", extensionName=" + newExtensionInfo.getName() + ", extensionVersion=" + newExtensionInfo.getVersion();
            LOG.warn(errorMessage);
            throw new OBDPException(errorMessage, (Throwable)e);
        }
    }

    private ExtensionLinkEntity createExtensionLinkEntity(StackInfo stackInfo, ExtensionInfo extensionInfo) throws OBDPException {
        StackEntity stack = this.stackDAO.find(stackInfo.getName(), stackInfo.getVersion());
        ExtensionEntity extension = this.extensionDAO.find(extensionInfo.getName(), extensionInfo.getVersion());
        ExtensionLinkEntity linkEntity = new ExtensionLinkEntity();
        linkEntity.setStack(stack);
        linkEntity.setExtension(extension);
        return linkEntity;
    }
}

