/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller;

import id.onyx.obdp.server.actionmanager.TargetHostType;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.state.StackId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ActionExecutionContext {
    private final String clusterName;
    private final String actionName;
    private List<RequestResourceFilter> resourceFilters;
    private RequestOperationLevel operationLevel;
    private Map<String, String> parameters;
    private TargetHostType targetType;
    private Integer timeout;
    private String expectedServiceName;
    private String expectedComponentName;
    private boolean hostsInMaintenanceModeExcluded = true;
    private boolean allowRetry = false;
    private StackId stackId;
    private boolean isFutureCommand = false;
    private List<ExecutionCommandVisitor> m_visitors = new ArrayList<ExecutionCommandVisitor>();
    private boolean autoSkipFailures = false;

    public ActionExecutionContext(String clusterName, String actionName, List<RequestResourceFilter> resourceFilters, Map<String, String> parameters, TargetHostType targetType, Integer timeout, String expectedServiceName, String expectedComponentName) {
        this.clusterName = clusterName;
        this.actionName = actionName;
        this.resourceFilters = resourceFilters;
        this.parameters = parameters;
        this.targetType = targetType;
        this.timeout = timeout;
        this.expectedServiceName = expectedServiceName;
        this.expectedComponentName = expectedComponentName;
    }

    public ActionExecutionContext(String clusterName, String actionName, List<RequestResourceFilter> resourceFilters) {
        this.clusterName = clusterName;
        this.actionName = actionName;
        this.resourceFilters = resourceFilters;
    }

    public ActionExecutionContext(String clusterName, String commandName, List<RequestResourceFilter> resourceFilters, Map<String, String> parameters) {
        this.clusterName = clusterName;
        this.actionName = commandName;
        this.resourceFilters = resourceFilters;
        this.parameters = parameters;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public TargetHostType getTargetType() {
        return this.targetType;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public List<RequestResourceFilter> getResourceFilters() {
        return this.resourceFilters;
    }

    public RequestOperationLevel getOperationLevel() {
        return this.operationLevel;
    }

    public void setOperationLevel(RequestOperationLevel operationLevel) {
        this.operationLevel = operationLevel;
    }

    public String getExpectedServiceName() {
        return this.expectedServiceName;
    }

    public String getExpectedComponentName() {
        return this.expectedComponentName;
    }

    public boolean isRetryAllowed() {
        return this.allowRetry;
    }

    public void setRetryAllowed(boolean allowRetry) {
        this.allowRetry = allowRetry;
    }

    public boolean isFailureAutoSkipped() {
        return this.autoSkipFailures;
    }

    public void setAutoSkipFailures(boolean autoSkipFailures) {
        this.autoSkipFailures = autoSkipFailures;
    }

    public StackId getStackId() {
        return this.stackId;
    }

    public void setStackId(StackId stackId) {
        this.stackId = stackId;
    }

    public void addVisitor(ExecutionCommandVisitor visitor) {
        this.m_visitors.add(visitor);
    }

    public String toString() {
        return "ActionExecutionContext{clusterName='" + this.clusterName + "', actionName='" + this.actionName + "', resourceFilters=" + this.resourceFilters + ", operationLevel=" + this.operationLevel + ", parameters=" + this.parameters + ", targetType=" + this.targetType + ", timeout=" + this.timeout + ", isMaintenanceModeHostExcluded=" + this.hostsInMaintenanceModeExcluded + ", allowRetry=" + this.allowRetry + ", autoSkipFailures=" + this.autoSkipFailures + "}";
    }

    public boolean isMaintenanceModeHostExcluded() {
        return this.hostsInMaintenanceModeExcluded;
    }

    public void setMaintenanceModeHostExcluded(boolean excluded) {
        this.hostsInMaintenanceModeExcluded = excluded;
    }

    public void visitAll(ExecutionCommand command) {
        for (ExecutionCommandVisitor visitor : this.m_visitors) {
            visitor.visit(command);
        }
    }

    public boolean isFutureCommand() {
        return this.isFutureCommand;
    }

    public void setIsFutureCommand(boolean isFutureCommand) {
        this.isFutureCommand = isFutureCommand;
    }

    public static interface ExecutionCommandVisitor {
        public void visit(ExecutionCommand var1);
    }
}

