/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration.spring;

import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.AgentSessionManager;
import id.onyx.obdp.server.agent.stomp.AmbariSubscriptionRegistry;
import id.onyx.obdp.server.api.AmbariSendToMethodReturnValueHandler;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.events.DefaultMessageEmitter;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.support.SendToMethodReturnValueHandler;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.messaging.simp.broker.SimpleBrokerMessageHandler;
import org.springframework.messaging.simp.broker.SubscriptionRegistry;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

@org.springframework.context.annotation.Configuration
public class RootStompConfig {
    @Autowired
    private SimpMessagingTemplate brokerTemplate;
    private final ServletContext servletContext;
    private final Configuration configuration;

    public RootStompConfig(ServletContext servletContext, Injector injector) {
        this.servletContext = servletContext;
        this.configuration = (Configuration)injector.getInstance(Configuration.class);
    }

    @Bean
    public DefaultMessageEmitter defaultMessageEmitter(Injector injector) {
        Configuration configuration = (Configuration)injector.getInstance(Configuration.class);
        return new DefaultMessageEmitter((AgentSessionManager)injector.getInstance(AgentSessionManager.class), this.brokerTemplate, (OBDPEventPublisher)injector.getInstance(OBDPEventPublisher.class), configuration.getExecutionCommandsRetryCount(), configuration.getExecutionCommandsRetryInterval());
    }

    @Bean
    public DefaultHandshakeHandler handshakeHandler() {
        return new DefaultHandshakeHandler((RequestUpgradeStrategy)new JettyRequestUpgradeStrategy());
    }

    @Autowired
    public void configureRegistryCacheSize(SimpleBrokerMessageHandler simpleBrokerMessageHandler) throws NoSuchFieldException, IllegalAccessException {
        AmbariSubscriptionRegistry defaultSubscriptionRegistry = new AmbariSubscriptionRegistry(this.configuration.getSubscriptionRegistryCacheSize());
        simpleBrokerMessageHandler.setSubscriptionRegistry((SubscriptionRegistry)defaultSubscriptionRegistry);
    }

    @Autowired
    public void configureGlobal(SimpAnnotationMethodMessageHandler messageHandler) {
        ArrayList handlers = new ArrayList(messageHandler.getReturnValueHandlers());
        ArrayList<AmbariSendToMethodReturnValueHandler> changedHandlers = new ArrayList<AmbariSendToMethodReturnValueHandler>();
        boolean handlerReplaced = false;
        for (HandlerMethodReturnValueHandler handler : handlers) {
            if (handler instanceof SendToMethodReturnValueHandler && !handlerReplaced) {
                SendToMethodReturnValueHandler sendHandler = (SendToMethodReturnValueHandler)handler;
                AmbariSendToMethodReturnValueHandler ambariSendToMethodReturnValueHandler = new AmbariSendToMethodReturnValueHandler((SimpMessageSendingOperations)this.brokerTemplate, true);
                ambariSendToMethodReturnValueHandler.setHeaderInitializer(sendHandler.getHeaderInitializer());
                changedHandlers.add(ambariSendToMethodReturnValueHandler);
                handlerReplaced = true;
                continue;
            }
            changedHandlers.add((AmbariSendToMethodReturnValueHandler)handler);
        }
        messageHandler.setReturnValueHandlers(null);
        messageHandler.setReturnValueHandlers(changedHandlers);
    }

    @ControllerAdvice
    public static class ExceptionHandlingAdvice {
        private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandlingAdvice.class);

        @MessageExceptionHandler(value={Exception.class})
        @SendToUser(value={"/"})
        public ErrorMessage handle(Exception e) {
            LOG.error("Exception caught while processing a message: " + e.getMessage(), (Throwable)e);
            return new ErrorMessage((Throwable)new OBDPException(e.getMessage()));
        }
    }
}

