/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration.spring;

import com.google.inject.Injector;
import id.onyx.obdp.server.api.stomp.NamedTasksSubscriptions;
import id.onyx.obdp.server.api.stomp.TestController;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.configuration.spring.RootStompConfig;
import id.onyx.obdp.server.events.DefaultMessageEmitter;
import id.onyx.obdp.server.events.listeners.requests.STOMPUpdateListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@org.springframework.context.annotation.Configuration
@EnableWebSocketMessageBroker
@ComponentScan(basePackageClasses={TestController.class})
@Import(value={RootStompConfig.class})
public class ApiStompConfig
implements WebSocketMessageBrokerConfigurer {
    private final String HEARTBEAT_THREAD_NAME = "ws-heartbeat-thread-";
    private final int HEARTBEAT_POOL_SIZE = 1;
    private final Configuration configuration;

    public ApiStompConfig(Injector injector) {
        this.configuration = (Configuration)injector.getInstance(Configuration.class);
    }

    @Bean
    public STOMPUpdateListener requestSTOMPListener(Injector injector) {
        return new STOMPUpdateListener(injector, DefaultMessageEmitter.DEFAULT_API_EVENT_TYPES);
    }

    @Bean
    public NamedTasksSubscriptions namedTasksSubscribtions(Injector injector) {
        return (NamedTasksSubscriptions)injector.getInstance(NamedTasksSubscriptions.class);
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/v1"}).setAllowedOriginPatterns(new String[]{"*"}).withSockJS().setHeartbeatTime((long)this.configuration.getAPIHeartbeatInterval());
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(1);
        taskScheduler.setThreadNamePrefix("ws-heartbeat-thread-");
        taskScheduler.initialize();
        registry.setPreservePublishOrder(true).enableSimpleBroker(new String[]{"/"}).setTaskScheduler((TaskScheduler)taskScheduler).setHeartbeatValue(new long[]{this.configuration.getAPIHeartbeatInterval(), this.configuration.getAPIHeartbeatInterval()});
    }
}

