/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration.spring;

import id.onyx.obdp.server.configuration.spring.GuiceBeansConfig;
import id.onyx.obdp.server.security.AmbariEntryPoint;
import id.onyx.obdp.server.security.authentication.OBDPDelegatingAuthenticationFilter;
import id.onyx.obdp.server.security.authentication.OBDPLocalAuthenticationProvider;
import id.onyx.obdp.server.security.authentication.RequestBodyCachingFilter;
import id.onyx.obdp.server.security.authentication.jwt.OBDPJwtAuthenticationProvider;
import id.onyx.obdp.server.security.authentication.kerberos.AmbariAuthToLocalUserDetailsService;
import id.onyx.obdp.server.security.authentication.kerberos.AmbariKerberosTicketValidator;
import id.onyx.obdp.server.security.authentication.kerberos.OBDPKerberosAuthenticationProvider;
import id.onyx.obdp.server.security.authentication.kerberos.OBDPProxiedUserDetailsService;
import id.onyx.obdp.server.security.authentication.pam.AmbariPamAuthenticationProvider;
import id.onyx.obdp.server.security.authorization.AmbariLdapAuthenticationProvider;
import id.onyx.obdp.server.security.authorization.OBDPAuthorizationFilter;
import id.onyx.obdp.server.security.authorization.internal.AmbariInternalAuthenticationProvider;
import jakarta.servlet.Filter;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Configuration
@EnableWebSecurity
@Import(value={GuiceBeansConfig.class})
@ComponentScan(value={"id.onyx.obdp.server.security"})
public class ApiSecurityConfig {
    private final GuiceBeansConfig guiceBeansConfig;
    @Autowired
    private AmbariEntryPoint ambariEntryPoint;
    @Autowired
    private OBDPDelegatingAuthenticationFilter delegatingAuthenticationFilter;
    @Autowired
    private OBDPAuthorizationFilter authorizationFilter;

    public ApiSecurityConfig(GuiceBeansConfig guiceBeansConfig) {
        this.guiceBeansConfig = guiceBeansConfig;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        ((HttpSecurity)http.csrf().disable()).authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.anyRequest()).authenticated()).headers(headers -> headers.httpStrictTransportSecurity().disable().frameOptions().disable()).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)this.ambariEntryPoint)).sessionManagement(sessionManagement -> sessionManagement.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED)).addFilterBefore((Filter)new RequestBodyCachingFilter(), BasicAuthenticationFilter.class).addFilterBefore((Filter)this.guiceBeansConfig.obdpUserAuthorizationFilter(), BasicAuthenticationFilter.class).addFilterAt((Filter)this.delegatingAuthenticationFilter, BasicAuthenticationFilter.class).addFilterBefore((Filter)this.authorizationFilter, FilterSecurityInterceptor.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public AuthenticationManager authenticationManager(OBDPJwtAuthenticationProvider obdpJwtAuthenticationProvider, AmbariPamAuthenticationProvider obdpPamAuthenticationProvider, OBDPLocalAuthenticationProvider OBDPLocalAuthenticationProvider2, AmbariLdapAuthenticationProvider obdpLdapAuthenticationProvider, AmbariInternalAuthenticationProvider obdpInternalAuthenticationProvider, OBDPKerberosAuthenticationProvider ambariKerberosAuthenticationProvider) {
        return new ProviderManager(Arrays.asList(obdpJwtAuthenticationProvider, obdpPamAuthenticationProvider, OBDPLocalAuthenticationProvider2, obdpLdapAuthenticationProvider, obdpInternalAuthenticationProvider, ambariKerberosAuthenticationProvider));
    }

    @Bean
    public OBDPKerberosAuthenticationProvider ambariKerberosAuthenticationProvider(AmbariKerberosTicketValidator obdpKerberosTicketValidator, AmbariAuthToLocalUserDetailsService authToLocalUserDetailsService, OBDPProxiedUserDetailsService proxiedUserDetailsService) {
        return new OBDPKerberosAuthenticationProvider(authToLocalUserDetailsService, proxiedUserDetailsService, obdpKerberosTicketValidator);
    }
}

