/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration.spring;

import com.google.inject.Injector;
import id.onyx.obdp.server.agent.stomp.HeartbeatController;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.configuration.spring.AgentRegisteringQueueChecker;
import id.onyx.obdp.server.configuration.spring.GuiceBeansConfig;
import id.onyx.obdp.server.configuration.spring.RootStompConfig;
import id.onyx.obdp.server.events.DefaultMessageEmitter;
import id.onyx.obdp.server.events.listeners.requests.STOMPUpdateListener;
import jakarta.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

@org.springframework.context.annotation.Configuration
@EnableWebSocketMessageBroker
@ComponentScan(basePackageClasses={HeartbeatController.class})
@Import(value={RootStompConfig.class, GuiceBeansConfig.class})
public class AgentStompConfig
implements WebSocketMessageBrokerConfigurer {
    private Configuration configuration;
    private final ServletContext servletContext;
    @Autowired
    private AgentRegisteringQueueChecker agentRegisteringQueueChecker;

    public AgentStompConfig(ServletContext servletContext, Injector injector) {
        this.servletContext = servletContext;
        this.configuration = (Configuration)injector.getInstance(Configuration.class);
    }

    @Bean
    public STOMPUpdateListener requestSTOMPListener(Injector injector) {
        return new STOMPUpdateListener(injector, DefaultMessageEmitter.DEFAULT_AGENT_EVENT_TYPES);
    }

    public DefaultHandshakeHandler getHandshakeHandler() {
        return new DefaultHandshakeHandler((RequestUpgradeStrategy)new JettyRequestUpgradeStrategy());
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/v1"}).setHandshakeHandler((HandshakeHandler)this.getHandshakeHandler()).setAllowedOriginPatterns(new String[]{"*"});
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(this.configuration.getSpringMessagingThreadPoolSize());
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(this.configuration.getSpringMessagingThreadPoolSize());
        registration.interceptors(new ChannelInterceptor[]{this.agentRegisteringQueueChecker});
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.setMessageSizeLimit(this.configuration.getStompMaxIncomingMessageSize());
        registration.setSendBufferSizeLimit(this.configuration.getStompMaxBufferMessageSize());
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.setPreservePublishOrder(true);
    }
}

