/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration.spring;

import id.onyx.obdp.server.agent.stomp.AgentsRegistrationQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageBuilder;

public class AgentRegisteringQueueChecker
implements ChannelInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AgentsRegistrationQueue.class);
    @Autowired
    private AgentsRegistrationQueue agentsRegistrationQueue;

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        StompHeaderAccessor headerAccessor = StompHeaderAccessor.wrap(message);
        String sessionId = headerAccessor.getSessionId();
        if (StompCommand.CONNECT.equals((Object)headerAccessor.getCommand()) && !this.agentsRegistrationQueue.offer(sessionId)) {
            StompHeaderAccessor headerAccessorError = StompHeaderAccessor.create((StompCommand)StompCommand.ERROR);
            headerAccessorError.setHeader("simpSessionId", (Object)sessionId);
            headerAccessorError.setHeader("simpConnectMessage", (Object)headerAccessor.getHeader("simpConnectMessage").toString());
            headerAccessorError.setMessage("Connection not allowed");
            return MessageBuilder.createMessage((Object)new byte[0], (MessageHeaders)headerAccessorError.getMessageHeaders());
        }
        if (SimpMessageType.DISCONNECT_ACK.equals((Object)headerAccessor.getMessageType())) {
            this.agentsRegistrationQueue.complete(sessionId);
        }
        return message;
    }
}

