/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration;

import java.io.File;
import java.util.function.Consumer;
import org.apache.log4j.helpers.FileWatchdog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileWatch {
    private static final Logger LOG = LoggerFactory.getLogger(SingleFileWatch.class);
    private final File file;
    private final FileWatchdog watchdog;
    private final Consumer<File> changeListener;
    private volatile boolean started = false;

    public SingleFileWatch(File file, Consumer<File> changeListener) {
        this.file = file;
        this.changeListener = changeListener;
        this.watchdog = this.createWatchDog();
    }

    private FileWatchdog createWatchDog() {
        FileWatchdog fileWatch = new FileWatchdog(this.file.getAbsolutePath()){

            protected void doOnChange() {
                if (SingleFileWatch.this.started) {
                    SingleFileWatch.this.notifyListener();
                }
            }
        };
        fileWatch.setDelay(1000L);
        fileWatch.setDaemon(true);
        fileWatch.setName("FileWatchdog:" + this.file.getName());
        return fileWatch;
    }

    private void notifyListener() {
        LOG.info("{} changed. Sending notification.", (Object)this.file);
        try {
            this.changeListener.accept(this.file);
        }
        catch (Exception e) {
            LOG.warn("Error while notifying " + this + " listener", (Throwable)e);
        }
    }

    public void start() {
        LOG.info("Starting " + this);
        this.started = true;
        this.watchdog.start();
    }

    public void stop() {
        LOG.info("Stopping " + this);
        this.started = false;
        this.watchdog.interrupt();
    }

    public String toString() {
        return "SingleFileWatcher:" + this.file.getName();
    }
}

