/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.inject.persist.jpa.OBDPJpaPersistService;
import id.onyx.obdp.server.configuration.OBDPServerConfiguration;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.events.JpaInitializedEvent;
import id.onyx.obdp.server.events.OBDPConfigurationChangedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.orm.dao.OBDPConfigurationDAO;
import id.onyx.obdp.server.orm.entities.OBDPConfigurationEntity;
import id.onyx.obdp.server.security.encryption.Encryptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OBDPServerConfigurationProvider<T extends OBDPServerConfiguration>
implements Provider<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OBDPServerConfigurationProvider.class);
    @Inject
    private Provider<OBDPConfigurationDAO> ambariConfigurationDAOProvider;
    @Inject
    @Named(value="OBDPServerConfigurationEncryptor")
    private Encryptor<OBDPServerConfiguration> encryptor;
    private final AtomicBoolean jpaStarted = new AtomicBoolean(false);
    private final OBDPServerConfigurationCategory configurationCategory;
    private T instance = null;

    protected OBDPServerConfigurationProvider(OBDPServerConfigurationCategory configurationCategory, OBDPEventPublisher publisher, OBDPJpaPersistService persistService) {
        this.configurationCategory = configurationCategory;
        if (publisher != null) {
            publisher.register(this);
            LOGGER.info("Registered {} in event publisher", (Object)this.getClass().getName());
        }
        if (persistService != null) {
            this.jpaStarted.set(persistService.isStarted());
        }
    }

    @Subscribe
    public void ambariConfigurationChanged(OBDPConfigurationChangedEvent event) {
        if (this.configurationCategory.getCategoryName().equalsIgnoreCase(event.getCategoryName())) {
            LOGGER.info("OBDP configuration changed event received: {}", (Object)event);
            this.instance = this.loadInstance();
        }
    }

    @Subscribe
    public void jpaInitialized(JpaInitializedEvent event) {
        LOGGER.info("JPA initialized event received: {}", (Object)event);
        this.jpaStarted.set(true);
        this.instance = this.loadInstance();
    }

    public T get() {
        LOGGER.debug("Getting {} configuration...", (Object)this.configurationCategory.getCategoryName());
        if (this.instance == null) {
            this.instance = this.loadInstance();
        }
        return this.instance;
    }

    private T loadInstance() {
        if (this.jpaStarted.get()) {
            LOGGER.info("Loading {} configuration data", (Object)this.configurationCategory.getCategoryName());
            T instance = this.loadInstance(((OBDPConfigurationDAO)this.ambariConfigurationDAOProvider.get()).findByCategory(this.configurationCategory.getCategoryName()));
            this.encryptor.decryptSensitiveData((OBDPServerConfiguration)instance);
            return instance;
        }
        LOGGER.info("Cannot load {} configuration data since JPA is not initialized", (Object)this.configurationCategory.getCategoryName());
        if (this.instance == null) {
            return this.loadInstance(Collections.emptyList());
        }
        return this.instance;
    }

    protected Map<String, String> toProperties(Collection<OBDPConfigurationEntity> configurationEntities) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (configurationEntities != null) {
            for (OBDPConfigurationEntity entity : configurationEntities) {
                map.put(entity.getPropertyName(), entity.getPropertyValue());
            }
        }
        return map;
    }

    protected abstract T loadInstance(Collection<OBDPConfigurationEntity> var1);
}

