/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration;

import id.onyx.obdp.server.configuration.ConfigurationPropertyType;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OBDPServerConfigurationKey {
    AMBARI_MANAGES_LDAP_CONFIGURATION(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.manage_services", ConfigurationPropertyType.PLAINTEXT, "false", "A Boolean value indicating whether Ambari is to manage the LDAP configuration for services or not.", false),
    LDAP_ENABLED_SERVICES(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.enabled_services", ConfigurationPropertyType.PLAINTEXT, null, "A comma-delimited list of services that are expected to be configured for LDAP.  A \"*\" indicates all services.", false),
    LDAP_ENABLED(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.authentication.enabled", ConfigurationPropertyType.PLAINTEXT, "false", "An internal property used for unit testing and development purposes.", false),
    SERVER_HOST(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.server.host", ConfigurationPropertyType.PLAINTEXT, "localhost", "The LDAP URL host used for connecting to an LDAP server when authenticating users.", false),
    SERVER_PORT(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.server.port", ConfigurationPropertyType.PLAINTEXT, "33389", "The LDAP URL port used for connecting to an LDAP server when authenticating users.", false),
    SECONDARY_SERVER_HOST(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.secondary.server.host", ConfigurationPropertyType.PLAINTEXT, null, "A second LDAP URL host to use as a backup when authenticating users.", false),
    SECONDARY_SERVER_PORT(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.secondary.server.port", ConfigurationPropertyType.PLAINTEXT, null, "A second LDAP URL port to use as a backup when authenticating users.", false),
    USE_SSL(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.use_ssl", ConfigurationPropertyType.PLAINTEXT, "false", "Determines whether to use LDAP over SSL (LDAPS).", false),
    TRUST_STORE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.trust_store", ConfigurationPropertyType.PLAINTEXT, "", "", false),
    TRUST_STORE_TYPE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.trust_store.type", ConfigurationPropertyType.PLAINTEXT, null, "The type of truststore used by the 'javax.net.ssl.trustStoreType' property.", false),
    TRUST_STORE_PATH(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.trust_store.path", ConfigurationPropertyType.PLAINTEXT, null, "The location of the truststore to use when setting the 'javax.net.ssl.trustStore' property.", false),
    TRUST_STORE_PASSWORD(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.trust_store.password", ConfigurationPropertyType.PASSWORD, null, "The password to use when setting the 'javax.net.ssl.trustStorePassword' property", false),
    ANONYMOUS_BIND(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.anonymous_bind", ConfigurationPropertyType.PLAINTEXT, "true", "Determines whether LDAP requests can connect anonymously or if a managed user is required to connect.", false),
    BIND_DN(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.bind_dn", ConfigurationPropertyType.PLAINTEXT, null, "The DN of the manager account to use when binding to LDAP if anonymous binding is disabled.", false),
    BIND_PASSWORD(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.connectivity.bind_password", ConfigurationPropertyType.PASSWORD, null, "The password for the manager account used to bind to LDAP if anonymous binding is disabled.", false),
    ATTR_DETECTION(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.detection", ConfigurationPropertyType.PLAINTEXT, "", "", false),
    DN_ATTRIBUTE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.dn_attr", ConfigurationPropertyType.PLAINTEXT, "dn", "The attribute used for determining what the distinguished name property is.", false),
    USER_OBJECT_CLASS(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.user.object_class", ConfigurationPropertyType.PLAINTEXT, "person", "The class to which user objects in LDAP belong.", false),
    USER_NAME_ATTRIBUTE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.user.name_attr", ConfigurationPropertyType.PLAINTEXT, "uid", "The attribute used for determining the user name, such as 'uid'.", false),
    USER_GROUP_MEMBER_ATTRIBUTE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.user.group_member_attr", ConfigurationPropertyType.PLAINTEXT, "memberof", "The LDAP attribute which identifies user group membership.", false),
    USER_SEARCH_BASE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.user.search_base", ConfigurationPropertyType.PLAINTEXT, "dc=ambari,dc=apache,dc=org", "The base DN to use when filtering LDAP users and groups. This is only used when LDAP authentication is enabled.", false),
    USER_BASE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.search_user_base", ConfigurationPropertyType.PLAINTEXT, "ou=people,dc=ambari,dc=apache,dc=org", "The filter used when searching for users in LDAP.", false),
    GROUP_OBJECT_CLASS(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.group.object_class", ConfigurationPropertyType.PLAINTEXT, "posixGroup", "Specifies the LDAP object class value that defines groups in the directory service.", false),
    GROUP_NAME_ATTRIBUTE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.group.name_attr", ConfigurationPropertyType.PLAINTEXT, "cn", "The attribute used to determine the group name in LDAP.", false),
    GROUP_MEMBER_ATTRIBUTE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.group.member_attr", ConfigurationPropertyType.PLAINTEXT, "member", "The LDAP attribute which identifies group membership.", false),
    GROUP_SEARCH_BASE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.group.search_base", ConfigurationPropertyType.PLAINTEXT, "dc=ambari,dc=apache,dc=org", "The base DN to use when filtering LDAP users and groups. This is only used when LDAP authentication is enabled.", false),
    GROUP_BASE(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.attributes.group.search_group_base", ConfigurationPropertyType.PLAINTEXT, "ou=groups,dc=ambari,dc=apache,dc=org", "The filter used when searching for groups in LDAP.", false),
    USER_SEARCH_FILTER(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.user_search_filter", ConfigurationPropertyType.PLAINTEXT, "(&({usernameAttribute}={0})(objectClass={userObjectClass}))", "A filter used to lookup a user in LDAP based on the Ambari user name.", false),
    USER_MEMBER_REPLACE_PATTERN(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.user_member_replace_pattern", ConfigurationPropertyType.PLAINTEXT, "", "Regex pattern to use when replacing the user member attribute ID value with a placeholder. This is used in cases where a UID of an LDAP member is not a full CN or unique ID (e.g.: 'member: <SID=123>;<GID=123>;cn=myCn,dc=org,dc=apache')", false),
    USER_MEMBER_FILTER(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.user_member_filter", ConfigurationPropertyType.PLAINTEXT, "", "Filter to use for syncing user members of a group from LDAP (by default it is not used). For example: (&(objectclass=posixaccount)(uid={member}))", false),
    ALTERNATE_USER_SEARCH_ENABLED(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.alternate_user_search_enabled", ConfigurationPropertyType.PLAINTEXT, "false", "Determines whether a secondary (alternate) LDAP user search filer is used if the primary filter fails to find a user.", false),
    ALTERNATE_USER_SEARCH_FILTER(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.alternate_user_search_filter", ConfigurationPropertyType.PLAINTEXT, "(&(userPrincipalName={0})(objectClass={userObjectClass}))", "An alternate LDAP user search filter which can be used if 'authentication.ldap.alternateUserSearchEnabled' is enabled and the primary filter fails to find a user.", false),
    GROUP_SEARCH_FILTER(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.group_search_filter", ConfigurationPropertyType.PLAINTEXT, "", "The DN to use when searching for LDAP groups.", false),
    GROUP_MEMBER_REPLACE_PATTERN(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.group_member_replace_pattern", ConfigurationPropertyType.PLAINTEXT, "", "Regex pattern to use when replacing the group member attribute ID value with a placeholder. This is used in cases where a UID of an LDAP member is not a full CN or unique ID (e.g.: 'member: <SID=123>;<GID=123>;cn=myCn,dc=org,dc=apache')", false),
    GROUP_MEMBER_FILTER(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.group_member_filter", ConfigurationPropertyType.PLAINTEXT, "", "Filter to use for syncing group members of a group from LDAP. (by default it is not used). For example: (&(objectclass=posixgroup)(cn={member}))", false),
    GROUP_MAPPING_RULES(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.group_mapping_rules", ConfigurationPropertyType.PLAINTEXT, "Ambari Administrators", "A comma-separate list of groups which would give a user administrative access to Ambari when syncing from LDAP. This is only used when 'authorization.ldap.groupSearchFilter' is blank. For instance: Hadoop Admins, Hadoop Admins.*, DC Admins, .*Hadoop Operators", false),
    FORCE_LOWERCASE_USERNAMES(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.force_lowercase_usernames", ConfigurationPropertyType.PLAINTEXT, "", "Declares whether to force the ldap user name to be lowercase or leave as-is.\nThis is useful when local user names are expected to be lowercase but the LDAP user names are not.", false),
    REFERRAL_HANDLING(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.referrals", ConfigurationPropertyType.PLAINTEXT, "follow", "Determines whether to follow LDAP referrals to other URLs when the LDAP controller doesn't have the requested object.", false),
    PAGINATION_ENABLED(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.pagination_enabled", ConfigurationPropertyType.PLAINTEXT, "true", "Determines whether results from LDAP are paginated when requested.", false),
    COLLISION_BEHAVIOR(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.collision_behavior", ConfigurationPropertyType.PLAINTEXT, "convert", "Determines how to handle username collision while updating from LDAP.", false),
    DISABLE_ENDPOINT_IDENTIFICATION(OBDPServerConfigurationCategory.LDAP_CONFIGURATION, "ambari.ldap.advanced.disable_endpoint_identification", ConfigurationPropertyType.PLAINTEXT, "false", "Determines whether to disable endpoint identification (hostname verification) during SSL handshake while updating from LDAP.", false),
    SSO_MANAGE_SERVICES(OBDPServerConfigurationCategory.SSO_CONFIGURATION, "ambari.sso.manage_services", ConfigurationPropertyType.PLAINTEXT, "false", "A Boolean value indicating whether Ambari is to manage the SSO configuration for services or not.", false),
    SSO_ENABLED_SERVICES(OBDPServerConfigurationCategory.SSO_CONFIGURATION, "ambari.sso.enabled_services", ConfigurationPropertyType.PLAINTEXT, null, "A comma-delimited list of services that are expected to be configured for SSO.  A \"*\" indicates all services.", false),
    SSO_PROVIDER_URL(OBDPServerConfigurationCategory.SSO_CONFIGURATION, "ambari.sso.provider.url", ConfigurationPropertyType.PLAINTEXT, null, "The URL for SSO provider to use in the absence of a JWT token when handling a JWT request.", false),
    SSO_PROVIDER_CERTIFICATE(OBDPServerConfigurationCategory.SSO_CONFIGURATION, "ambari.sso.provider.certificate", ConfigurationPropertyType.PLAINTEXT, null, "The x509 certificate containing the public key to use when verifying the authenticity of a JWT token from the SSO provider.", false),
    SSO_PROVIDER_ORIGINAL_URL_PARAM_NAME(OBDPServerConfigurationCategory.SSO_CONFIGURATION, "ambari.sso.provider.originalUrlParamName", ConfigurationPropertyType.PLAINTEXT, "originalUrl", "The original URL to use when constructing the URL for SSO provider.", false),
    SSO_JWT_AUDIENCES(OBDPServerConfigurationCategory.SSO_CONFIGURATION, "ambari.sso.jwt.audiences", ConfigurationPropertyType.PLAINTEXT, null, "A list of the JWT audiences expected. Leaving this blank will allow for any audience.", false),
    SSO_JWT_COOKIE_NAME(OBDPServerConfigurationCategory.SSO_CONFIGURATION, "ambari.sso.jwt.cookieName", ConfigurationPropertyType.PLAINTEXT, "hadoop-jwt", "The name of the cookie which will be used to extract the JWT token from the request.", false),
    SSO_AUTHENTICATION_ENABLED(OBDPServerConfigurationCategory.SSO_CONFIGURATION, "ambari.sso.authentication.enabled", ConfigurationPropertyType.PLAINTEXT, "false", "Determines whether to use JWT authentication when logging into Ambari.", false),
    TPROXY_AUTHENTICATION_ENABLED(OBDPServerConfigurationCategory.TPROXY_CONFIGURATION, "ambari.tproxy.authentication.enabled", ConfigurationPropertyType.PLAINTEXT, "false", "Determines whether to allow a proxy user to specifiy a proxied user when logging into Ambari.", false),
    TPROXY_ALLOWED_HOSTS(OBDPServerConfigurationCategory.TPROXY_CONFIGURATION, "ambari\\.tproxy\\.proxyuser\\..+\\.hosts", ConfigurationPropertyType.PLAINTEXT, "", "List of hosts from which trusted-proxy user can connect.", true),
    TPROXY_ALLOWED_USERS(OBDPServerConfigurationCategory.TPROXY_CONFIGURATION, "ambari\\.tproxy\\.proxyuser\\..+\\.users", ConfigurationPropertyType.PLAINTEXT, "", "List of users which the trusted-proxy user can proxy for.", true),
    TPROXY_ALLOWED_GROUPS(OBDPServerConfigurationCategory.TPROXY_CONFIGURATION, "ambari\\.tproxy\\.proxyuser\\..+\\.groups", ConfigurationPropertyType.PLAINTEXT, "", "List of groups which the trusted-proxy user can proxy user for.", true);

    private static final Logger LOG;
    private final OBDPServerConfigurationCategory configurationCategory;
    private final String propertyName;
    private final ConfigurationPropertyType configurationPropertyType;
    private final String defaultValue;
    private final String description;
    private final boolean regex;

    private OBDPServerConfigurationKey(OBDPServerConfigurationCategory configurationCategory, String propName, ConfigurationPropertyType configurationPropertyType, String defaultValue, String description, boolean regex) {
        this.configurationCategory = configurationCategory;
        this.propertyName = propName;
        this.configurationPropertyType = configurationPropertyType;
        this.defaultValue = defaultValue;
        this.description = description;
        this.regex = regex;
    }

    public OBDPServerConfigurationCategory getConfigurationCategory() {
        return this.configurationCategory;
    }

    public String key() {
        return this.propertyName;
    }

    public ConfigurationPropertyType getConfigurationPropertyType() {
        return this.configurationPropertyType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public static OBDPServerConfigurationKey translate(OBDPServerConfigurationCategory category, String keyName) {
        if (category != null && StringUtils.isNotEmpty((String)keyName)) {
            for (OBDPServerConfigurationKey key : OBDPServerConfigurationKey.values()) {
                if (!key.configurationCategory.equals((Object)category) || (!key.regex || !keyName.matches(key.propertyName)) && !key.propertyName.equals(keyName)) continue;
                return key;
            }
        }
        String categoryName = category == null ? "null" : category.getCategoryName();
        LOG.warn("Invalid OBDP server configuration key: {}:{}", (Object)categoryName, (Object)keyName);
        return null;
    }

    public static Set<String> findPasswordConfigurations() {
        return Stream.of(OBDPServerConfigurationKey.values()).filter(k -> ConfigurationPropertyType.PASSWORD == k.getConfigurationPropertyType()).map(f -> f.propertyName).collect(Collectors.toSet());
    }

    static {
        LOG = LoggerFactory.getLogger(OBDPServerConfigurationKey.class);
    }
}

