/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OBDPServerConfigurationCategory {
    LDAP_CONFIGURATION("ldap-configuration"),
    SSO_CONFIGURATION("sso-configuration"),
    TPROXY_CONFIGURATION("tproxy-configuration");

    private static final Logger LOG;
    private final String categoryName;

    private OBDPServerConfigurationCategory(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public static OBDPServerConfigurationCategory translate(String categoryName) {
        if (!StringUtils.isEmpty((String)categoryName)) {
            categoryName = categoryName.trim();
            for (OBDPServerConfigurationCategory category : OBDPServerConfigurationCategory.values()) {
                if (!category.getCategoryName().equals(categoryName)) continue;
                return category;
            }
        }
        LOG.warn("Invalid Ambari server configuration category: {}", (Object)categoryName);
        return null;
    }

    public static String translate(OBDPServerConfigurationCategory category) {
        return category == null ? null : category.getCategoryName();
    }

    static {
        LOG = LoggerFactory.getLogger(OBDPServerConfigurationCategory.class);
    }
}

