/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration;

import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OBDPServerConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(OBDPServerConfiguration.class);
    protected final Map<String, String> configurationMap = new HashMap<String, String>();

    protected OBDPServerConfiguration(Map<String, String> configurationMap) {
        if (configurationMap != null) {
            this.configurationMap.putAll(configurationMap);
        }
    }

    protected String getValue(OBDPServerConfigurationKey ambariServerConfigurationKey, Map<String, String> configurationMap) {
        return this.getValue(ambariServerConfigurationKey.key(), configurationMap, ambariServerConfigurationKey.getDefaultValue());
    }

    protected String getValue(String propertyName, Map<String, String> configurationMap, String defaultValue) {
        if (configurationMap != null && configurationMap.containsKey(propertyName)) {
            return configurationMap.get(propertyName);
        }
        LOGGER.debug("OBDP server configuration property [{}] hasn't been set; using default value", (Object)propertyName);
        return defaultValue;
    }

    public Map<String, String> toMap() {
        return new HashMap<String, String>(this.configurationMap);
    }

    public void setValueFor(String configName, String value) {
        OBDPServerConfigurationKey ambariServerConfigurationKey = OBDPServerConfigurationKey.translate(this.getCategory(), configName);
        if (ambariServerConfigurationKey != null) {
            this.setValueFor(ambariServerConfigurationKey, value);
        }
    }

    public void setValueFor(OBDPServerConfigurationKey ambariServerConfigurationKey, String value) {
        if (ambariServerConfigurationKey.getConfigurationCategory() != this.getCategory()) {
            throw new IllegalArgumentException(ambariServerConfigurationKey.key() + " is not a valid " + this.getCategory().getCategoryName());
        }
        this.configurationMap.put(ambariServerConfigurationKey.key(), value);
    }

    protected abstract OBDPServerConfigurationCategory getCategory();
}

