/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration;

import com.google.common.base.Charsets;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.ClusterScale;
import id.onyx.obdp.annotations.ConfigurationMarkdown;
import id.onyx.obdp.annotations.Markdown;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.CommandExecutionType;
import id.onyx.obdp.server.orm.JPATableGenerationStrategy;
import id.onyx.obdp.server.orm.PersistenceType;
import id.onyx.obdp.server.security.ClientSecurityType;
import id.onyx.obdp.server.security.authentication.kerberos.AmbariKerberosAuthenticationProperties;
import id.onyx.obdp.server.security.encryption.CredentialProvider;
import id.onyx.obdp.server.state.stack.OsFamily;
import id.onyx.obdp.server.topology.addservice.GroupByComponentsStrategy;
import id.onyx.obdp.server.topology.addservice.HostGroupStrategy;
import id.onyx.obdp.server.upgrade.AbstractUpgradeCatalog;
import id.onyx.obdp.server.utils.AmbariPath;
import id.onyx.obdp.server.utils.PasswordUtils;
import id.onyx.obdp.server.utils.ShellCommandUtil;
import id.onyx.obdp.server.utils.StageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Configuration {
    private static final String OBDP_CONFIGURATION_MD_TEMPLATE_PROPERTY = "ambari.configuration.md.template";
    private static final String MARKDOWN_TEMPLATE_FILE = "index_template.md";
    private static final String MARKDOWN_CONFIGURATION_TABLE_KEY = "$configuration-properties";
    private static final String MARKDOWN_BASELINE_VALUES_KEY = "$baseline-values";
    private static final String MARKDOWN_RELATED_TO_TEMPLATE = " This property is related to `%s`.";
    private static final String HTML_BREAK_TAG = "<br/>";
    private static final String AGENT_CONFIGS_DEFAULT_SECTION = "agentConfig";
    @Inject
    private OsFamily osFamily;
    private static final String CONFIG_FILE = "obdp.properties";
    public static final String PREFIX_DIR = "/var/lib/obdp-agent/data";
    public static final float JDK_MIN_VERSION = 1.7f;
    public static final String SERVER_JDBC_PROPERTIES_PREFIX = "server.jdbc.properties.";
    public static final String SERVER_PERSISTENCE_PROPERTIES_PREFIX = "server.persistence.properties.";
    public static final String HOSTNAME_MACRO = "{hostname}";
    public static final String JDBC_UNIT_NAME = "obdp-server";
    public static final String JDBC_LOCAL_URL = "jdbc:postgresql://localhost/";
    public static final String DEFAULT_DERBY_SCHEMA = "obdp";
    public static final String DEFAULT_H2_SCHEMA = "obdp";
    public static final String JDBC_IN_MEMORY_URL = String.format("jdbc:h2:mem:%1$s;ALIAS_COLUMN_NAME=TRUE;INIT=CREATE SCHEMA IF NOT EXISTS %1$s\\;SET SCHEMA %1$s;", "obdp");
    public static final String JDBC_IN_MEMORY_DRIVER = "org.h2.Driver";
    public static final String JDBC_IN_MEMORY_USER = "sa";
    public static final String JDBC_IN_MEMORY_PASSWORD = "";
    public static final String JAVAX_SSL_TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String JAVAX_SSL_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String JAVAX_SSL_TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String MAPREDUCE2_LOG4J_CONFIG_TAG = "mapreduce2-log4j";
    public static final int PROCESSOR_BASED_THREADPOOL_CORE_SIZE_DEFAULT = 2 * Runtime.getRuntime().availableProcessors();
    public static final int PROCESSOR_BASED_THREADPOOL_MAX_SIZE_DEFAULT = 4 * Runtime.getRuntime().availableProcessors();
    private static final Set<String> dbConnectorPropertyNames = Sets.newHashSet((Object[])new String[]{"custom.mysql.jdbc.name", "custom.oracle.jdbc.name", "custom.postgres.jdbc.name", "custom.mssql.jdbc.name", "custom.hsqldb.jdbc.name", "custom.sqlanywhere.jdbc.name"});
    public static final String MASTER_KEY_ENV_PROP = "OBDP_SECURITY_MASTER_KEY";
    public static final String MASTER_KEY_FILENAME_DEFAULT = "master";
    public static final String MASTER_KEYSTORE_FILENAME_DEFAULT = "credentials.jceks";
    public static final String SERVER_VERSION_KEY = "version";
    public static final String AMBARI_LOG_FILE = "log4j.properties";
    public static final int MAXIMUM_PASSWORD_HISTORY_LIMIT = 10;
    public static final int MINIMUM_PASSWORD_HISTORY_LIMIT = 1;
    @Markdown(description="Interval for heartbeat presence checks.", examples={"60000", "600000"})
    public static final ConfigurationProperty<Integer> HEARTBEAT_MONITORING_INTERVAL = new ConfigurationProperty<Integer>("heartbeat.monitoring.interval", 60000);
    @Markdown(description="The directory on the OBDP Server file system used for storing OBDP Agent bootstrap information such as request responses.")
    public static final ConfigurationProperty<String> BOOTSTRAP_DIRECTORY = new ConfigurationProperty<String>("bootstrap.dir", AmbariPath.getPath("/var/run/obdp-server/bootstrap"));
    @Markdown(description="The directory on the OBDP Server file system used for expanding Views and storing webapp work.")
    public static final ConfigurationProperty<String> VIEWS_DIRECTORY = new ConfigurationProperty<String>("views.dir", AmbariPath.getPath("/var/lib/obdp-server/resources/views"));
    @Markdown(description="Determines whether to validate a View's configuration XML file against an XSD.")
    public static final ConfigurationProperty<String> VIEWS_VALIDATE = new ConfigurationProperty<String>("views.validate", "false");
    @Markdown(description="Determines whether the view directory watcher service should be disabled.")
    public static final ConfigurationProperty<String> DISABLE_VIEW_DIRECTORY_WATCHER = new ConfigurationProperty<String>("views.directory.watcher.disable", "false");
    @Markdown(description="Determines whether remove undeployed views from the OBDP database.")
    public static final ConfigurationProperty<String> VIEWS_REMOVE_UNDEPLOYED = new ConfigurationProperty<String>("views.remove.undeployed", "false");
    @Markdown(description="The ONYX Big Data Server webapp root directory.")
    public static final ConfigurationProperty<String> WEBAPP_DIRECTORY = new ConfigurationProperty<String>("webapp.dir", "web");
    @Markdown(description="The location and name of the Python script used to bootstrap new OBDP Agent hosts.")
    public static final ConfigurationProperty<String> BOOTSTRAP_SCRIPT = new ConfigurationProperty<String>("bootstrap.script", AmbariPath.getPath("/usr/lib/obdp-server/lib/obdp_server/bootstrap.py"));
    @Markdown(description="The location and name of the Python script executed on the OBDP Agent host during the bootstrap process.")
    public static final ConfigurationProperty<String> BOOTSTRAP_SETUP_AGENT_SCRIPT = new ConfigurationProperty<String>("bootstrap.setup_agent.script", AmbariPath.getPath("/usr/lib/obdp-server/lib/obdp_server/setupAgent.py"));
    @Markdown(description="The password to set on the `AMBARI_PASSPHRASE` environment variable before invoking the bootstrap script.")
    public static final ConfigurationProperty<String> BOOTSTRAP_SETUP_AGENT_PASSWORD = new ConfigurationProperty<String>("bootstrap.setup_agent.password", "password");
    @Markdown(description="The host name of the OBDP Server which will be used by the OBDP Agents for communication.")
    public static final ConfigurationProperty<String> BOOTSTRAP_MASTER_HOSTNAME = new ConfigurationProperty<Object>("bootstrap.master_host_name", null);
    @Markdown(description="The amount of time that Recommendation API data is kept on the OBDP Server file system. This is specified using a `hdwmy` syntax for pairing the value with a time unit (hours, days, weeks, months, years)", examples={"8h", "2w", "1m"})
    public static final ConfigurationProperty<String> RECOMMENDATIONS_ARTIFACTS_LIFETIME = new ConfigurationProperty<String>("recommendations.artifacts.lifetime", "1w");
    @Markdown(description="Maximum number of recommendations artifacts at a given time", examples={"50", "10", "100"})
    public static final ConfigurationProperty<Integer> RECOMMENDATIONS_ARTIFACTS_ROLLOVER_MAX = new ConfigurationProperty<Integer>("recommendations.artifacts.rollover.max", 100);
    @Markdown(description="The directory on the OBDP Server file system used for storing Recommendation API artifacts.")
    public static final ConfigurationProperty<String> RECOMMENDATIONS_DIR = new ConfigurationProperty<String>("recommendations.dir", AmbariPath.getPath("/var/run/obdp-server/stack-recommendations"));
    @Markdown(description="The location and name of the Python stack advisor script executed when configuring services.")
    public static final ConfigurationProperty<String> STACK_ADVISOR_SCRIPT = new ConfigurationProperty<String>("stackadvisor.script", AmbariPath.getPath("/var/lib/obdp-server/resources/scripts/stack_advisor.py"));
    @Markdown(description="The name of the shell script used to wrap all invocations of Python by ONYX Big Data Platform. ")
    public static final ConfigurationProperty<String> OBDP_PYTHON_WRAP = new ConfigurationProperty<String>("obdp.python.wrap", "obdp-python");
    @Markdown(description="The username of the default user assumed to be executing API calls. When set, authentication is not required in order to login to OBDP or use the REST APIs.  ")
    public static final ConfigurationProperty<String> API_AUTHENTICATED_USER = new ConfigurationProperty<Object>("api.authenticated.user", null);
    @Markdown(description="Determines whether SSL is used in for secure connections to OBDP. When enabled, obdp-server setup-https must be run in order to properly configure keystores.")
    public static final ConfigurationProperty<String> API_USE_SSL = new ConfigurationProperty<String>("api.ssl", "false");
    @Markdown(description="Determines whether Cross-Site Request Forgery attacks are prevented by looking for the `X-Requested-By` header.")
    public static final ConfigurationProperty<String> API_CSRF_PREVENTION = new ConfigurationProperty<String>("api.csrfPrevention.enabled", "true");
    @Markdown(description="Determines whether jetty Gzip compression is enabled or not.")
    public static final ConfigurationProperty<String> GZIP_HANDLER_JETTY_ENABLED = new ConfigurationProperty<String>("gzip.handler.jetty.enabled", "true");
    @Markdown(description="Determines whether data sent to and from the OBDP service should be compressed.")
    public static final ConfigurationProperty<String> API_GZIP_COMPRESSION_ENABLED = new ConfigurationProperty<String>("api.gzip.compression.enabled", "true");
    @Markdown(description="Used in conjunction with `api.gzip.compression.enabled`, determines the mininum size that an HTTP request must be before it should be compressed. This is measured in bytes.")
    public static final ConfigurationProperty<String> API_GZIP_MIN_COMPRESSION_SIZE = new ConfigurationProperty<String>("api.gzip.compression.min.size", "10240");
    @Markdown(description="Determiens whether communication with the OBDP Agents should have the JSON payloads compressed with GZIP.")
    public static final ConfigurationProperty<String> AGENT_API_GZIP_COMPRESSION_ENABLED = new ConfigurationProperty<String>("agent.api.gzip.compression.enabled", "true");
    @Markdown(description="Determines whether SSL is used to communicate between OBDP Server and OBDP Agents.")
    public static final ConfigurationProperty<String> AGENT_USE_SSL = new ConfigurationProperty<String>("agent.ssl", "true");
    @Markdown(description="Determines OBDP user password policy. Passwords should match the regex")
    public static final ConfigurationProperty<String> PASSWORD_POLICY_REGEXP = new ConfigurationProperty<String>("security.password.policy.regexp", ".*");
    @Markdown(description="Password policy description that is shown to users")
    public static final ConfigurationProperty<String> PASSWORD_POLICY_DESCRIPTION = new ConfigurationProperty<String>("security.password.policy.description", "");
    @Markdown(description="Password policy to mandate that new password should be different from previous passwords, this would be based on the history count configured by the user. Valid values are 1 to 10.")
    public static final ConfigurationProperty<String> PASSWORD_POLICY_HISTORY_COUNT = new ConfigurationProperty<String>("security.password.policy.history.count", "1");
    @Markdown(description="Determines whether the OBDP Agent host names should be validated against a regular expression to ensure that they are well-formed.<br><br>WARNING: By setting this value to false, host names will not be validated, allowing a possible security vulnerability as described in CVE-2014-3582. See https://cwiki.apache.org/confluence/display/OBDP/Ambari+Vulnerabilities for more information.")
    public static final ConfigurationProperty<String> SRVR_AGENT_HOSTNAME_VALIDATE = new ConfigurationProperty<String>("security.agent.hostname.validate", "true");
    @Markdown(description="Determines whether two-way SSL should be used between OBDP Server and OBDP Agents so that the agents must also use SSL.")
    public static final ConfigurationProperty<String> SRVR_TWO_WAY_SSL = new ConfigurationProperty<String>("security.server.two_way_ssl", "false");
    @Markdown(description="The port that the OBDP Server will use to communicate with the agents over SSL.")
    public static final ConfigurationProperty<String> SRVR_TWO_WAY_SSL_PORT = new ConfigurationProperty<String>("security.server.two_way_ssl.port", "8441");
    @Markdown(description="The port that the OBDP Agents will use to communicate with the OBDP Server over SSL.")
    public static final ConfigurationProperty<String> SRVR_ONE_WAY_SSL_PORT = new ConfigurationProperty<String>("security.server.one_way_ssl.port", "8440");
    @Markdown(description="The directory on the OBDP Server where keystores are kept.")
    public static final ConfigurationProperty<String> SRVR_KSTR_DIR = new ConfigurationProperty<String>("security.server.keys_dir", ".");
    @Markdown(description="The name of the file located in the `security.server.keys_dir` directory where certificates will be generated when OBDP uses the `openssl ca` command.")
    public static final ConfigurationProperty<String> SRVR_CRT_NAME = new ConfigurationProperty<String>("security.server.cert_name", "ca.crt");
    @Markdown(description="The name of the file located in the `security.server.keys_dir` directory containing the CA certificate chain used to verify certificates during 2-way SSL communications.")
    public static final ConfigurationProperty<String> SRVR_CRT_CHAIN_NAME = new ConfigurationProperty<String>("security.server.cert_chain_name", "ca_chain.pem");
    @Markdown(description="The name of the certificate request file used when generating certificates.")
    public static final ConfigurationProperty<String> SRVR_CSR_NAME = new ConfigurationProperty<String>("security.server.csr_name", "ca.csr");
    @Markdown(description="The name of the private key used to sign requests.")
    public static final ConfigurationProperty<String> SRVR_KEY_NAME = new ConfigurationProperty<String>("security.server.key_name", "ca.key");
    @Markdown(description="The name of the keystore file, located in `security.server.keys_dir`")
    public static final ConfigurationProperty<String> KSTR_NAME = new ConfigurationProperty<String>("security.server.keystore_name", "keystore.p12");
    @Markdown(description="The type of the keystore file specified in `security.server.key_name`. Self-signed certificates can be `PKCS12` while CA signed certificates are `JKS`")
    public static final ConfigurationProperty<String> KSTR_TYPE = new ConfigurationProperty<String>("security.server.keystore_type", "PKCS12");
    @Markdown(description="The name of the truststore file obdp uses to store trusted certificates. Located in `security.server.keys_dir`")
    public static final ConfigurationProperty<String> TSTR_NAME = new ConfigurationProperty<String>("security.server.truststore_name", "keystore.p12");
    @Markdown(description="The type of the truststore file specified in `security.server.truststore_name`. Self-signed certificates can be `PKCS12` while CA signed certificates are `JKS`")
    public static final ConfigurationProperty<String> TSTR_TYPE = new ConfigurationProperty<String>("security.server.truststore_type", "PKCS12");
    @Markdown(description="The filename which contains the password for the keystores, truststores, and certificates.")
    public static final ConfigurationProperty<String> SRVR_CRT_PASS_FILE = new ConfigurationProperty<String>("security.server.crt_pass_file", "pass.txt");
    @Markdown(description="The password for the keystores, truststores, and certificates. If not specified, then `security.server.crt_pass_file` should be used")
    public static final ConfigurationProperty<String> SRVR_CRT_PASS = new ConfigurationProperty<Object>("security.server.crt_pass", null);
    @Markdown(description="The length of the randomly generated password for keystores and truststores. ")
    public static final ConfigurationProperty<String> SRVR_CRT_PASS_LEN = new ConfigurationProperty<String>("security.server.crt_pass.len", "50");
    @Markdown(description="An environment variable which can be used to supply the OBDP Server password when bootstrapping new OBDP Agents.")
    public static final ConfigurationProperty<String> PASSPHRASE_ENV = new ConfigurationProperty<String>("security.server.passphrase_env_var", "AMBARI_PASSPHRASE");
    @Markdown(description="The password to the OBDP Server to supply to new OBDP Agent hosts being bootstrapped.")
    public static final ConfigurationProperty<String> PASSPHRASE = new ConfigurationProperty<String>("security.server.passphrase", "AMBARI_PASSPHRASE");
    @Markdown(description="A list of cipher suites which are not strong enough to use and will be excluded when creating SSL connections.", examples={"SSL_RSA_WITH_RC4_128_MD5\\|SSL_RSA_WITH_RC4_12\u200c\u200b8_MD5"})
    public static final ConfigurationProperty<String> SRVR_DISABLED_CIPHERS = new ConfigurationProperty<String>("security.server.disabled.ciphers", "");
    @Markdown(description="The list of protocols which should not be used when creating SSL connections.", examples={"TLSv1.1\\|TLSv1.2"})
    public static final ConfigurationProperty<String> SRVR_DISABLED_PROTOCOLS = new ConfigurationProperty<String>("security.server.disabled.protocols", "");
    @Markdown(description="The location on the OBDP Server where all resources exist, including common services, stacks, and scripts.")
    public static final ConfigurationProperty<String> RESOURCES_DIR = new ConfigurationProperty<String>("resources.dir", AmbariPath.getPath("/var/lib/obdp-server/resources/"));
    @Markdown(description="The location on the OBDP Server where the stack resources exist.", examples={"/var/lib/obdp-server/resources/stacks"})
    public static final ConfigurationProperty<String> METADATA_DIR_PATH = new ConfigurationProperty<Object>("metadata.path", null);
    @Markdown(description="The location on the OBDP Server where common service resources exist. Stack services share the common service files.", examples={"/var/lib/obdp-server/resources/common-services"})
    public static final ConfigurationProperty<String> COMMON_SERVICES_DIR_PATH = new ConfigurationProperty<Object>("common.services.path", null);
    @Markdown(description="Determines how to handle username collision while updating from LDAP.", examples={"skip", "convert", "add"})
    public static final ConfigurationProperty<String> LDAP_SYNC_USERNAME_COLLISIONS_BEHAVIOR = new ConfigurationProperty<String>("ldap.sync.username.collision.behavior", "add");
    @Markdown(description="The location on the OBDP Server where stack extensions exist.", examples={"/var/lib/obdp-server/resources/extensions"})
    public static final ConfigurationProperty<String> EXTENSIONS_DIR_PATH = new ConfigurationProperty<Object>("extensions.path", null);
    @Markdown(description="The OBDP Management Pack staging directory on the OBDP Server.", examples={"/var/lib/obdp-server/resources/mpacks"})
    public static final ConfigurationProperty<String> MPACKS_STAGING_DIR_PATH = new ConfigurationProperty<Object>("mpacks.staging.path", null);
    @Markdown(description="The OBDP Management Pack version-2 staging directory on the OBDP Server.", examples={"/var/lib/obdp-server/resources/mpacks-v2"})
    public static final ConfigurationProperty<String> MPACKS_V2_STAGING_DIR_PATH = new ConfigurationProperty<Object>("mpacks-v2.staging.path", null);
    @Markdown(description="The full path to the file which contains the OBDP Server version. This is used to ensure that there is not a version mismatch between OBDP Agents and OBDP Server.", examples={"/var/lib/obdp-server/resources/version"})
    public static final ConfigurationProperty<String> SERVER_VERSION_FILE = new ConfigurationProperty<Object>("server.version.file", null);
    @Markdown(description="Whether user accepted GPL license.")
    public static final ConfigurationProperty<Boolean> GPL_LICENSE_ACCEPTED = new ConfigurationProperty<Boolean>("gpl.license.accepted", false);
    @Markdown(description="The location of the JDK on the OBDP Agent hosts. If stack.java.home exists, that is only used by OBDP Server (or you can find that as obdp_java_home in the commandParams on the agent side)", examples={"/usr/jdk64/jdk-17.0.12"})
    public static final ConfigurationProperty<String> JAVA_HOME = new ConfigurationProperty<Object>("java.home", null);
    @Markdown(description="The location of the JDK on the OBDP Agent hosts. This is only used by OBDP Server", examples={"/usr/jdk64/jdk-17.0.12"})
    public static final ConfigurationProperty<String> AMBARI_JAVA_HOME = new ConfigurationProperty<Object>("ambari.java.home", null);
    @Markdown(description="The name of the JDK installation binary. If stack.jdk.name exists, that is only used by OBDP Server (or you can find that as ambari_jdk_name in the commandParams on the agent side)", examples={"jdk-8u112-linux-x64.tar.gz"})
    public static final ConfigurationProperty<String> JDK_NAME = new ConfigurationProperty<Object>("jdk.name", null);
    @Markdown(description="The name of the JCE policy ZIP file. If stack.jce.name exists, that is only used by OBDP Server (or you can find that as ambari_jce_name in the commandParams on the agent side)", examples={"UnlimitedJCEPolicyJDK8.zip"})
    public static final ConfigurationProperty<String> JCE_NAME = new ConfigurationProperty<Object>("jce.name", null);
    @Markdown(description="The location of the JDK on the OBDP Agent hosts for stack services.", examples={"/usr/jdk64/jdk1.7.0_45"})
    public static final ConfigurationProperty<String> STACK_JAVA_HOME = new ConfigurationProperty<Object>("stack.java.home", null);
    @Markdown(description="The name of the JDK installation binary for stack services.", examples={"jdk-7u45-linux-x64.tar.gz"})
    public static final ConfigurationProperty<String> STACK_JDK_NAME = new ConfigurationProperty<Object>("stack.jdk.name", null);
    @Markdown(description="The name of the JCE policy ZIP file for stack services.", examples={"UnlimitedJCEPolicyJDK7.zip"})
    public static final ConfigurationProperty<String> STACK_JCE_NAME = new ConfigurationProperty<Object>("stack.jce.name", null);
    @Markdown(description="JDK version of the stack, use in case of it differs from OBDP JDK version.", examples={"1.7"})
    public static final ConfigurationProperty<String> STACK_JAVA_VERSION = new ConfigurationProperty<Object>("stack.java.version", null);
    @Markdown(description="The auto group creation by OBDP")
    public static final ConfigurationProperty<Boolean> AUTO_GROUP_CREATION = new ConfigurationProperty<Boolean>("auto.group.creation", Boolean.FALSE);
    @Markdown(description="The PAM configuration file.")
    public static final ConfigurationProperty<String> PAM_CONFIGURATION_FILE = new ConfigurationProperty<Object>("pam.configuration", null);
    @Markdown(examples={"local", "ldap", "pam"}, description="The type of authentication mechanism used by OBDP.")
    public static final ConfigurationProperty<String> CLIENT_SECURITY = new ConfigurationProperty<Object>("client.security", null);
    @Markdown(description="The port that client connections will use with the REST API. The OBDP Web client runs on this port.")
    public static final ConfigurationProperty<String> CLIENT_API_PORT = new ConfigurationProperty<String>("client.api.port", "8080");
    @Markdown(description="The port that client connections will use with the REST API when using SSL. The OBDP Web client runs on this port if SSL is enabled.")
    public static final ConfigurationProperty<String> CLIENT_API_SSL_PORT = new ConfigurationProperty<String>("client.api.ssl.port", "8443");
    @Markdown(description="The location on the OBDP server where the REST API keystore and password files are stored if using SSL.")
    public static final ConfigurationProperty<String> CLIENT_API_SSL_KSTR_DIR_NAME = new ConfigurationProperty<Object>("client.api.ssl.keys_dir", null);
    @Markdown(description="The name of the keystore used when the OBDP Server REST API is protected by SSL.")
    public static final ConfigurationProperty<String> CLIENT_API_SSL_KSTR_NAME = new ConfigurationProperty<String>("client.api.ssl.keystore_name", "https.keystore.p12");
    @Markdown(description="The type of the keystore file specified in `client.api.ssl.keystore_name`. Self-signed certificates can be `PKCS12` while CA signed certificates are `JKS`")
    public static final ConfigurationProperty<String> CLIENT_API_SSL_KSTR_TYPE = new ConfigurationProperty<String>("client.api.ssl.keystore_type", "PKCS12");
    @Markdown(description="The name of the truststore used when the OBDP Server REST API is protected by SSL.")
    public static final ConfigurationProperty<String> CLIENT_API_SSL_TSTR_NAME = new ConfigurationProperty<String>("client.api.ssl.truststore_name", "https.keystore.p12");
    @Markdown(description="The type of the keystore file specified in `client.api.ssl.truststore_name`. Self-signed certificates can be `PKCS12` while CA signed certificates are `JKS`")
    public static final ConfigurationProperty<String> CLIENT_API_SSL_TSTR_TYPE = new ConfigurationProperty<String>("client.api.ssl.truststore_type", "PKCS12");
    @Markdown(description="The filename which contains the password for the keystores, truststores, and certificates for the REST API when it's protected by SSL.")
    public static final ConfigurationProperty<String> CLIENT_API_SSL_CRT_PASS_FILE_NAME = new ConfigurationProperty<String>("client.api.ssl.cert_pass_file", "https.pass.txt");
    @Markdown(description="The password for the keystores, truststores, and certificates for the REST API when it's protected by SSL. If not specified, then `client.api.ssl.cert_pass_file` should be used.")
    public static final ConfigurationProperty<String> CLIENT_API_SSL_CRT_PASS = new ConfigurationProperty<Object>("client.api.ssl.crt_pass", null);
    @Markdown(description="Determines whether the agents will automatically attempt to download updates to stack resources from the OBDP Server.")
    public static final ConfigurationProperty<String> ENABLE_AUTO_AGENT_CACHE_UPDATE = new ConfigurationProperty<String>("agent.auto.cache.update", "true");
    @Markdown(description="Determines whether the OBDP Agents will use the `df` or `df -l` command when checking disk mounts for capacity issues. Auto-mounted remote directories can cause long delays.")
    public static final ConfigurationProperty<String> CHECK_REMOTE_MOUNTS = new ConfigurationProperty<String>("agent.check.remote.mounts", "false");
    @Markdown(description="The timeout, used by the `timeout` command in linux, when checking mounts for free capacity.")
    public static final ConfigurationProperty<String> CHECK_MOUNTS_TIMEOUT = new ConfigurationProperty<String>("agent.check.mounts.timeout", "0");
    @Markdown(description="The path of the file which lists the properties that should be masked from the api that returns obdp.properties")
    public static final ConfigurationProperty<String> PROPERTY_MASK_FILE = new ConfigurationProperty<Object>("property.mask.file", null);
    @Markdown(description="The name of the database.")
    public static final ConfigurationProperty<String> SERVER_DB_NAME = new ConfigurationProperty<String>("server.jdbc.database_name", "obdp");
    @Markdown(description="The amount of time, in milliseconds, that a view will wait before terminating an HTTP(S) read request.")
    public static final ConfigurationProperty<String> REQUEST_READ_TIMEOUT = new ConfigurationProperty<String>("views.request.read.timeout.millis", "10000");
    @Markdown(description="The amount of time, in milliseconds, that a view will wait when trying to connect on HTTP(S) operations to a remote resource.")
    public static final ConfigurationProperty<String> REQUEST_CONNECT_TIMEOUT = new ConfigurationProperty<String>("views.request.connect.timeout.millis", "5000");
    @Markdown(description="The amount of time, in milliseconds, that a view will wait before terminating an HTTP(S) read request to the OBDP REST API.")
    public static final ConfigurationProperty<String> AMBARI_REQUEST_READ_TIMEOUT = new ConfigurationProperty<String>("views.ambari.request.read.timeout.millis", "45000");
    @Markdown(description="The amount of time, in milliseconds, that a view will wait when trying to connect on HTTP(S) operations to the OBDP REST API.")
    public static final ConfigurationProperty<String> AMBARI_REQUEST_CONNECT_TIMEOUT = new ConfigurationProperty<String>("views.ambari.request.connect.timeout.millis", "30000");
    @Markdown(description="The schema within a named PostgreSQL database where OBDP tables, users, and constraints are stored. ")
    public static final ConfigurationProperty<String> SERVER_JDBC_POSTGRES_SCHEMA_NAME = new ConfigurationProperty<String>("server.jdbc.postgres.schema", "");
    @Markdown(description="The name of the Oracle JDBC JAR connector.")
    public static final ConfigurationProperty<String> OJDBC_JAR_NAME = new ConfigurationProperty<String>("db.oracle.jdbc.name", "ojdbc6.jar");
    @Markdown(description="The name of the MySQL JDBC JAR connector.")
    public static final ConfigurationProperty<String> MYSQL_JAR_NAME = new ConfigurationProperty<String>("db.mysql.jdbc.name", "mysql-connector-java.jar");
    @Markdown(description="Enable the profiling of internal locks.")
    public static final ConfigurationProperty<Boolean> SERVER_LOCKS_PROFILING = new ConfigurationProperty<Boolean>("server.locks.profiling", Boolean.FALSE);
    @Markdown(description="The size of the cache which is used to hold current operations in memory until they complete.")
    public static final ConfigurationProperty<Long> SERVER_EC_CACHE_SIZE = new ConfigurationProperty<Long>("server.ecCacheSize", 10000L);
    @Markdown(description="Determines whether an existing request's status is cached. This is enabled by default to prevent increases in database access when there are long running operations in progress.")
    public static final ConfigurationProperty<Boolean> SERVER_HRC_STATUS_SUMMARY_CACHE_ENABLED = new ConfigurationProperty<Boolean>("server.hrcStatusSummary.cache.enabled", Boolean.TRUE);
    @Markdown(relatedTo="server.hrcStatusSummary.cache.enabled", description="The size of the cache which is used to hold a status of every operation in a request.")
    public static final ConfigurationProperty<Long> SERVER_HRC_STATUS_SUMMARY_CACHE_SIZE = new ConfigurationProperty<Long>("server.hrcStatusSummary.cache.size", 10000L);
    @Markdown(relatedTo="server.hrcStatusSummary.cache.enabled", description="The expiration time, in minutes, of the request status cache.")
    public static final ConfigurationProperty<Long> SERVER_HRC_STATUS_SUMMARY_CACHE_EXPIRY_DURATION = new ConfigurationProperty<Long>("server.hrcStatusSummary.cache.expiryDuration", 30L);
    @Markdown(description="Determines when the stale configuration cache is enabled. If disabled, then queries to determine if components need to be restarted will query the database directly.")
    public static final ConfigurationProperty<Boolean> SERVER_STALE_CONFIG_CACHE_ENABLED = new ConfigurationProperty<Boolean>("server.cache.isStale.enabled", Boolean.TRUE);
    @Markdown(relatedTo="server.cache.isStale.enabled", description="The expiration time, in {@link TimeUnit#MINUTES}, that stale configuration information is cached.")
    public static final ConfigurationProperty<Integer> SERVER_STALE_CONFIG_CACHE_EXPIRATION = new ConfigurationProperty<Integer>("server.cache.isStale.expiration", 600);
    @Markdown(examples={"local", "remote"}, description="The type of database connection being used. Unless using an embedded PostgresSQL server, then this should be `remote`.")
    public static final ConfigurationProperty<String> SERVER_PERSISTENCE_TYPE = new ConfigurationProperty<String>("server.persistence.type", "local");
    @Markdown(description="The user name used to login to the database.")
    public static final ConfigurationProperty<String> SERVER_JDBC_USER_NAME = new ConfigurationProperty<String>("server.jdbc.user.name", "obdp");
    @Markdown(description="The password for the user when logging into the database.")
    public static final ConfigurationProperty<String> SERVER_JDBC_USER_PASSWD = new ConfigurationProperty<String>("server.jdbc.user.passwd", "bigdata");
    @Markdown(description="The name of the PostgresSQL JDBC JAR connector.")
    public static final ConfigurationProperty<String> SERVER_JDBC_DRIVER = new ConfigurationProperty<String>("server.jdbc.driver", "org.postgresql.Driver");
    @Markdown(internal=true, description="The full JDBC url used for in-memory database creation.")
    public static final ConfigurationProperty<String> SERVER_JDBC_URL = new ConfigurationProperty<Object>("server.jdbc.url", null);
    @Markdown(description="The size of the buffer to use, in bytes, for REST API HTTP header requests.")
    public static final ConfigurationProperty<Integer> SERVER_HTTP_REQUEST_HEADER_SIZE = new ConfigurationProperty<Integer>("server.http.request.header.size", 65536);
    @Markdown(description="The size of the buffer to use, in bytes, for REST API HTTP header responses.")
    public static final ConfigurationProperty<Integer> SERVER_HTTP_RESPONSE_HEADER_SIZE = new ConfigurationProperty<Integer>("server.http.response.header.size", 65536);
    @Markdown(description="A comma-separated list of packages which will be skipped during a stack upgrade.")
    public static final ConfigurationProperty<String> ROLLING_UPGRADE_SKIP_PACKAGES_PREFIXES = new ConfigurationProperty<String>("rolling.upgrade.skip.packages.prefixes", "");
    @Markdown(description="Determines whether pre-upgrade checks will be skipped when performing a rolling or express stack upgrade.")
    public static final ConfigurationProperty<Boolean> STACK_UPGRADE_BYPASS_PRECHECKS = new ConfigurationProperty<Boolean>("stack.upgrade.bypass.prechecks", Boolean.FALSE);
    @Markdown(description="The amount of time to wait in order to retry a command during a stack upgrade when an agent loses communication. This value must be greater than the `agent.task.timeout` value.")
    public static final ConfigurationProperty<Integer> STACK_UPGRADE_AUTO_RETRY_TIMEOUT_MINS = new ConfigurationProperty<Integer>("stack.upgrade.auto.retry.timeout.mins", 0);
    @Markdown(relatedTo="stack.upgrade.auto.retry.timeout.mins", description="The amount of time to wait, in seconds, between checking for upgrade tasks to be retried. This value is only applicable if `stack.upgrade.auto.retry.timeout.mins` is positive.")
    public static final ConfigurationProperty<Integer> STACK_UPGRADE_AUTO_RETRY_CHECK_INTERVAL_SECS = new ConfigurationProperty<Integer>("stack.upgrade.auto.retry.check.interval.secs", 20);
    @Markdown(description="A comma-separate list of upgrade tasks names to skip when retrying failed commands automatically.")
    public static final ConfigurationProperty<String> STACK_UPGRADE_AUTO_RETRY_CUSTOM_COMMAND_NAMES_TO_IGNORE = new ConfigurationProperty<String>("stack.upgrade.auto.retry.command.names.to.ignore", "\"ComponentVersionCheckAction\",\"FinalizeUpgradeAction\"");
    @Markdown(description="A comma-separate list of upgrade tasks details to skip when retrying failed commands automatically.")
    public static final ConfigurationProperty<String> STACK_UPGRADE_AUTO_RETRY_COMMAND_DETAILS_TO_IGNORE = new ConfigurationProperty<String>("stack.upgrade.auto.retry.command.details.to.ignore", "\"Execute HDFS Finalize\"");
    @Markdown(description="Determines whether to use Kerberos (SPNEGO) authentication when connecting OBDP.")
    public static final ConfigurationProperty<Boolean> KERBEROS_AUTH_ENABLED = new ConfigurationProperty<Boolean>("authentication.kerberos.enabled", Boolean.FALSE);
    @Markdown(description="The Kerberos principal name to use when verifying user-supplied Kerberos tokens for authentication via SPNEGO")
    public static final ConfigurationProperty<String> KERBEROS_AUTH_SPNEGO_PRINCIPAL = new ConfigurationProperty<String>("authentication.kerberos.spnego.principal", "HTTP/_HOST");
    @Markdown(description="The Kerberos keytab file to use when verifying user-supplied Kerberos tokens for authentication via SPNEGO")
    public static final ConfigurationProperty<String> KERBEROS_AUTH_SPNEGO_KEYTAB_FILE = new ConfigurationProperty<String>("authentication.kerberos.spnego.keytab.file", "/etc/security/keytabs/spnego.service.keytab");
    @Markdown(description="The auth-to-local rules set to use when translating a user's principal name to a local user name during authentication via SPNEGO.")
    public static final ConfigurationProperty<String> KERBEROS_AUTH_AUTH_TO_LOCAL_RULES = new ConfigurationProperty<String>("authentication.kerberos.auth_to_local.rules", "DEFAULT");
    @Markdown(description="The number of times failed Kerberos operations should be retried to execute.")
    public static final ConfigurationProperty<Integer> KERBEROS_OPERATION_RETRIES = new ConfigurationProperty<Integer>("kerberos.operation.retries", 3);
    @Markdown(description="The time to wait (in seconds) between failed Kerberos operations retries.")
    public static final ConfigurationProperty<Integer> KERBEROS_OPERATION_RETRY_TIMEOUT = new ConfigurationProperty<Integer>("kerberos.operation.retry.timeout", 10);
    @Markdown(description="Validate the trust of the SSL certificate provided by the KDC when performing Kerberos operations over SSL.")
    public static final ConfigurationProperty<Boolean> KERBEROS_OPERATION_VERIFY_KDC_TRUST = new ConfigurationProperty<Boolean>("kerberos.operation.verify.kdc.trust", Boolean.TRUE);
    @Markdown(examples={"internal", "c3p0"}, description="The connection pool manager to use for database connections. If using MySQL, then `c3p0` is automatically chosen.")
    public static final ConfigurationProperty<String> SERVER_JDBC_CONNECTION_POOL = new ConfigurationProperty<String>("server.jdbc.connection-pool", ConnectionPoolType.INTERNAL.getName());
    @Markdown(relatedTo="server.jdbc.connection-pool", description="The minimum number of connections that should always exist in the database connection pool. Only used with c3p0.")
    public static final ConfigurationProperty<Integer> SERVER_JDBC_CONNECTION_POOL_MIN_SIZE = new ConfigurationProperty<Integer>("server.jdbc.connection-pool.min-size", 5);
    @Markdown(relatedTo="server.jdbc.connection-pool", description="The maximum number of connections that should exist in the database connection pool. Only used with c3p0.")
    public static final ConfigurationProperty<Integer> SERVER_JDBC_CONNECTION_POOL_MAX_SIZE = new ConfigurationProperty<Integer>("server.jdbc.connection-pool.max-size", 32);
    @Markdown(relatedTo="server.jdbc.connection-pool", description="The number of connections that should be retrieved when the pool size must increase. This should be set higher than 1 since the assumption is that a pool that needs to grow should probably grow by more than 1. Only used with c3p0.")
    public static final ConfigurationProperty<Integer> SERVER_JDBC_CONNECTION_POOL_AQUISITION_SIZE = new ConfigurationProperty<Integer>("server.jdbc.connection-pool.acquisition-size", 5);
    @Markdown(relatedTo="server.jdbc.connection-pool", description=" The maximum amount of time, in seconds, any connection, whether its been idle or active, should remain in the pool. This will terminate the connection after the expiration age and force new connections to be opened. Only used with c3p0.")
    public static final ConfigurationProperty<Integer> SERVER_JDBC_CONNECTION_POOL_MAX_AGE = new ConfigurationProperty<Integer>("server.jdbc.connection-pool.max-age", 0);
    @Markdown(relatedTo="server.jdbc.connection-pool", description="The maximum amount of time, in seconds, that an idle connection can remain in the pool. This should always be greater than the value returned from `server.jdbc.connection-pool.max-idle-time-excess`. Only used with c3p0.")
    public static final ConfigurationProperty<Integer> SERVER_JDBC_CONNECTION_POOL_MAX_IDLE_TIME = new ConfigurationProperty<Integer>("server.jdbc.connection-pool.max-idle-time", 14400);
    @Markdown(relatedTo="server.jdbc.connection-pool", description="The maximum amount of time, in seconds, that connections beyond the minimum pool size should remain in the pool. This should always be less than than the value returned from `server.jdbc.connection-pool.max-idle-time`. Only used with c3p0.")
    public static final ConfigurationProperty<Integer> SERVER_JDBC_CONNECTION_POOL_MAX_IDLE_TIME_EXCESS = new ConfigurationProperty<Integer>("server.jdbc.connection-pool.max-idle-time-excess", 0);
    @Markdown(relatedTo="server.jdbc.connection-pool", description="The number of seconds in between testing each idle connection in the connection pool for validity. Only used with c3p0.")
    public static final ConfigurationProperty<Integer> SERVER_JDBC_CONNECTION_POOL_IDLE_TEST_INTERVAL = new ConfigurationProperty<Integer>("server.jdbc.connection-pool.idle-test-interval", 7200);
    @Markdown(relatedTo="server.jdbc.connection-pool", description="The number of times connections should be retried to be acquired from the database before giving up. Only used with c3p0.")
    public static final ConfigurationProperty<Integer> SERVER_JDBC_CONNECTION_POOL_ACQUISITION_RETRY_ATTEMPTS = new ConfigurationProperty<Integer>("server.jdbc.connection-pool.acquisition-retry-attempts", 30);
    @Markdown(relatedTo="server.jdbc.connection-pool", description="The delay, in milliseconds, between connection acquisition attempts. Only used with c3p0.")
    public static final ConfigurationProperty<Integer> SERVER_JDBC_CONNECTION_POOL_ACQUISITION_RETRY_DELAY = new ConfigurationProperty<Integer>("server.jdbc.connection-pool.acquisition-retry-delay", 1000);
    @Markdown(description="The number of retry attempts for failed API and blueprint operations.")
    public static final ConfigurationProperty<Integer> OPERATIONS_RETRY_ATTEMPTS = new ConfigurationProperty<Integer>("server.operations.retry-attempts", 0);
    @Deprecated
    @Markdown(description="The user name for connecting to the database which stores RCA information.")
    public static final ConfigurationProperty<String> SERVER_JDBC_RCA_USER_NAME = new ConfigurationProperty<String>("server.jdbc.rca.user.name", "mapred");
    @Deprecated
    @Markdown(description="The password for the user when connecting to the database which stores RCA information.")
    public static final ConfigurationProperty<String> SERVER_JDBC_RCA_USER_PASSWD = new ConfigurationProperty<String>("server.jdbc.rca.user.passwd", "mapred");
    @Deprecated
    @Markdown(description="The PostgresSQL driver name for the RCA database.")
    public static final ConfigurationProperty<String> SERVER_JDBC_RCA_DRIVER = new ConfigurationProperty<String>("server.jdbc.rca.driver", "org.postgresql.Driver");
    @Deprecated
    @Markdown(description="The full JDBC URL for connecting to the RCA database.")
    public static final ConfigurationProperty<String> SERVER_JDBC_RCA_URL = new ConfigurationProperty<String>("server.jdbc.rca.url", "jdbc:postgresql://{hostname}/ambarirca");
    @Markdown(description="The table generation strategy to use when initializing JPA.")
    public static final ConfigurationProperty<JPATableGenerationStrategy> SERVER_JDBC_GENERATE_TABLES = new ConfigurationProperty<JPATableGenerationStrategy>("server.jdbc.generateTables", JPATableGenerationStrategy.NONE);
    @Markdown(examples={"redhat", "ubuntu"}, description="The operating system family for all hosts in the cluster. This is used when bootstrapping agents and when enabling Kerberos.")
    public static final ConfigurationProperty<String> OS_FAMILY = new ConfigurationProperty<String>("server.os_family", "");
    @Markdown(examples={"6", "7"}, description="The operating system version for all hosts in the cluster. This is used when bootstrapping agents and when enabling Kerberos.")
    public static final ConfigurationProperty<String> OS_VERSION = new ConfigurationProperty<String>("server.os_type", "");
    @Markdown(description="The location on the OBDP Server of the file which is used for mapping host names.")
    public static final ConfigurationProperty<String> SRVR_HOSTS_MAPPING = new ConfigurationProperty<Object>("server.hosts.mapping", null);
    @Markdown(description="The location of the truststore to use when setting the `javax.net.ssl.trustStore` property.")
    public static final ConfigurationProperty<String> SSL_TRUSTSTORE_PATH = new ConfigurationProperty<Object>("ssl.trustStore.path", null);
    @Markdown(description="The password to use when setting the `javax.net.ssl.trustStorePassword` property")
    public static final ConfigurationProperty<String> SSL_TRUSTSTORE_PASSWORD = new ConfigurationProperty<Object>("ssl.trustStore.password", null);
    @Markdown(description="The type of truststore used by the `javax.net.ssl.trustStoreType` property.")
    public static final ConfigurationProperty<String> SSL_TRUSTSTORE_TYPE = new ConfigurationProperty<Object>("ssl.trustStore.type", null);
    @Markdown(description="The location on the OBDP Server of the master key file. This is the key to the master keystore.")
    public static final ConfigurationProperty<String> MASTER_KEY_LOCATION = new ConfigurationProperty<Object>("security.master.key.location", null);
    @Markdown(description="The location on the OBDP Server of the master keystore file.")
    public static final ConfigurationProperty<String> MASTER_KEYSTORE_LOCATION = new ConfigurationProperty<Object>("security.master.keystore.location", null);
    @Markdown(description="The time, in minutes, that the temporary, in-memory credential store retains values.")
    public static final ConfigurationProperty<Long> TEMPORARYSTORE_RETENTION_MINUTES = new ConfigurationProperty<Long>("security.temporary.keystore.retention.minutes", 90L);
    @Markdown(description="Determines whether the temporary keystore should have keys actively purged on a fixed internal. or only when requested after expiration.")
    public static final ConfigurationProperty<Boolean> TEMPORARYSTORE_ACTIVELY_PURGE = new ConfigurationProperty<Boolean>("security.temporary.keystore.actibely.purge", Boolean.TRUE);
    @Markdown(examples={"http://obdp-server-address:8080"}, description="The URL to use when creating messages which should include the OBDP Server URL.")
    public static final ConfigurationProperty<String> AMBARI_DISPLAY_URL = new ConfigurationProperty<Object>("ambari.display.url", null);
    @Markdown(description="The suffixes to use when validating Ubuntu repositories.")
    public static final ConfigurationProperty<String> REPO_SUFFIX_KEY_UBUNTU = new ConfigurationProperty<String>("repo.validation.suffixes.ubuntu", "/dists/%s/Release");
    @Markdown(description="The suffixes to use when validating most types of repositories.")
    public static final ConfigurationProperty<String> REPO_SUFFIX_KEY_DEFAULT = new ConfigurationProperty<String>("repo.validation.suffixes.default", "/repodata/repomd.xml");
    @Markdown(description="Determines whether Quartz will use a clustered job scheduled when performing scheduled actions like rolling restarts.")
    public static final ConfigurationProperty<String> EXECUTION_SCHEDULER_CLUSTERED = new ConfigurationProperty<String>("server.execution.scheduler.isClustered", "false");
    @Markdown(description="The number of threads that the Quartz job scheduler will use when executing scheduled jobs.")
    public static final ConfigurationProperty<String> EXECUTION_SCHEDULER_THREADS = new ConfigurationProperty<String>("server.execution.scheduler.maxThreads", "5");
    @Markdown(description="The number of concurrent database connections that the Quartz job scheduler can use.")
    public static final ConfigurationProperty<String> EXECUTION_SCHEDULER_CONNECTIONS = new ConfigurationProperty<String>("server.execution.scheduler.maxDbConnections", "5");
    @Markdown(description="The maximum number of prepared statements cached per database connection.")
    public static final ConfigurationProperty<String> EXECUTION_SCHEDULER_MAX_STATEMENTS_PER_CONNECTION = new ConfigurationProperty<String>("server.execution.scheduler.maxStatementsPerConnection", "120");
    @Markdown(description="The time, in minutes, that a scheduled job can be run after its missed scheduled execution time.")
    public static final ConfigurationProperty<Long> EXECUTION_SCHEDULER_MISFIRE_TOLERATION = new ConfigurationProperty<Long>("server.execution.scheduler.misfire.toleration.minutes", 480L);
    @Markdown(description="The delay, in seconds, that a Quartz job must wait before it starts.")
    public static final ConfigurationProperty<Integer> EXECUTION_SCHEDULER_START_DELAY = new ConfigurationProperty<Integer>("server.execution.scheduler.start.delay.seconds", 120);
    @Markdown(description="The time, in seconds, that the Quartz execution scheduler will wait before checking for new commands to schedule, such as rolling restarts.")
    public static final ConfigurationProperty<Long> EXECUTION_SCHEDULER_WAIT = new ConfigurationProperty<Long>("server.execution.scheduler.wait", 1L);
    @Markdown(description="The location on the OBDP Server where temporary artifacts can be created.")
    public static final ConfigurationProperty<String> SERVER_TMP_DIR = new ConfigurationProperty<String>("server.tmp.dir", AmbariPath.getPath("/var/lib/obdp-server/tmp"));
    @Markdown(description="The location on the OBDP Server where request logs can be created.")
    public static final ConfigurationProperty<String> REQUEST_LOGPATH = new ConfigurationProperty<Object>("server.requestlogs.path", null);
    @Markdown(description="The pattern of request log file name")
    public static final ConfigurationProperty<String> REQUEST_LOGNAMEPATTERN = new ConfigurationProperty<String>("server.requestlogs.namepattern", "obdp-access-yyyy_mm_dd.log");
    @Markdown(description="The number of days that request log would be retained.")
    public static final ConfigurationProperty<Integer> REQUEST_LOG_RETAINDAYS = new ConfigurationProperty<Integer>("server.requestlogs.retaindays", 15);
    @Markdown(description="The time, in milliseconds, until an external script is killed.")
    public static final ConfigurationProperty<Integer> EXTERNAL_SCRIPT_TIMEOUT = new ConfigurationProperty<Integer>("server.script.timeout", 10000);
    @Markdown(description="The number of threads that should be allocated to run external script.")
    public static final ConfigurationProperty<Integer> THREAD_POOL_SIZE_FOR_EXTERNAL_SCRIPT = new ConfigurationProperty<Integer>("server.script.threads", 20);
    public static final String DEF_ARCHIVE_EXTENSION;
    public static final String DEF_ARCHIVE_CONTENT_TYPE;
    @Markdown(description="The port used to communicate with the Kerberos Key Distribution Center.")
    public static final ConfigurationProperty<String> KDC_PORT;
    @Markdown(description="The timeout, in milliseconds, to wait when communicating with a Kerberos Key Distribution Center.")
    public static final ConfigurationProperty<Integer> KDC_CONNECTION_CHECK_TIMEOUT;
    @Markdown(description="The location on the OBDP Server where Kerberos keytabs are cached.")
    public static final ConfigurationProperty<String> KERBEROSTAB_CACHE_DIR;
    @Markdown(description="Determines whether Kerberos-enabled OBDP deployments should use JAAS to validate login credentials.")
    public static final ConfigurationProperty<Boolean> KERBEROS_CHECK_JAAS_CONFIGURATION;
    @Markdown(examples={"DEFAULT", "AUTO_START", "FULL"}, description="The type of automatic recovery of failed services and components to use.")
    public static final ConfigurationProperty<String> RECOVERY_TYPE;
    @Markdown(description="The maximum number of recovery attempts of a failed component during the lifetime of an OBDP Agent instance. This is reset when the OBDP Agent is restarted.")
    public static final ConfigurationProperty<String> RECOVERY_LIFETIME_MAX_COUNT;
    @Markdown(description="The maximum number of recovery attempts of a failed component during a specified recovery window.")
    public static final ConfigurationProperty<String> RECOVERY_MAX_COUNT;
    @Markdown(relatedTo="recovery.max_count", description="The length of a recovery window, in minutes, in which recovery attempts can be retried.")
    public static final ConfigurationProperty<String> RECOVERY_WINDOW_IN_MIN;
    @Markdown(description="The delay, in minutes, between automatic retry windows.")
    public static final ConfigurationProperty<String> RECOVERY_RETRY_GAP;
    @Markdown(examples={"NAMENODE,ZOOKEEPER_SERVER"}, description="A comma-separated list of component names which are not included in automatic recovery attempts.")
    public static final ConfigurationProperty<String> RECOVERY_DISABLED_COMPONENTS;
    @Markdown(examples={"NAMENODE,ZOOKEEPER_SERVER"}, description="A comma-separated list of component names which are included in automatic recovery attempts.")
    public static final ConfigurationProperty<String> RECOVERY_ENABLED_COMPONENTS;
    @Markdown(description="A comma-separated whitelist of host and port values which OBDP Server can use to determine if a proxy value is valid.")
    public static final ConfigurationProperty<String> PROXY_ALLOWED_HOST_PORTS;
    @Markdown(description="Determines whether operations in different execution requests can be run concurrently.")
    public static final ConfigurationProperty<Boolean> PARALLEL_STAGE_EXECUTION;
    @Markdown(description="Drives view extraction in case of blueprint deployments; non-system views are deployed when cluster configuration is successful")
    public static final ConfigurationProperty<Boolean> VIEW_EXTRACT_AFTER_CLUSTER_CONFIG;
    @Markdown(description="How to execute commands in one stage")
    public static final ConfigurationProperty<String> COMMAND_EXECUTION_TYPE;
    @Markdown(description="The time, in seconds, before agent commands are killed. This does not include package installation commands.")
    public static final ConfigurationProperty<Long> AGENT_TASK_TIMEOUT;
    @Markdown(description="The time, in seconds, before agent service check commands are killed.")
    public static final ConfigurationProperty<Long> AGENT_SERVICE_CHECK_TASK_TIMEOUT;
    @Markdown(description="The time, in seconds, before package installation commands are killed.")
    public static final ConfigurationProperty<Long> AGENT_PACKAGE_INSTALL_TASK_TIMEOUT;
    @Markdown(description="The maximum number of tasks which can run within a single operational request. If there are more tasks, then they will be broken up between multiple operations.")
    public static final ConfigurationProperty<Integer> AGENT_PACKAGE_PARALLEL_COMMANDS_LIMIT;
    @Markdown(description="The time, in seconds, before a server-side operation is terminated.")
    public static final ConfigurationProperty<Integer> SERVER_TASK_TIMEOUT;
    @Markdown(description="A location of hooks folder relative to resources folder.")
    public static final ConfigurationProperty<String> HOOKS_FOLDER;
    @Markdown(description="The location on the OBDP Server where custom actions are defined.")
    public static final ConfigurationProperty<String> CUSTOM_ACTION_DEFINITION;
    @Markdown(description="The location on the OBDP Server where resources are stored. This is exposed via HTTP in order for OBDP Agents to access them.")
    public static final ConfigurationProperty<String> SHARED_RESOURCES_DIR;
    @Markdown(description="The name of the user given to requests which are executed without any credentials.")
    public static final ConfigurationProperty<String> ANONYMOUS_AUDIT_NAME;
    @Markdown(description="Determines whether OBDP Agent instances have already have the necessary stack software installed")
    public static final ConfigurationProperty<String> SYS_PREPPED_HOSTS;
    @Markdown(description="This property is used in specific testing circumstances only. Its use otherwise will lead to very unpredictable results with repository management and package installation")
    public static final ConfigurationProperty<String> LEGACY_OVERRIDE;
    @Markdown(description="The time, in milliseconds, that OBDP Agent connections can remain open and idle.")
    public static final ConfigurationProperty<Integer> SERVER_CONNECTION_MAX_IDLE_TIME;
    @ConfigurationMarkdown(group=ConfigurationGrouping.JETTY_THREAD_POOL, scaleValues={@ClusterScale(clusterSize=ClusterSizeType.HOSTS_10, value="25"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_50, value="35"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_100, value="50"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_500, value="65")}, markdown=@Markdown(description="The size of the Jetty connection pool used for handling incoming REST API requests. This should be large enough to handle requests from both web browsers and embedded Views."))
    public static final ConfigurationProperty<Integer> CLIENT_THREADPOOL_SIZE;
    @ConfigurationMarkdown(group=ConfigurationGrouping.JETTY_THREAD_POOL, scaleValues={@ClusterScale(clusterSize=ClusterSizeType.HOSTS_10, value="25"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_50, value="35"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_100, value="75"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_500, value="100")}, markdown=@Markdown(description="The size of the Jetty connection pool used for handling incoming OBDP Agent requests."))
    public static final ConfigurationProperty<Integer> AGENT_THREADPOOL_SIZE;
    @Markdown(description="Thread pool size for spring messaging")
    public static final ConfigurationProperty<Integer> MESSAGING_THREAD_POOL_SIZE;
    @Markdown(description="Thread pool size for agents registration")
    public static final ConfigurationProperty<Integer> REGISTRATION_THREAD_POOL_SIZE;
    @Markdown(description="Maximal cache size for spring subscription registry.")
    public static final ConfigurationProperty<Integer> SUBSCRIPTION_REGISTRY_CACHE_MAX_SIZE;
    @Markdown(description="Queue size for agents in registration.")
    public static final ConfigurationProperty<Integer> AGENTS_REGISTRATION_QUEUE_SIZE;
    @Markdown(description="Period in seconds with agents reports will be processed.")
    public static final ConfigurationProperty<Integer> AGENTS_REPORT_PROCESSING_PERIOD;
    @Markdown(description="Timeout in seconds before start processing of agents' reports.")
    public static final ConfigurationProperty<Integer> AGENTS_REPORT_PROCESSING_START_TIMEOUT;
    @Markdown(description="Thread pool size for agents reports processing.")
    public static final ConfigurationProperty<Integer> AGENTS_REPORT_THREAD_POOL_SIZE;
    @Markdown(description="Server to API STOMP endpoint heartbeat interval in milliseconds.")
    public static final ConfigurationProperty<Integer> API_HEARTBEAT_INTERVAL;
    @Markdown(description="The maximum size of an incoming stomp text message. Default is 2 MB.")
    public static final ConfigurationProperty<Integer> STOMP_MAX_INCOMING_MESSAGE_SIZE;
    @Markdown(description="The maximum size of a buffer for stomp message sending. Default is 5 MB.")
    public static final ConfigurationProperty<Integer> STOMP_MAX_BUFFER_MESSAGE_SIZE;
    @Markdown(description="The number of attempts to emit execution command message to agent. Default is 4")
    public static final ConfigurationProperty<Integer> EXECUTION_COMMANDS_RETRY_COUNT;
    @Markdown(description="The interval in seconds between attempts to emit execution command message to agent. Default is 15")
    public static final ConfigurationProperty<Integer> EXECUTION_COMMANDS_RETRY_INTERVAL;
    @Markdown(description="The maximum number of threads used to extract OBDP Views when OBDP Server is starting up.")
    public static final ConfigurationProperty<Integer> VIEW_EXTRACTION_THREADPOOL_MAX_SIZE;
    @Markdown(description="The number of threads used to extract Ambari Views when Ambari Server is starting up.")
    public static final ConfigurationProperty<Integer> VIEW_EXTRACTION_THREADPOOL_CORE_SIZE;
    @Markdown(description="The time, in milliseconds, that non-core threads will live when extraction views on OBDP Server startup.")
    public static final ConfigurationProperty<Long> VIEW_EXTRACTION_THREADPOOL_TIMEOUT;
    @Markdown(relatedTo="agent.threadpool.size.max", description="The maximum number of threads which will be allocated to handling REST API requests from embedded views. This value should be smaller than `agent.threadpool.size.max`")
    public static final ConfigurationProperty<Integer> VIEW_REQUEST_THREADPOOL_MAX_SIZE;
    @Markdown(description="The time, milliseconds, that REST API requests from embedded views can wait if there are no threads available to service the view's request. Setting this too low can cause views to timeout.")
    public static final ConfigurationProperty<Integer> VIEW_REQUEST_THREADPOOL_TIMEOUT;
    @Markdown(description="The maximum number of threads that will be used to retrieve data from federated datasources, such as remote JMX endpoints.")
    public static final ConfigurationProperty<Integer> PROPERTY_PROVIDER_THREADPOOL_MAX_SIZE;
    @Markdown(description="The core number of threads that will be used to retrieve data from federated datasources, such as remote JMX endpoints.")
    public static final ConfigurationProperty<Integer> PROPERTY_PROVIDER_THREADPOOL_CORE_SIZE;
    @Markdown(description="The maximum size of pending federated datasource requests, such as those to JMX endpoints, which can be queued before rejecting new requests.")
    public static final ConfigurationProperty<Integer> PROPERTY_PROVIDER_THREADPOOL_WORKER_QUEUE_SIZE;
    @Markdown(description="The maximum time, in milliseconds, that federated requests for data can execute before being terminated. Increasing this value could result in degraded performanc from the REST APIs.")
    public static final ConfigurationProperty<Long> PROPERTY_PROVIDER_THREADPOOL_COMPLETION_TIMEOUT;
    @Markdown(description="The time, in seconds, that open HTTP sessions will remain valid while they are inactive.")
    public static final ConfigurationProperty<Integer> SERVER_HTTP_SESSION_INACTIVE_TIMEOUT;
    @Markdown(description="Determines whether OBDP Metric data is cached.")
    public static final ConfigurationProperty<Boolean> TIMELINE_METRICS_CACHE_DISABLE;
    @Markdown(relatedTo="server.timeline.metrics.cache.disabled", description="The time, in seconds, that OBDP Metric timeline data is cached by OBDP Server.")
    public static final ConfigurationProperty<Integer> TIMELINE_METRICS_CACHE_TTL;
    @Markdown(relatedTo="server.timeline.metrics.cache.disabled", description="The time, in seconds, that OBDP Metric data can remain in the cache without being accessed.")
    public static final ConfigurationProperty<Integer> TIMELINE_METRICS_CACHE_IDLE_TIME;
    @Markdown(relatedTo="server.timeline.metrics.cache.disabled", description="cache size, in entries, that OBDP metrics cache will hold.")
    public static final ConfigurationProperty<Integer> TIMELINE_METRICS_CACHE_ENTRY_UNIT_SIZE;
    @Markdown(relatedTo="server.timeline.metrics.cache.disabled", description="The time, in milliseconds, that initial requests to populate metric data will wait while reading from OBDP Metrics.")
    public static final ConfigurationProperty<Integer> TIMELINE_METRICS_REQUEST_READ_TIMEOUT;
    @Markdown(relatedTo="server.timeline.metrics.cache.disabled", description="The time, in milliseconds, that requests to update stale metric data will wait while reading from OBDP Metrics. This allows for greater control by allowing stale values to be returned instead of waiting for OBDP Metrics to always populate responses with the latest data.")
    public static final ConfigurationProperty<Integer> TIMELINE_METRICS_REQUEST_INTERVAL_READ_TIMEOUT;
    @Markdown(relatedTo="server.timeline.metrics.cache.disabled", description="The time, in milliseconds, to wait while attempting to connect to OBDP Metrics.")
    public static final ConfigurationProperty<Integer> TIMELINE_METRICS_REQUEST_CONNECT_TIMEOUT;
    @Markdown(relatedTo="server.timeline.metrics.cache.disabled", description="The time, in milliseconds, that OBDP Metrics intervals should use when extending the boundaries of the original request.")
    public static final ConfigurationProperty<Long> TIMELINE_METRICS_REQUEST_CATCHUP_INTERVAL;
    @Markdown(relatedTo="server.timeline.metrics.cache.disabled", description="The amount of heap on the OBDP Server dedicated to the caching values from OBDP Metrics. Measured as part of the total heap of OBDP Server.")
    public static final ConfigurationProperty<String> TIMELINE_METRICS_CACHE_HEAP_PERCENT;
    @Markdown(relatedTo="server.timeline.metrics.cache.disabled", description="Determines if a custom engine should be used to increase performance of calculating the current size of the cache for OBDP Metric data.")
    public static final ConfigurationProperty<Boolean> TIMELINE_METRICS_CACHE_USE_CUSTOM_SIZING_ENGINE;
    @Markdown(description="Determines whether to use to SSL to connect to OBDP Metrics when retrieving metric data.")
    public static final ConfigurationProperty<Boolean> AMBARI_METRICS_HTTPS_ENABLED;
    @Markdown(description="The full path to the XML file that describes the different alert templates.")
    public static final ConfigurationProperty<String> ALERT_TEMPLATE_FILE;
    @ConfigurationMarkdown(group=ConfigurationGrouping.ALERTS, scaleValues={@ClusterScale(clusterSize=ClusterSizeType.HOSTS_10, value="2"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_50, value="2"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_100, value="4"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_500, value="4")}, markdown=@Markdown(description="The core number of threads used to process incoming alert events. The value should be increased as the size of the cluster increases."))
    public static final ConfigurationProperty<Integer> ALERTS_EXECUTION_SCHEDULER_THREADS_CORE_SIZE;
    @ConfigurationMarkdown(group=ConfigurationGrouping.ALERTS, scaleValues={@ClusterScale(clusterSize=ClusterSizeType.HOSTS_10, value="2"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_50, value="2"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_100, value="8"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_500, value="8")}, markdown=@Markdown(description="The number of threads used to handle alerts received from the OBDP Agents. The value should be increased as the size of the cluster increases."))
    public static final ConfigurationProperty<Integer> ALERTS_EXECUTION_SCHEDULER_THREADS_MAX_SIZE;
    @ConfigurationMarkdown(group=ConfigurationGrouping.ALERTS, scaleValues={@ClusterScale(clusterSize=ClusterSizeType.HOSTS_10, value="400"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_50, value="2000"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_100, value="4000"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_500, value="20000")}, markdown=@Markdown(description="The number of queued alerts allowed before discarding old alerts which have not been handled. The value should be increased as the size of the cluster increases."))
    public static final ConfigurationProperty<Integer> ALERTS_EXECUTION_SCHEDULER_WORKER_QUEUE_SIZE;
    @ConfigurationMarkdown(group=ConfigurationGrouping.ALERTS, scaleValues={@ClusterScale(clusterSize=ClusterSizeType.HOSTS_10, value="false"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_50, value="false"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_100, value="false"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_500, value="true")}, markdown=@Markdown(description="Determines whether current alerts should be cached. Enabling this can increase performance on large cluster, but can also result in lost alert data if the cache is not flushed frequently."))
    public static final ConfigurationProperty<Boolean> ALERTS_CACHE_ENABLED;
    @ConfigurationMarkdown(group=ConfigurationGrouping.ALERTS, scaleValues={@ClusterScale(clusterSize=ClusterSizeType.HOSTS_10, value="10"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_50, value="10"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_100, value="10"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_500, value="10")}, markdown=@Markdown(relatedTo="alerts.cache.enabled", description="The time, in minutes, after which cached alert information is flushed to the database"))
    public static final ConfigurationProperty<Integer> ALERTS_CACHE_FLUSH_INTERVAL;
    @ConfigurationMarkdown(group=ConfigurationGrouping.ALERTS, scaleValues={@ClusterScale(clusterSize=ClusterSizeType.HOSTS_10, value="50000"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_50, value="50000"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_100, value="100000"), @ClusterScale(clusterSize=ClusterSizeType.HOSTS_500, value="100000")}, markdown=@Markdown(relatedTo="alerts.cache.enabled", description="The size of the alert cache."))
    public static final ConfigurationProperty<Integer> ALERTS_CACHE_SIZE;
    @Markdown(description="When using SSL, this will be used to set the `Strict-Transport-Security` response header.")
    public static final ConfigurationProperty<String> HTTP_STRICT_TRANSPORT_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `X-Frame-Options` HTTP response header.")
    public static final ConfigurationProperty<String> HTTP_X_FRAME_OPTIONS_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `X-XSS-Protection` HTTP response header.")
    public static final ConfigurationProperty<String> HTTP_X_XSS_PROTECTION_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `Content-Security-Policy` HTTP response header.")
    public static final ConfigurationProperty<String> HTTP_CONTENT_SECURITY_POLICY_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `X-CONTENT-TYPE` HTTP response header.")
    public static final ConfigurationProperty<String> HTTP_X_CONTENT_TYPE_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `Cache-Control` HTTP response header.")
    public static final ConfigurationProperty<String> HTTP_CACHE_CONTROL_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `PRAGMA` HTTP response header.")
    public static final ConfigurationProperty<String> HTTP_PRAGMA_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the Character encoding to HTTP response header.")
    public static final ConfigurationProperty<String> HTTP_CHARSET;
    @Markdown(description="The value that will be used to set the `Strict-Transport-Security` HTTP response header for OBDP View requests.")
    public static final ConfigurationProperty<String> VIEWS_HTTP_STRICT_TRANSPORT_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `X-Frame-Options` HTTP response header for Ambari View requests.")
    public static final ConfigurationProperty<String> VIEWS_HTTP_X_FRAME_OPTIONS_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `X-XSS-Protection` HTTP response header for OBDP View requests.")
    public static final ConfigurationProperty<String> VIEWS_HTTP_X_XSS_PROTECTION_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `Content-Security-Policy` HTTP response header for OBDP View requests.")
    public static final ConfigurationProperty<String> VIEWS_HTTP_CONTENT_SECURITY_POLICY_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `X-CONTENT-TYPE` HTTP response header for OBDP View requests.")
    public static final ConfigurationProperty<String> VIEWS_HTTP_X_CONTENT_TYPE_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the `Cache-Control` HTTP response header for OBDP View requests.")
    public static final ConfigurationProperty<String> VIEWS_HTTP_CACHE_CONTROL_HEADER_VALUE;
    @Markdown(description="Additional class path added to each OBDP View. Comma separated jars or directories")
    public static final ConfigurationProperty<String> VIEWS_ADDITIONAL_CLASSPATH_VALUE;
    @Markdown(description="The value that will be used to set the `PRAGMA` HTTP response header for OBDP View requests.")
    public static final ConfigurationProperty<String> VIEWS_HTTP_PRAGMA_HEADER_VALUE;
    @Markdown(description="The value that will be used to set the Character encoding to HTTP response header for OBDP View requests.")
    public static final ConfigurationProperty<String> VIEWS_HTTP_CHARSET;
    @Markdown(description="The time, in milliseconds, that requests to connect to a URL to retrieve Version Definition Files (VDF) will wait before being terminated.")
    public static final ConfigurationProperty<Integer> VERSION_DEFINITION_CONNECT_TIMEOUT;
    @Markdown(description="The time, in milliseconds, that requests to read from a connected URL to retrieve Version Definition Files (VDF) will wait before being terminated.")
    public static final ConfigurationProperty<Integer> VERSION_DEFINITION_READ_TIMEOUT;
    @Markdown(description="Determines whether agents should retrying installation commands when the repository is not available. This can prevent false installation errors with repositories that are sporadically inaccessible.")
    public static final ConfigurationProperty<Boolean> AGENT_STACK_RETRY_ON_REPO_UNAVAILABILITY;
    @Markdown(relatedTo="agent.stack.retry.on_repo_unavailability", description="The number of times an OBDP Agent should retry package installation when it fails due to a repository error. ")
    public static final ConfigurationProperty<Integer> AGENT_STACK_RETRY_COUNT;
    @Markdown(description="Determines whether audit logging is enabled.")
    public static final ConfigurationProperty<Boolean> AUDIT_LOG_ENABLED;
    @Markdown(relatedTo="auditlog.enabled", description="The size of the worker queue for audit logger events.")
    public static final ConfigurationProperty<Integer> AUDIT_LOGGER_CAPACITY;
    @Markdown(description="The UDP port to use when binding the SNMP dispatcher on OBDP Server startup. If no port is specified, then a random port will be used.")
    public static final ConfigurationProperty<String> ALERTS_SNMP_DISPATCH_UDP_PORT;
    @Markdown(description="The UDP port to use when binding the OBDP SNMP dispatcher on OBDP Server startup. If no port is specified, then a random port will be used.")
    public static final ConfigurationProperty<String> ALERTS_AMBARI_SNMP_DISPATCH_UDP_PORT;
    @Markdown(description="The amount of time, in minutes, that JMX and REST metrics retrieved directly can remain in the cache.")
    public static final ConfigurationProperty<Integer> METRIC_RETRIEVAL_SERVICE_CACHE_TIMEOUT;
    @Markdown(description="The priority of threads used by the service which retrieves JMX and REST metrics directly from their respective endpoints.")
    public static final ConfigurationProperty<Integer> METRIC_RETRIEVAL_SERVICE_THREAD_PRIORITY;
    @Markdown(description="The maximum number of threads used to retrieve JMX and REST metrics directly from their respective endpoints.")
    public static final ConfigurationProperty<Integer> METRIC_RETRIEVAL_SERVICE_THREADPOOL_MAX_SIZE;
    @Markdown(description="The core number of threads used to retrieve JMX and REST metrics directly from their respective endpoints.")
    public static final ConfigurationProperty<Integer> METRIC_RETRIEVAL_SERVICE_THREADPOOL_CORE_SIZE;
    @Markdown(description="The number of queued requests allowed for JMX and REST metrics before discarding old requests which have not been fullfilled.")
    public static final ConfigurationProperty<Integer> METRIC_RETRIEVAL_SERVICE_THREADPOOL_WORKER_QUEUE_SIZE;
    @Markdown(relatedTo="metrics.retrieval-service.request.ttl", description="Enables throttling requests to the same endpoint within a fixed amount of time. This property will prevent OBDP from making new metric requests to update the cache for URLs which have been recently retrieved.")
    public static final ConfigurationProperty<Boolean> METRIC_RETRIEVAL_SERVICE_REQUEST_TTL_ENABLED;
    @Markdown(relatedTo="metrics.retrieval-service.request.ttl.enabled", description="The number of seconds to wait between issuing JMX or REST metric requests to the same endpoint. This property is used to throttle requests to the same URL being made too close together")
    public static final ConfigurationProperty<Integer> METRIC_RETRIEVAL_SERVICE_REQUEST_TTL;
    @Markdown(description="Indicates whether the current obdp server instance is active or not.")
    public static final ConfigurationProperty<Boolean> ACTIVE_INSTANCE;
    @Markdown(description="Indicates whether the post user creation is enabled or not. By default is false.")
    public static final ConfigurationProperty<Boolean> POST_USER_CREATION_HOOK_ENABLED;
    @Markdown(description="The location of the post user creation hook on the obdp server hosting machine.")
    public static final ConfigurationProperty<String> POST_USER_CREATION_HOOK;
    @Markdown(description="Indicates the delay, in milliseconds, for the log4j monitor to check for changes")
    public static final ConfigurationProperty<Long> LOG4JMONITOR_DELAY;
    @Markdown(description="Indicates whether parallel topology task creation is enabled")
    public static final ConfigurationProperty<Boolean> TOPOLOGY_TASK_PARALLEL_CREATION_ENABLED;
    @Markdown(description="The number of threads to use for parallel topology task creation if enabled")
    public static final ConfigurationProperty<Integer> TOPOLOGY_TASK_PARALLEL_CREATION_THREAD_COUNT;
    @Markdown(description="Count of acceptors to configure for the jetty connector used for OBDP agent.")
    public static final ConfigurationProperty<Integer> SRVR_AGENT_ACCEPTOR_THREAD_COUNT;
    @Markdown(description="Count of acceptors to configure for the jetty connector used for OBDP API.")
    public static final ConfigurationProperty<Integer> SRVR_API_ACCEPTOR_THREAD_COUNT;
    @Markdown(description="The time, in milliseconds, that the OBDP Server will wait while attempting to connect to the LogSearch Portal service.")
    public static final ConfigurationProperty<Integer> LOGSEARCH_PORTAL_CONNECT_TIMEOUT;
    @Markdown(description="The time, in milliseconds, that the OBDP Server will wait while attempting to read a response from the LogSearch Portal service.")
    public static final ConfigurationProperty<Integer> LOGSEARCH_PORTAL_READ_TIMEOUT;
    @Markdown(description="Address of an external LogSearch Portal service. (managed outside of OBDP) Using OBDP Credential store is required for this feature (credential: 'logsearch.admin.credential')")
    public static final ConfigurationProperty<String> LOGSEARCH_PORTAL_EXTERNAL_ADDRESS;
    @Markdown(description="Global disable flag for OBDPServer Metrics.")
    public static final ConfigurationProperty<Boolean> AMBARISERVER_METRICS_DISABLE;
    @Markdown(description="The time, in hours, that the OBDP Server will hold Log File metadata in its internal cache before making a request to the LogSearch Portal to get the latest metadata.")
    public static final ConfigurationProperty<Integer> LOGSEARCH_METADATA_CACHE_EXPIRE_TIMEOUT;
    @Markdown(description="The time, in seconds, that the obdp-server Python script will wait for Jetty to startup before returning an error code.")
    public static final ConfigurationProperty<Integer> SERVER_STARTUP_WEB_TIMEOUT;
    @Markdown(description="The Ephemeral TLS Diffie-Hellman (DH) key size. Supported from Java 8.")
    public static final ConfigurationProperty<Integer> TLS_EPHEMERAL_DH_KEY_SIZE;
    @Markdown(description="The directory for scripts which are used by the alert notification dispatcher.")
    public static final ConfigurationProperty<String> DISPATCH_PROPERTY_SCRIPT_DIRECTORY;
    @Markdown(description="Whether security password encryption is enabled or not. In case it is we store passwords in their own file(s); otherwise we store passwords in the obdp credential store.")
    public static final ConfigurationProperty<Boolean> SECURITY_PASSWORD_ENCRYPTON_ENABLED;
    @Markdown(description="Whether to encrypt sensitive data (at rest) on service level configuration.")
    public static final ConfigurationProperty<Boolean> SECURITY_SENSITIVE_DATA_ENCRYPTON_ENABLED;
    @Markdown(description="The maximum number of authentication attempts permitted to a local user. Once the number of failures reaches this limit the user will be locked out. 0 indicates unlimited failures.")
    public static final ConfigurationProperty<Integer> MAX_LOCAL_AUTHENTICATION_FAILURES;
    @Markdown(description="Show or hide whether the user account is disabled or locked out, if relevant, when an authentication attempt fails.")
    public static final ConfigurationProperty<String> SHOW_LOCKED_OUT_USER_MESSAGE;
    @Markdown(description="The core pool size of the executor service that runs server side alerts.")
    public static final ConfigurationProperty<Integer> SERVER_SIDE_ALERTS_CORE_POOL_SIZE;
    @Markdown(description="Default value of max number of tasks to schedule in parallel for upgrades. Upgrade packs can override this value.")
    public static final ConfigurationProperty<Integer> DEFAULT_MAX_DEGREE_OF_PARALLELISM_FOR_UPGRADES;
    @Markdown(description="The timeout, in seconds, when finalizing Kerberos enable/disable/regenerate commands.")
    public static final ConfigurationProperty<Integer> KERBEROS_SERVER_ACTION_FINALIZE_SECONDS;
    @Markdown(description="The number of threads to use when executing server-side Kerberos commands, such as generate keytabs.")
    public static final ConfigurationProperty<Integer> KERBEROS_SERVER_ACTION_THREADPOOL_SIZE;
    @Markdown(description="The Agent command publisher pool. Affects degree of parallelization for generating the commands.")
    public static final ConfigurationProperty<Integer> AGENT_COMMAND_PUBLISHER_THREADPOOL_SIZE;
    @Markdown(description="Configures size of the default JOIN Fork pool used for Streams.")
    public static final ConfigurationProperty<Integer> DEFAULT_FORK_JOIN_THREADPOOL_SIZE;
    @Markdown(description="Show or hide the error stacks on the error page")
    public static final ConfigurationProperty<String> SERVER_SHOW_ERROR_STACKS;
    @Markdown(description="Fully qualified class name of the strategy used to form host groups for add service request layout recommendation.")
    public static final ConfigurationProperty<String> ADD_SERVICE_HOST_GROUP_STRATEGY;
    @Markdown(description="Controls whether VDF can be read from the filesystem.")
    public static final ConfigurationProperty<Boolean> VDF_FROM_FILESYSTEM;
    private static final Logger LOG;
    private Properties properties;
    private Properties log4jProperties = new Properties();
    private Set<String> propertiesToMask = null;
    private String ambariUpgradeConfigUpdatesFilePath;
    private JsonObject hostChangesJson;
    private Map<String, String> configsMap;
    private Map<String, Map<String, String>> agentConfigsMap;
    private Properties customDbProperties = null;
    private Properties customPersistenceProperties = null;
    private Long configLastModifiedDateForCustomJDBC = 0L;
    private Long configLastModifiedDateForCustomJDBCToRemove = 0L;
    private Map<String, String> databaseConnectorNames = new HashMap<String, String>();
    private Map<String, String> databasePreviousConnectorNames = new HashMap<String, String>();
    private final AmbariKerberosAuthenticationProperties kerberosAuthenticationProperties;

    public void validatePasswordPolicyRegexp() {
        String regexp = this.getPasswordPolicyRegexp();
        if (!StringUtils.isEmpty((String)regexp) && !regexp.equalsIgnoreCase(".*")) {
            Pattern.compile(regexp);
        }
    }

    public Configuration() {
        this(Configuration.readConfigFile());
    }

    public Configuration(Properties properties) {
        this.properties = properties;
        this.agentConfigsMap = new HashMap<String, Map<String, String>>();
        this.agentConfigsMap.put(AGENT_CONFIGS_DEFAULT_SECTION, new HashMap());
        Map<String, String> defaultAgentConfigsMap = this.agentConfigsMap.get(AGENT_CONFIGS_DEFAULT_SECTION);
        defaultAgentConfigsMap.put(CHECK_REMOTE_MOUNTS.getKey(), this.getProperty(CHECK_REMOTE_MOUNTS));
        defaultAgentConfigsMap.put(CHECK_MOUNTS_TIMEOUT.getKey(), this.getProperty(CHECK_MOUNTS_TIMEOUT));
        defaultAgentConfigsMap.put(ENABLE_AUTO_AGENT_CACHE_UPDATE.getKey(), this.getProperty(ENABLE_AUTO_AGENT_CACHE_UPDATE));
        defaultAgentConfigsMap.put(JAVA_HOME.getKey(), this.getProperty(JAVA_HOME));
        this.configsMap = new HashMap<String, String>();
        this.configsMap.putAll(defaultAgentConfigsMap);
        this.configsMap.put(OBDP_PYTHON_WRAP.getKey(), this.getProperty(OBDP_PYTHON_WRAP));
        this.configsMap.put(SRVR_AGENT_HOSTNAME_VALIDATE.getKey(), this.getProperty(SRVR_AGENT_HOSTNAME_VALIDATE));
        this.configsMap.put(SRVR_TWO_WAY_SSL.getKey(), this.getProperty(SRVR_TWO_WAY_SSL));
        this.configsMap.put(SRVR_TWO_WAY_SSL_PORT.getKey(), this.getProperty(SRVR_TWO_WAY_SSL_PORT));
        this.configsMap.put(SRVR_ONE_WAY_SSL_PORT.getKey(), this.getProperty(SRVR_ONE_WAY_SSL_PORT));
        this.configsMap.put(SRVR_KSTR_DIR.getKey(), this.getProperty(SRVR_KSTR_DIR));
        this.configsMap.put(SRVR_CRT_NAME.getKey(), this.getProperty(SRVR_CRT_NAME));
        this.configsMap.put(SRVR_CRT_CHAIN_NAME.getKey(), this.getProperty(SRVR_CRT_CHAIN_NAME));
        this.configsMap.put(SRVR_KEY_NAME.getKey(), this.getProperty(SRVR_KEY_NAME));
        this.configsMap.put(SRVR_CSR_NAME.getKey(), this.getProperty(SRVR_CSR_NAME));
        this.configsMap.put(KSTR_NAME.getKey(), this.getProperty(KSTR_NAME));
        this.configsMap.put(KSTR_TYPE.getKey(), this.getProperty(KSTR_TYPE));
        this.configsMap.put(TSTR_NAME.getKey(), this.getProperty(TSTR_NAME));
        this.configsMap.put(TSTR_TYPE.getKey(), this.getProperty(TSTR_TYPE));
        this.configsMap.put(SRVR_CRT_PASS_FILE.getKey(), this.getProperty(SRVR_CRT_PASS_FILE));
        this.configsMap.put(PASSPHRASE_ENV.getKey(), this.getProperty(PASSPHRASE_ENV));
        this.configsMap.put(PASSPHRASE.getKey(), System.getenv(this.configsMap.get(PASSPHRASE_ENV.getKey())));
        this.configsMap.put(RESOURCES_DIR.getKey(), this.getProperty(RESOURCES_DIR));
        this.configsMap.put(SRVR_CRT_PASS_LEN.getKey(), this.getProperty(SRVR_CRT_PASS_LEN));
        this.configsMap.put(SRVR_DISABLED_CIPHERS.getKey(), this.getProperty(SRVR_DISABLED_CIPHERS));
        this.configsMap.put(SRVR_DISABLED_PROTOCOLS.getKey(), this.getProperty(SRVR_DISABLED_PROTOCOLS));
        this.configsMap.put(CLIENT_API_SSL_KSTR_DIR_NAME.getKey(), properties.getProperty(CLIENT_API_SSL_KSTR_DIR_NAME.getKey(), this.configsMap.get(SRVR_KSTR_DIR.getKey())));
        this.configsMap.put(CLIENT_API_SSL_KSTR_NAME.getKey(), this.getProperty(CLIENT_API_SSL_KSTR_NAME));
        this.configsMap.put(CLIENT_API_SSL_KSTR_TYPE.getKey(), this.getProperty(CLIENT_API_SSL_KSTR_TYPE));
        this.configsMap.put(CLIENT_API_SSL_TSTR_NAME.getKey(), this.getProperty(CLIENT_API_SSL_TSTR_NAME));
        this.configsMap.put(CLIENT_API_SSL_TSTR_TYPE.getKey(), this.getProperty(CLIENT_API_SSL_TSTR_TYPE));
        this.configsMap.put(CLIENT_API_SSL_CRT_PASS_FILE_NAME.getKey(), this.getProperty(CLIENT_API_SSL_CRT_PASS_FILE_NAME));
        this.configsMap.put(JAVA_HOME.getKey(), this.getProperty(JAVA_HOME));
        this.configsMap.put(PARALLEL_STAGE_EXECUTION.getKey(), this.getProperty(PARALLEL_STAGE_EXECUTION));
        this.configsMap.put(SERVER_TMP_DIR.getKey(), this.getProperty(SERVER_TMP_DIR));
        this.configsMap.put(REQUEST_LOGPATH.getKey(), this.getProperty(REQUEST_LOGPATH));
        this.configsMap.put(LOG4JMONITOR_DELAY.getKey(), this.getProperty(LOG4JMONITOR_DELAY));
        this.configsMap.put(REQUEST_LOG_RETAINDAYS.getKey(), this.getProperty(REQUEST_LOG_RETAINDAYS));
        this.configsMap.put(EXTERNAL_SCRIPT_TIMEOUT.getKey(), this.getProperty(EXTERNAL_SCRIPT_TIMEOUT));
        this.configsMap.put(THREAD_POOL_SIZE_FOR_EXTERNAL_SCRIPT.getKey(), this.getProperty(THREAD_POOL_SIZE_FOR_EXTERNAL_SCRIPT));
        this.configsMap.put(SHARED_RESOURCES_DIR.getKey(), this.getProperty(SHARED_RESOURCES_DIR));
        this.configsMap.put(KDC_PORT.getKey(), this.getProperty(KDC_PORT));
        this.configsMap.put(AGENT_PACKAGE_PARALLEL_COMMANDS_LIMIT.getKey(), this.getProperty(AGENT_PACKAGE_PARALLEL_COMMANDS_LIMIT));
        this.configsMap.put(PROXY_ALLOWED_HOST_PORTS.getKey(), this.getProperty(PROXY_ALLOWED_HOST_PORTS));
        this.configsMap.put(TLS_EPHEMERAL_DH_KEY_SIZE.getKey(), this.getProperty(TLS_EPHEMERAL_DH_KEY_SIZE));
        File passFile = new File(this.configsMap.get(SRVR_KSTR_DIR.getKey()) + File.separator + this.configsMap.get(SRVR_CRT_PASS_FILE.getKey()));
        String password = null;
        if (!passFile.exists()) {
            LOG.info("Generation of file with password");
            try {
                password = RandomStringUtils.randomAlphanumeric((int)Integer.parseInt(this.configsMap.get(SRVR_CRT_PASS_LEN.getKey())));
                FileUtils.writeStringToFile((File)passFile, (String)password, (Charset)Charset.defaultCharset());
                ShellCommandUtil.setUnixFilePermissions("600", passFile.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Error reading certificate password from file");
            }
        }
        LOG.info("Reading password from existing file");
        try {
            password = FileUtils.readFileToString((File)passFile, (Charset)Charset.defaultCharset());
            password = password.replaceAll("\\p{Cntrl}", JDBC_IN_MEMORY_PASSWORD);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configsMap.put(SRVR_CRT_PASS.getKey(), password);
        if (this.getApiSSLAuthentication()) {
            LOG.info("API SSL Authentication is turned on.");
            File httpsPassFile = new File(this.configsMap.get(CLIENT_API_SSL_KSTR_DIR_NAME.getKey()) + File.separator + this.configsMap.get(CLIENT_API_SSL_CRT_PASS_FILE_NAME.getKey()));
            if (httpsPassFile.exists()) {
                LOG.info("Reading password from existing file");
                try {
                    password = FileUtils.readFileToString((File)httpsPassFile, (Charset)Charset.defaultCharset());
                    password = password.replaceAll("\\p{Cntrl}", JDBC_IN_MEMORY_PASSWORD);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error reading certificate password from file " + httpsPassFile.getAbsolutePath());
                }
            } else {
                LOG.error("There is no keystore for https UI connection.");
                LOG.error("Run \"obdp-server setup-https\" or set " + API_USE_SSL.getKey() + " = false.");
                throw new RuntimeException("Error reading certificate password from file " + httpsPassFile.getAbsolutePath());
            }
            this.configsMap.put(CLIENT_API_SSL_CRT_PASS.getKey(), password);
        }
        this.kerberosAuthenticationProperties = this.createKerberosAuthenticationProperties();
        this.loadSSLParams();
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public <T> String getProperty(ConfigurationProperty<T> configurationProperty) {
        String defaultStringValue = null;
        if (null != configurationProperty.getDefaultValue()) {
            defaultStringValue = String.valueOf(configurationProperty.getDefaultValue());
        }
        return this.properties.getProperty(configurationProperty.getKey(), defaultStringValue);
    }

    public void setProperty(ConfigurationProperty<String> configurationProperty, String value) {
        this.properties.setProperty(configurationProperty.getKey(), value);
    }

    protected void loadSSLParams() {
        if (this.getProperty(SSL_TRUSTSTORE_PATH) != null) {
            System.setProperty(JAVAX_SSL_TRUSTSTORE, this.getProperty(SSL_TRUSTSTORE_PATH));
        }
        if (this.getProperty(SSL_TRUSTSTORE_PASSWORD) != null) {
            String ts_password = PasswordUtils.getInstance().readPasswordFromStore(this.getProperty(SSL_TRUSTSTORE_PASSWORD), this);
            if (ts_password != null) {
                System.setProperty(JAVAX_SSL_TRUSTSTORE_PASSWORD, ts_password);
            } else {
                System.setProperty(JAVAX_SSL_TRUSTSTORE_PASSWORD, this.getProperty(SSL_TRUSTSTORE_PASSWORD));
            }
        }
        if (this.getProperty(SSL_TRUSTSTORE_TYPE) != null) {
            System.setProperty(JAVAX_SSL_TRUSTSTORE_TYPE, this.getProperty(SSL_TRUSTSTORE_TYPE));
        }
    }

    private static Properties readConfigFile() {
        Properties properties = new Properties();
        InputStream inputStream = Configuration.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
        if (inputStream == null) {
            throw new RuntimeException("obdp.properties not found in classpath");
        }
        try {
            properties.load(new InputStreamReader(inputStream, Charsets.UTF_8));
            inputStream.close();
        }
        catch (FileNotFoundException fnf) {
            LOG.info("No configuration file obdp.properties found in classpath.", (Throwable)fnf);
        }
        catch (IOException ie) {
            throw new IllegalArgumentException("Can't read configuration file obdp.properties", ie);
        }
        return properties;
    }

    private void writeConfigFile(Properties propertiesToStore, boolean append) throws OBDPException {
        File configFile = null;
        try {
            configFile = this.getConfigFile();
            propertiesToStore.store(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile, append), Charsets.UTF_8), null);
        }
        catch (Exception e) {
            LOG.error("Cannot write properties [" + propertiesToStore + "] into configuration file [" + configFile + ", " + append + "] ");
            throw new OBDPException("Error while clearing obdp.properties", (Throwable)e);
        }
    }

    public void removePropertiesFromAmbariProperties(Collection<String> propertiesToBeRemoved) throws OBDPException {
        Properties existingProperties = Configuration.readConfigFile();
        propertiesToBeRemoved.forEach(key -> existingProperties.remove(key));
        this.writeConfigFile(existingProperties, false);
        this.properties = Configuration.readConfigFile();
    }

    public Properties getLog4jProperties() {
        if (!this.log4jProperties.isEmpty()) {
            return this.log4jProperties;
        }
        InputStream inputStream = Configuration.class.getClassLoader().getResourceAsStream(AMBARI_LOG_FILE);
        if (inputStream == null) {
            throw new RuntimeException("log4j.properties not found in classpath");
        }
        try {
            this.log4jProperties.load(inputStream);
            inputStream.close();
        }
        catch (FileNotFoundException fnf) {
            LOG.info("No configuration file log4j.properties found in classpath.", (Throwable)fnf);
        }
        catch (IOException ie) {
            throw new IllegalArgumentException("Can't read configuration file log4j.properties", ie);
        }
        return this.log4jProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToAmbariUpgradeConfigUpdatesFile(Multimap<AbstractUpgradeCatalog.ConfigUpdateType, Map.Entry<String, String>> propertiesToLog, String configType, String serviceName, String writeToAmbariUpgradeConfigUpdatesFile) {
        try {
            if (this.ambariUpgradeConfigUpdatesFilePath == null) {
                Properties log4jProperties = this.getLog4jProperties();
                if (log4jProperties != null) {
                    String logPath = log4jProperties.getProperty("ambari.log.dir");
                    String rootPath = log4jProperties.getProperty("ambari.root.dir");
                    logPath = StringUtils.replace((String)logPath, (String)"${ambari.root.dir}", (String)rootPath);
                    if (StringUtils.isNotEmpty((String)(logPath = StringUtils.replace((String)logPath, (String)"//", (String)"/")))) {
                        this.ambariUpgradeConfigUpdatesFilePath = logPath + File.separator + writeToAmbariUpgradeConfigUpdatesFile;
                    }
                } else {
                    LOG.warn("Log4j properties are not available");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to create log file name or get path for it:", (Throwable)e);
        }
        if (StringUtils.isNotEmpty((String)this.ambariUpgradeConfigUpdatesFilePath)) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Writer fileWriter = null;
            try {
                JsonObject rootJson = this.readFileToJSON(this.ambariUpgradeConfigUpdatesFilePath);
                this.buildServiceJson(propertiesToLog, configType, serviceName, rootJson);
                fileWriter = new FileWriter(this.ambariUpgradeConfigUpdatesFilePath);
                gson.toJson((JsonElement)rootJson, (Appendable)fileWriter);
            }
            catch (IllegalArgumentException e) {
                JsonObject rootJson = new JsonObject();
                this.buildServiceJson(propertiesToLog, configType, serviceName, rootJson);
                try {
                    fileWriter = new FileWriter(this.ambariUpgradeConfigUpdatesFilePath);
                    gson.toJson((JsonElement)rootJson, (Appendable)fileWriter);
                }
                catch (IOException e1) {
                    LOG.error("Unable to write data into " + this.ambariUpgradeConfigUpdatesFilePath, (Throwable)e);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to write data into " + this.ambariUpgradeConfigUpdatesFilePath, (Throwable)e);
            }
            finally {
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException e) {
                    LOG.error("Unable to close file " + this.ambariUpgradeConfigUpdatesFilePath, (Throwable)e);
                }
            }
        }
    }

    private void buildServiceJson(Multimap<AbstractUpgradeCatalog.ConfigUpdateType, Map.Entry<String, String>> propertiesToLog, String configType, String serviceName, JsonObject rootJson) {
        JsonElement serviceJson = null;
        serviceJson = rootJson.get(serviceName);
        JsonObject serviceJsonObject = null;
        serviceJsonObject = serviceJson != null ? serviceJson.getAsJsonObject() : new JsonObject();
        this.buildConfigJson(propertiesToLog, serviceJsonObject, configType);
        if (serviceName == null) {
            serviceName = "General";
        }
        rootJson.add(serviceName, (JsonElement)serviceJsonObject);
    }

    private void buildConfigJson(Multimap<AbstractUpgradeCatalog.ConfigUpdateType, Map.Entry<String, String>> propertiesToLog, JsonObject serviceJson, String configType) {
        JsonElement configJson = null;
        configJson = serviceJson.get(configType);
        JsonObject configJsonObject = null;
        configJsonObject = configJson != null ? configJson.getAsJsonObject() : new JsonObject();
        this.buildConfigUpdateTypes(propertiesToLog, configJsonObject);
        serviceJson.add(configType, (JsonElement)configJsonObject);
    }

    private void buildConfigUpdateTypes(Multimap<AbstractUpgradeCatalog.ConfigUpdateType, Map.Entry<String, String>> propertiesToLog, JsonObject configJson) {
        for (AbstractUpgradeCatalog.ConfigUpdateType configUpdateType : propertiesToLog.keySet()) {
            JsonElement currentConfigUpdateType = configJson.get(configUpdateType.getDescription());
            JsonObject currentConfigUpdateTypeJsonObject = null;
            currentConfigUpdateTypeJsonObject = currentConfigUpdateType != null ? currentConfigUpdateType.getAsJsonObject() : new JsonObject();
            for (Map.Entry property : propertiesToLog.get((Object)configUpdateType)) {
                currentConfigUpdateTypeJsonObject.add((String)property.getKey(), (JsonElement)new JsonPrimitive((String)property.getValue()));
            }
            configJson.add(configUpdateType.getDescription(), (JsonElement)currentConfigUpdateTypeJsonObject);
        }
    }

    public Map<String, String> getDatabaseConnectorNames() {
        File file = this.getConfigFile();
        Long currentConfigLastModifiedDate = file.lastModified();
        if (currentConfigLastModifiedDate.longValue() != this.configLastModifiedDateForCustomJDBC.longValue()) {
            LOG.info("OBDP properties config file changed.");
            Properties properties = Configuration.readConfigFile();
            for (String propertyName : dbConnectorPropertyNames) {
                String propertyValue = properties.getProperty(propertyName);
                if (!StringUtils.isNotEmpty((String)propertyValue)) continue;
                this.databaseConnectorNames.put(propertyName.replace(".", "_"), propertyValue);
            }
            this.configLastModifiedDateForCustomJDBC = currentConfigLastModifiedDate;
        }
        return this.databaseConnectorNames;
    }

    public File getConfigFile() {
        return new File(Configuration.class.getClassLoader().getResource(CONFIG_FILE).getPath());
    }

    public Map<String, String> getPreviousDatabaseConnectorNames() {
        File file = this.getConfigFile();
        Long currentConfigLastModifiedDate = file.lastModified();
        if (currentConfigLastModifiedDate.longValue() != this.configLastModifiedDateForCustomJDBCToRemove.longValue()) {
            LOG.info("OBDP properties config file changed.");
            Properties properties = Configuration.readConfigFile();
            for (String string : dbConnectorPropertyNames) {
                String string2 = "previous." + string;
                String propertyValue = properties.getProperty(string2);
                if (!StringUtils.isNotEmpty((String)propertyValue)) continue;
                this.databasePreviousConnectorNames.put(string2.replace(".", "_"), propertyValue);
            }
            this.configLastModifiedDateForCustomJDBCToRemove = currentConfigLastModifiedDate;
        }
        return this.databasePreviousConnectorNames;
    }

    public JsonObject getHostChangesJson(String hostChangesFile) {
        if (this.hostChangesJson == null) {
            this.hostChangesJson = this.readFileToJSON(hostChangesFile);
        }
        return this.hostChangesJson;
    }

    private JsonObject readFileToJSON(String file) {
        JsonObject jsonObject;
        try {
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse((Reader)new FileReader(file));
            jsonObject = jsonElement.getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("No file " + file, e);
        }
        return jsonObject;
    }

    public File getViewsDir() {
        String fileName = this.getProperty(VIEWS_DIRECTORY);
        return new File(fileName);
    }

    public boolean isViewValidationEnabled() {
        return Boolean.parseBoolean(this.getProperty(VIEWS_VALIDATE));
    }

    public boolean isViewRemoveUndeployedEnabled() {
        return Boolean.parseBoolean(this.getProperty(VIEWS_REMOVE_UNDEPLOYED));
    }

    public boolean isViewDirectoryWatcherServiceDisabled() {
        return Boolean.parseBoolean(this.getProperty(DISABLE_VIEW_DIRECTORY_WATCHER));
    }

    public int getJavaVersion() {
        String versionStr = System.getProperty("java.version");
        if (versionStr.startsWith("1.6")) {
            return 6;
        }
        if (versionStr.startsWith("1.7")) {
            return 7;
        }
        if (versionStr.startsWith("1.8")) {
            return 8;
        }
        if (versionStr.startsWith("17")) {
            return 17;
        }
        return -1;
    }

    public File getBootStrapDir() {
        String fileName = this.getProperty(BOOTSTRAP_DIRECTORY);
        return new File(fileName);
    }

    public String getBootStrapScript() {
        return this.getProperty(BOOTSTRAP_SCRIPT);
    }

    public String getBootSetupAgentScript() {
        return this.getProperty(BOOTSTRAP_SETUP_AGENT_SCRIPT);
    }

    public String getBootSetupAgentPassword() {
        String pass = this.configsMap.get(PASSPHRASE.getKey());
        if (null != pass) {
            return pass;
        }
        return this.getProperty(BOOTSTRAP_SETUP_AGENT_PASSWORD);
    }

    public File getRecommendationsDir() {
        String fileName = this.getProperty(RECOMMENDATIONS_DIR);
        return new File(fileName);
    }

    public String getRecommendationsArtifactsLifetime() {
        return this.getProperty(RECOMMENDATIONS_ARTIFACTS_LIFETIME);
    }

    public int getRecommendationsArtifactsRolloverMax() {
        int rollovermax = Integer.parseInt(this.getProperty(RECOMMENDATIONS_ARTIFACTS_ROLLOVER_MAX));
        return rollovermax == 0 ? 100 : rollovermax;
    }

    public String areHostsSysPrepped() {
        return this.getProperty(SYS_PREPPED_HOSTS);
    }

    public Integer getHeartbeatMonitorInterval() {
        return Integer.parseInt(this.getProperty(HEARTBEAT_MONITORING_INTERVAL));
    }

    public boolean arePackagesLegacyOverridden() {
        return this.getProperty(LEGACY_OVERRIDE).equalsIgnoreCase("true");
    }

    public CommandExecutionType getStageExecutionType() {
        return CommandExecutionType.valueOf(this.getProperty(COMMAND_EXECUTION_TYPE));
    }

    public String getStackAdvisorScript() {
        return this.getProperty(STACK_ADVISOR_SCRIPT);
    }

    public List<String> getRollingUpgradeSkipPackagesPrefixes() {
        String propertyValue = this.getProperty(ROLLING_UPGRADE_SKIP_PACKAGES_PREFIXES);
        ArrayList<String> res = new ArrayList<String>();
        for (String prefix : propertyValue.split(",")) {
            if (prefix.isEmpty()) continue;
            res.add(prefix.trim());
        }
        return res;
    }

    public boolean isUpgradePrecheckBypass() {
        return Boolean.parseBoolean(this.getProperty(STACK_UPGRADE_BYPASS_PRECHECKS));
    }

    public int getStackUpgradeAutoRetryTimeoutMins() {
        Integer result = NumberUtils.toInt((String)this.getProperty(STACK_UPGRADE_AUTO_RETRY_TIMEOUT_MINS));
        return result >= 0 ? result : 0;
    }

    public int getStackUpgradeAutoRetryCheckIntervalSecs() {
        Integer result = NumberUtils.toInt((String)this.getProperty(STACK_UPGRADE_AUTO_RETRY_CHECK_INTERVAL_SECS));
        return result >= 0 ? result : 0;
    }

    public List<String> getStackUpgradeAutoRetryCustomCommandNamesToIgnore() {
        String value = this.getProperty(STACK_UPGRADE_AUTO_RETRY_CUSTOM_COMMAND_NAMES_TO_IGNORE);
        List<String> list = this.convertCSVwithQuotesToList(value);
        this.listToLowerCase(list);
        return list;
    }

    public List<String> getStackUpgradeAutoRetryCommandDetailsToIgnore() {
        String value = this.getProperty(STACK_UPGRADE_AUTO_RETRY_COMMAND_DETAILS_TO_IGNORE);
        List<String> list = this.convertCSVwithQuotesToList(value);
        this.listToLowerCase(list);
        return list;
    }

    private List<String> convertCSVwithQuotesToList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)value)) {
            if (value.indexOf(",") >= 0) {
                for (String e : value.split(",")) {
                    e = StringUtils.stripStart((String)e, (String)"\"");
                    e = StringUtils.stripEnd((String)e, (String)"\"");
                    list.add(e);
                }
            } else {
                list.add(value);
            }
        }
        return list;
    }

    private void listToLowerCase(List<String> list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, list.get(i).toLowerCase());
        }
    }

    public Map<String, String> getConfigsMap() {
        return this.configsMap;
    }

    public Map<String, Map<String, String>> getAgentConfigsMap() {
        return this.agentConfigsMap;
    }

    public boolean csrfProtectionEnabled() {
        return Boolean.parseBoolean(this.getProperty(API_CSRF_PREVENTION));
    }

    public ClientSecurityType getClientSecurityType() {
        return ClientSecurityType.fromString(this.getProperty(CLIENT_SECURITY));
    }

    public void setClientSecurityType(ClientSecurityType type) {
        this.setProperty(CLIENT_SECURITY, type.toString());
    }

    public String getWebAppDir() {
        return this.getProperty(WEBAPP_DIRECTORY.getKey());
    }

    public String getHostsMapFile() {
        LOG.info("Hosts Mapping File " + this.getProperty(SRVR_HOSTS_MAPPING));
        return this.getProperty(SRVR_HOSTS_MAPPING);
    }

    public String getMetadataPath() {
        return this.getProperty(METADATA_DIR_PATH);
    }

    public String getCommonServicesPath() {
        return this.getProperty(COMMON_SERVICES_DIR_PATH);
    }

    public String getExtensionsPath() {
        return this.getProperty(EXTENSIONS_DIR_PATH);
    }

    public String getMpacksStagingPath() {
        return this.getProperty(MPACKS_STAGING_DIR_PATH);
    }

    public String getMpacksV2StagingPath() {
        return this.getProperty(MPACKS_V2_STAGING_DIR_PATH);
    }

    public String getServerVersionFilePath() {
        return this.getProperty(SERVER_VERSION_FILE);
    }

    public String getServerVersion() {
        try {
            return FileUtils.readFileToString((File)new File(this.getServerVersionFilePath()), (Charset)Charset.defaultCharset()).trim();
        }
        catch (IOException e) {
            LOG.error("Unable to read server version file", (Throwable)e);
            return null;
        }
    }

    public String getDefaultApiAuthenticatedUser() {
        return this.properties.getProperty(API_AUTHENTICATED_USER.getKey());
    }

    public int getClientSSLApiPort() {
        return Integer.parseInt(this.getProperty(CLIENT_API_SSL_PORT));
    }

    public boolean getApiSSLAuthentication() {
        return Boolean.parseBoolean(this.getProperty(API_USE_SSL));
    }

    public boolean getAgentSSLAuthentication() {
        return Boolean.parseBoolean(this.getProperty(AGENT_USE_SSL));
    }

    public String getStrictTransportSecurityHTTPResponseHeader() {
        return this.getProperty(HTTP_STRICT_TRANSPORT_HEADER_VALUE);
    }

    public String getXFrameOptionsHTTPResponseHeader() {
        return this.getProperty(HTTP_X_FRAME_OPTIONS_HEADER_VALUE);
    }

    public String getXXSSProtectionHTTPResponseHeader() {
        return this.getProperty(HTTP_X_XSS_PROTECTION_HEADER_VALUE);
    }

    public String getContentSecurityPolicyHTTPResponseHeader() {
        return this.getProperty(HTTP_CONTENT_SECURITY_POLICY_HEADER_VALUE);
    }

    public String getXContentTypeHTTPResponseHeader() {
        return this.getProperty(HTTP_X_CONTENT_TYPE_HEADER_VALUE);
    }

    public String getCacheControlHTTPResponseHeader() {
        return this.getProperty(HTTP_CACHE_CONTROL_HEADER_VALUE);
    }

    public String getPragmaHTTPResponseHeader() {
        return this.getProperty(HTTP_PRAGMA_HEADER_VALUE);
    }

    public String getCharsetHTTPResponseHeader() {
        return this.getProperty(HTTP_CHARSET);
    }

    public String getViewsStrictTransportSecurityHTTPResponseHeader() {
        return this.getProperty(VIEWS_HTTP_STRICT_TRANSPORT_HEADER_VALUE);
    }

    public String getViewsXFrameOptionsHTTPResponseHeader() {
        return this.getProperty(VIEWS_HTTP_X_FRAME_OPTIONS_HEADER_VALUE);
    }

    public String getViewsXXSSProtectionHTTPResponseHeader() {
        return this.getProperty(VIEWS_HTTP_X_XSS_PROTECTION_HEADER_VALUE);
    }

    public String getViewsContentSecurityPolicyHTTPResponseHeader() {
        return this.getProperty(VIEWS_HTTP_CONTENT_SECURITY_POLICY_HEADER_VALUE);
    }

    public String getViewsXContentTypeHTTPResponseHeader() {
        return this.getProperty(VIEWS_HTTP_X_CONTENT_TYPE_HEADER_VALUE);
    }

    public String getViewsCacheControlHTTPResponseHeader() {
        return this.getProperty(VIEWS_HTTP_CACHE_CONTROL_HEADER_VALUE);
    }

    public String getViewsAdditionalClasspath() {
        return this.getProperty(VIEWS_ADDITIONAL_CLASSPATH_VALUE);
    }

    public String getViewsPragmaHTTPResponseHeader() {
        return this.getProperty(VIEWS_HTTP_PRAGMA_HEADER_VALUE);
    }

    public String getViewsCharsetHTTPResponseHeader() {
        return this.getProperty(VIEWS_HTTP_CHARSET);
    }

    public boolean validateAgentHostnames() {
        return Boolean.parseBoolean(this.getProperty(SRVR_AGENT_HOSTNAME_VALIDATE));
    }

    public boolean isTwoWaySsl() {
        return Boolean.parseBoolean(this.getProperty(SRVR_TWO_WAY_SSL));
    }

    public boolean isApiGzipped() {
        return Boolean.parseBoolean(this.getProperty(API_GZIP_COMPRESSION_ENABLED));
    }

    public boolean isGzipHandlerEnabledForJetty() {
        return Boolean.parseBoolean(this.getProperty(GZIP_HANDLER_JETTY_ENABLED));
    }

    public boolean isAgentApiGzipped() {
        return Boolean.parseBoolean(this.getProperty(AGENT_API_GZIP_COMPRESSION_ENABLED));
    }

    public String getApiGzipMinSize() {
        return this.getProperty(API_GZIP_MIN_COMPRESSION_SIZE);
    }

    public PersistenceType getPersistenceType() {
        String value = this.getProperty(SERVER_PERSISTENCE_TYPE);
        return PersistenceType.fromString(value);
    }

    public String getDatabaseDriver() {
        if (this.getPersistenceType() != PersistenceType.IN_MEMORY) {
            return this.getProperty(SERVER_JDBC_DRIVER);
        }
        return JDBC_IN_MEMORY_DRIVER;
    }

    public String getDatabaseUrl() {
        if (this.getPersistenceType() != PersistenceType.IN_MEMORY) {
            String URI2 = this.getProperty(SERVER_JDBC_URL);
            if (URI2 != null) {
                return URI2;
            }
            return this.getLocalDatabaseUrl();
        }
        return JDBC_IN_MEMORY_URL;
    }

    public String getLocalDatabaseUrl() {
        String dbName = this.properties.getProperty(SERVER_DB_NAME.getKey());
        if (dbName == null || dbName.isEmpty()) {
            throw new RuntimeException("Server DB Name is not configured!");
        }
        return JDBC_LOCAL_URL + dbName;
    }

    public String getDatabaseUser() {
        if (this.getPersistenceType() == PersistenceType.IN_MEMORY) {
            return JDBC_IN_MEMORY_USER;
        }
        return this.getProperty(SERVER_JDBC_USER_NAME);
    }

    public String getDatabasePassword() {
        if (this.getPersistenceType() == PersistenceType.IN_MEMORY) {
            return JDBC_IN_MEMORY_PASSWORD;
        }
        String passwdProp = this.properties.getProperty(SERVER_JDBC_USER_PASSWD.getKey());
        String dbpasswd = null;
        boolean isPasswordAlias = false;
        if (CredentialProvider.isAliasString(passwdProp)) {
            dbpasswd = PasswordUtils.getInstance().readPasswordFromStore(passwdProp, this);
            isPasswordAlias = true;
        }
        if (dbpasswd != null) {
            return dbpasswd;
        }
        if (isPasswordAlias) {
            LOG.error("Can't read db password from keystore. Please, check master key was set correctly.");
            throw new RuntimeException("Can't read db password from keystore. Please, check master key was set correctly.");
        }
        return PasswordUtils.getInstance().readPasswordFromFile(passwdProp, SERVER_JDBC_USER_PASSWD.getDefaultValue());
    }

    public String getRcaDatabaseDriver() {
        return this.getProperty(SERVER_JDBC_RCA_DRIVER);
    }

    public String getRcaDatabaseUrl() {
        return this.getProperty(SERVER_JDBC_RCA_URL);
    }

    public String getRcaDatabaseUser() {
        return this.getProperty(SERVER_JDBC_RCA_USER_NAME);
    }

    public String getRcaDatabasePassword() {
        String passwdProp = this.properties.getProperty(SERVER_JDBC_RCA_USER_PASSWD.getKey());
        return PasswordUtils.getInstance().readPassword(passwdProp, SERVER_JDBC_RCA_USER_PASSWD.getDefaultValue());
    }

    public String getServerOsType() {
        return this.getProperty(OS_VERSION);
    }

    public String getServerOsFamily() {
        return this.getProperty(OS_FAMILY);
    }

    public String getMasterHostname(String defaultValue) {
        return this.properties.getProperty(BOOTSTRAP_MASTER_HOSTNAME.getKey(), defaultValue);
    }

    public int getClientApiPort() {
        return Integer.parseInt(this.getProperty(CLIENT_API_PORT));
    }

    public String getOjdbcJarName() {
        return this.getProperty(OJDBC_JAR_NAME);
    }

    public String getJavaHome() {
        return this.getProperty(JAVA_HOME);
    }

    public String getAmbariJavaHome() {
        return this.getProperty(AMBARI_JAVA_HOME);
    }

    public String getJDKName() {
        return this.getProperty(JDK_NAME);
    }

    public String getJCEName() {
        return this.getProperty(JCE_NAME);
    }

    public String getStackJavaHome() {
        return this.getProperty(STACK_JAVA_HOME);
    }

    public String getStackJDKName() {
        return this.getProperty(STACK_JDK_NAME);
    }

    public String getStackJCEName() {
        return this.getProperty(STACK_JCE_NAME);
    }

    public String getStackJavaVersion() {
        return this.getProperty(STACK_JAVA_VERSION);
    }

    public String getAmbariBlacklistFile() {
        return this.getProperty(PROPERTY_MASK_FILE);
    }

    public String getServerDBName() {
        return this.getProperty(SERVER_DB_NAME);
    }

    public String getMySQLJarName() {
        return this.getProperty(MYSQL_JAR_NAME);
    }

    public String getPasswordPolicyRegexp() {
        return this.getProperty(PASSWORD_POLICY_REGEXP);
    }

    public String getPasswordPolicyDescription() {
        return this.getProperty(PASSWORD_POLICY_DESCRIPTION);
    }

    public int getPasswordPolicyHistoryCount() {
        int historyCount = Integer.parseInt(this.getProperty(PASSWORD_POLICY_HISTORY_COUNT));
        if (historyCount < 1) {
            historyCount = 1;
            LOG.debug("Invalid password history count detected. The count has been automatically set to the minimum permissible value of {}.", (Object)1);
        }
        if (historyCount > 10) {
            historyCount = 10;
            LOG.debug("Invalid password history count detected. The count has been automatically set to the maximum permissible value of {}.", (Object)10);
        }
        return historyCount;
    }

    public JPATableGenerationStrategy getJPATableGenerationStrategy() {
        return JPATableGenerationStrategy.fromString(System.getProperty(SERVER_JDBC_GENERATE_TABLES.getKey()));
    }

    public int getConnectionMaxIdleTime() {
        return Integer.parseInt(this.getProperty(SERVER_CONNECTION_MAX_IDLE_TIME));
    }

    public String getAnonymousAuditName() {
        return this.getProperty(ANONYMOUS_AUDIT_NAME);
    }

    public boolean isMasterKeyPersisted() {
        File masterKeyFile = this.getMasterKeyLocation();
        return masterKeyFile != null && masterKeyFile.exists();
    }

    public File getServerKeyStoreDirectory() {
        String path = this.getProperty(SRVR_KSTR_DIR);
        return path == null || path.isEmpty() ? new File(".") : new File(path);
    }

    public File getMasterKeyLocation() {
        File location;
        String path = this.getProperty(MASTER_KEY_LOCATION);
        if (StringUtils.isEmpty((String)path)) {
            location = new File(this.getServerKeyStoreDirectory(), MASTER_KEY_FILENAME_DEFAULT);
            LOG.debug("Value of {} is not set, using {}", MASTER_KEY_LOCATION, (Object)location.getAbsolutePath());
        } else {
            location = new File(path, MASTER_KEY_FILENAME_DEFAULT);
            LOG.debug("Value of {} is {}", MASTER_KEY_LOCATION, (Object)location.getAbsolutePath());
        }
        return location;
    }

    public File getMasterKeyStoreLocation() {
        File location;
        String path = this.getProperty(MASTER_KEYSTORE_LOCATION);
        if (StringUtils.isEmpty((String)path)) {
            location = new File(this.getServerKeyStoreDirectory(), MASTER_KEYSTORE_FILENAME_DEFAULT);
            LOG.debug("Value of {} is not set, using {}", MASTER_KEYSTORE_LOCATION, (Object)location.getAbsolutePath());
        } else {
            location = new File(path, MASTER_KEYSTORE_FILENAME_DEFAULT);
            LOG.debug("Value of {} is {}", MASTER_KEYSTORE_LOCATION, (Object)location.getAbsolutePath());
        }
        return location;
    }

    public long getTemporaryKeyStoreRetentionMinutes() {
        long minutes;
        String value = this.getProperty(TEMPORARYSTORE_RETENTION_MINUTES);
        if (StringUtils.isEmpty((String)value)) {
            LOG.debug("Value of {} is not set, using default value ({})", (Object)TEMPORARYSTORE_RETENTION_MINUTES.getKey(), (Object)TEMPORARYSTORE_RETENTION_MINUTES.getDefaultValue());
            minutes = TEMPORARYSTORE_RETENTION_MINUTES.getDefaultValue();
        } else {
            try {
                minutes = Long.parseLong(value);
                LOG.debug("Value of {} is {}", TEMPORARYSTORE_RETENTION_MINUTES, (Object)value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Value of {} ({}) should be a number, falling back to default value ({})", new Object[]{TEMPORARYSTORE_RETENTION_MINUTES.getKey(), value, TEMPORARYSTORE_RETENTION_MINUTES.getDefaultValue()});
                minutes = TEMPORARYSTORE_RETENTION_MINUTES.getDefaultValue();
            }
        }
        return minutes;
    }

    public boolean isActivelyPurgeTemporaryKeyStore() {
        String value = this.getProperty(TEMPORARYSTORE_ACTIVELY_PURGE);
        if (StringUtils.isEmpty((String)value)) {
            LOG.debug("Value of {} is not set, using default value ({})", (Object)TEMPORARYSTORE_ACTIVELY_PURGE.getKey(), (Object)TEMPORARYSTORE_ACTIVELY_PURGE.getDefaultValue());
            return TEMPORARYSTORE_ACTIVELY_PURGE.getDefaultValue();
        }
        if ("true".equalsIgnoreCase(value)) {
            LOG.debug("Value of {} is {}", (Object)TEMPORARYSTORE_ACTIVELY_PURGE.getKey(), (Object)value);
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            LOG.debug("Value of {} is {}", (Object)TEMPORARYSTORE_ACTIVELY_PURGE.getKey(), (Object)value);
            return false;
        }
        LOG.warn("Value of {} should be either \"true\" or \"false\" but is \"{}\", falling back to default value ({})", new Object[]{TEMPORARYSTORE_ACTIVELY_PURGE.getKey(), value, TEMPORARYSTORE_ACTIVELY_PURGE.getDefaultValue()});
        return TEMPORARYSTORE_ACTIVELY_PURGE.getDefaultValue();
    }

    public String getSrvrDisabledCiphers() {
        String disabledCiphers = this.getProperty(SRVR_DISABLED_CIPHERS);
        return disabledCiphers.trim();
    }

    public String getSrvrDisabledProtocols() {
        String disabledProtocols = this.getProperty(SRVR_DISABLED_PROTOCOLS);
        return disabledProtocols.trim();
    }

    public int getOneWayAuthPort() {
        return Integer.parseInt(this.getProperty(SRVR_ONE_WAY_SSL_PORT));
    }

    public int getTwoWayAuthPort() {
        return Integer.parseInt(this.getProperty(SRVR_TWO_WAY_SSL_PORT));
    }

    public Properties getDatabaseCustomProperties() {
        if (null != this.customDbProperties) {
            return this.customDbProperties;
        }
        this.customDbProperties = new Properties();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            Object key = entry.getKey().toString();
            String val = entry.getValue().toString();
            if (!((String)key).startsWith(SERVER_JDBC_PROPERTIES_PREFIX)) continue;
            key = "eclipselink.jdbc.property." + ((String)key).substring(SERVER_JDBC_PROPERTIES_PREFIX.length());
            this.customDbProperties.put(key, val);
        }
        return this.customDbProperties;
    }

    public Properties getPersistenceCustomProperties() {
        if (null != this.customPersistenceProperties) {
            return this.customPersistenceProperties;
        }
        this.customPersistenceProperties = new Properties();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey().toString();
            String val = entry.getValue().toString();
            if (!key.startsWith(SERVER_PERSISTENCE_PROPERTIES_PREFIX)) continue;
            key = key.substring(SERVER_PERSISTENCE_PROPERTIES_PREFIX.length());
            this.customPersistenceProperties.put(key, val);
        }
        return this.customPersistenceProperties;
    }

    public int getHttpRequestHeaderSize() {
        return Integer.parseInt(this.getProperty(SERVER_HTTP_REQUEST_HEADER_SIZE));
    }

    public int getHttpResponseHeaderSize() {
        return Integer.parseInt(this.getProperty(SERVER_HTTP_RESPONSE_HEADER_SIZE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPropertiesToBlackList() {
        if (this.propertiesToMask != null) {
            return this.propertiesToMask;
        }
        Properties blacklistProperties = new Properties();
        String blacklistFile = this.getAmbariBlacklistFile();
        this.propertiesToMask = new HashSet<String>();
        if (blacklistFile != null) {
            File propertiesMaskFile = new File(blacklistFile);
            FileInputStream inputStream = null;
            if (propertiesMaskFile.exists()) {
                try {
                    inputStream = new FileInputStream(propertiesMaskFile);
                    blacklistProperties.load(inputStream);
                    this.propertiesToMask = blacklistProperties.stringPropertyNames();
                }
                catch (Exception e) {
                    try {
                        String message = String.format("Blacklist properties file %s cannot be read", blacklistFile);
                        LOG.error(message);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return this.propertiesToMask;
    }

    public Map<String, String> getAmbariProperties() {
        Properties properties = Configuration.readConfigFile();
        HashMap<String, String> ambariPropertiesMap = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            ambariPropertiesMap.put(key, properties.getProperty(key));
        }
        return ambariPropertiesMap;
    }

    public long getExecutionCommandsCacheSize() {
        String stringValue = this.getProperty(SERVER_EC_CACHE_SIZE);
        long value = SERVER_EC_CACHE_SIZE.getDefaultValue();
        if (stringValue != null) {
            try {
                value = Long.parseLong(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public boolean getHostRoleCommandStatusSummaryCacheEnabled() {
        String stringValue = this.getProperty(SERVER_HRC_STATUS_SUMMARY_CACHE_ENABLED);
        boolean value = SERVER_HRC_STATUS_SUMMARY_CACHE_ENABLED.getDefaultValue();
        if (stringValue != null) {
            try {
                value = Boolean.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public long getHostRoleCommandStatusSummaryCacheSize() {
        String stringValue = this.getProperty(SERVER_HRC_STATUS_SUMMARY_CACHE_SIZE);
        long value = SERVER_HRC_STATUS_SUMMARY_CACHE_SIZE.getDefaultValue();
        if (stringValue != null) {
            try {
                value = Long.parseLong(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public long getHostRoleCommandStatusSummaryCacheExpiryDuration() {
        String stringValue = this.getProperty(SERVER_HRC_STATUS_SUMMARY_CACHE_EXPIRY_DURATION);
        long value = SERVER_HRC_STATUS_SUMMARY_CACHE_EXPIRY_DURATION.getDefaultValue();
        if (stringValue != null) {
            try {
                value = Long.parseLong(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public boolean isStaleConfigCacheEnabled() {
        return Boolean.parseBoolean(this.getProperty(SERVER_STALE_CONFIG_CACHE_ENABLED));
    }

    public Integer staleConfigCacheExpiration() {
        return Integer.parseInt(this.getProperty(SERVER_STALE_CONFIG_CACHE_EXPIRATION));
    }

    public String[] getRepoValidationSuffixes(String osType) {
        String repoSuffixes = this.osFamily.isUbuntuFamily(osType) ? this.getProperty(REPO_SUFFIX_KEY_UBUNTU) : this.getProperty(REPO_SUFFIX_KEY_DEFAULT);
        return repoSuffixes.split(",");
    }

    public String isExecutionSchedulerClusterd() {
        return this.getProperty(EXECUTION_SCHEDULER_CLUSTERED);
    }

    public String getExecutionSchedulerThreads() {
        return this.getProperty(EXECUTION_SCHEDULER_THREADS);
    }

    public Integer getRequestReadTimeout() {
        return Integer.parseInt(this.getProperty(REQUEST_READ_TIMEOUT));
    }

    public Integer getRequestConnectTimeout() {
        return Integer.parseInt(this.getProperty(REQUEST_CONNECT_TIMEOUT));
    }

    public Integer getViewAmbariRequestReadTimeout() {
        return Integer.parseInt(this.getProperty(AMBARI_REQUEST_READ_TIMEOUT));
    }

    public Integer getViewAmbariRequestConnectTimeout() {
        return Integer.parseInt(this.getProperty(AMBARI_REQUEST_CONNECT_TIMEOUT));
    }

    public String getExecutionSchedulerConnections() {
        return this.getProperty(EXECUTION_SCHEDULER_CONNECTIONS);
    }

    public String getExecutionSchedulerMaxStatementsPerConnection() {
        return this.getProperty(EXECUTION_SCHEDULER_MAX_STATEMENTS_PER_CONNECTION);
    }

    public Long getExecutionSchedulerMisfireToleration() {
        return Long.parseLong(this.getProperty(EXECUTION_SCHEDULER_MISFIRE_TOLERATION));
    }

    public Integer getExecutionSchedulerStartDelay() {
        return Integer.parseInt(this.getProperty(EXECUTION_SCHEDULER_START_DELAY));
    }

    public Long getExecutionSchedulerWait() {
        String stringValue = this.getProperty(EXECUTION_SCHEDULER_WAIT);
        long sleepTime = EXECUTION_SCHEDULER_WAIT.getDefaultValue();
        if (stringValue != null) {
            try {
                sleepTime = Long.parseLong(stringValue);
            }
            catch (NumberFormatException ignored) {
                LOG.warn("Value of {} ({}) should be a number, falling back to default value ({})", new Object[]{EXECUTION_SCHEDULER_WAIT.getKey(), stringValue, EXECUTION_SCHEDULER_WAIT.getDefaultValue()});
            }
        }
        if (sleepTime > 60L) {
            LOG.warn("Value of {} ({}) should be a number between 1 adn 60, falling back to maximum value ({})", new Object[]{EXECUTION_SCHEDULER_WAIT, sleepTime, 60});
            sleepTime = 60L;
        }
        return sleepTime * 1000L;
    }

    public Integer getExternalScriptTimeout() {
        return Integer.parseInt(this.getProperty(EXTERNAL_SCRIPT_TIMEOUT));
    }

    public Integer getExternalScriptThreadPoolSize() {
        return Integer.parseInt(this.getProperty(THREAD_POOL_SIZE_FOR_EXTERNAL_SCRIPT));
    }

    public boolean getParallelStageExecution() {
        return Boolean.parseBoolean(this.configsMap.get(PARALLEL_STAGE_EXECUTION.getKey()));
    }

    public String getCustomActionDefinitionPath() {
        return this.getProperty(CUSTOM_ACTION_DEFINITION);
    }

    public int getAgentPackageParallelCommandsLimit() {
        int value = Integer.parseInt(this.getProperty(AGENT_PACKAGE_PARALLEL_COMMANDS_LIMIT));
        if (value < 1) {
            value = 1;
        }
        return value;
    }

    public String getDefaultAgentTaskTimeout(boolean isPackageInstallationTask) {
        ConfigurationProperty<Long> configurationProperty = isPackageInstallationTask ? AGENT_PACKAGE_INSTALL_TASK_TIMEOUT : AGENT_TASK_TIMEOUT;
        String key = configurationProperty.getKey();
        Long defaultValue = configurationProperty.getDefaultValue();
        String value = this.getProperty(configurationProperty);
        if (StringUtils.isNumeric((String)value)) {
            return value;
        }
        LOG.warn(String.format("Value of %s (%s) should be a number, falling back to default value (%s)", key, value, defaultValue));
        return String.valueOf(defaultValue);
    }

    public Long getAgentServiceCheckTaskTimeout() {
        String value = this.getProperty(AGENT_SERVICE_CHECK_TASK_TIMEOUT);
        if (StringUtils.isNumeric((String)value)) {
            return Long.parseLong(value);
        }
        LOG.warn("Value of {} ({}) should be a number, falling back to default value ({})", new Object[]{AGENT_SERVICE_CHECK_TASK_TIMEOUT.getKey(), value, AGENT_SERVICE_CHECK_TASK_TIMEOUT.getDefaultValue()});
        return AGENT_SERVICE_CHECK_TASK_TIMEOUT.getDefaultValue();
    }

    public Integer getDefaultServerTaskTimeout() {
        String value = this.getProperty(SERVER_TASK_TIMEOUT);
        if (StringUtils.isNumeric((String)value)) {
            return Integer.parseInt(value);
        }
        LOG.warn("Value of {} ({}) should be a number, falling back to default value ({})", new Object[]{SERVER_TASK_TIMEOUT.getKey(), value, SERVER_TASK_TIMEOUT.getDefaultValue()});
        return SERVER_TASK_TIMEOUT.getDefaultValue();
    }

    public String getResourceDirPath() {
        return this.getProperty(RESOURCES_DIR);
    }

    public String getSharedResourcesDirPath() {
        return this.getProperty(SHARED_RESOURCES_DIR);
    }

    public String getServerJDBCPostgresSchemaName() {
        return this.getProperty(SERVER_JDBC_POSTGRES_SCHEMA_NAME);
    }

    public int getClientThreadPoolSize() {
        return Integer.parseInt(this.getProperty(CLIENT_THREADPOOL_SIZE));
    }

    public int getSpringMessagingThreadPoolSize() {
        return Integer.parseInt(this.getProperty(MESSAGING_THREAD_POOL_SIZE));
    }

    public int getRegistrationThreadPoolSize() {
        return Integer.parseInt(this.getProperty(REGISTRATION_THREAD_POOL_SIZE));
    }

    public int getSubscriptionRegistryCacheSize() {
        return Integer.parseInt(this.getProperty(SUBSCRIPTION_REGISTRY_CACHE_MAX_SIZE));
    }

    public int getAgentsRegistrationQueueSize() {
        return Integer.parseInt(this.getProperty(AGENTS_REGISTRATION_QUEUE_SIZE));
    }

    public int getAgentsReportProcessingPeriod() {
        return Integer.parseInt(this.getProperty(AGENTS_REPORT_PROCESSING_PERIOD));
    }

    public int getAgentsReportProcessingStartTimeout() {
        return Integer.parseInt(this.getProperty(AGENTS_REPORT_PROCESSING_START_TIMEOUT));
    }

    public int getAgentsReportThreadPoolSize() {
        return Integer.parseInt(this.getProperty(AGENTS_REPORT_THREAD_POOL_SIZE));
    }

    public int getAPIHeartbeatInterval() {
        return Integer.parseInt(this.getProperty(API_HEARTBEAT_INTERVAL));
    }

    public int getStompMaxIncomingMessageSize() {
        return Integer.parseInt(this.getProperty(STOMP_MAX_INCOMING_MESSAGE_SIZE));
    }

    public int getStompMaxBufferMessageSize() {
        return Integer.parseInt(this.getProperty(STOMP_MAX_BUFFER_MESSAGE_SIZE));
    }

    public int getExecutionCommandsRetryCount() {
        return Integer.parseInt(this.getProperty(EXECUTION_COMMANDS_RETRY_COUNT));
    }

    public int getExecutionCommandsRetryInterval() {
        return Integer.parseInt(this.getProperty(EXECUTION_COMMANDS_RETRY_INTERVAL));
    }

    public int getAgentThreadPoolSize() {
        return Integer.parseInt(this.getProperty(AGENT_THREADPOOL_SIZE));
    }

    public int getViewExtractionThreadPoolMaxSize() {
        return Integer.parseInt(this.getProperty(VIEW_EXTRACTION_THREADPOOL_MAX_SIZE));
    }

    public int getViewExtractionThreadPoolCoreSize() {
        return Integer.parseInt(this.getProperty(VIEW_EXTRACTION_THREADPOOL_CORE_SIZE));
    }

    public int getViewRequestThreadPoolMaxSize() {
        return Integer.parseInt(this.getProperty(VIEW_REQUEST_THREADPOOL_MAX_SIZE));
    }

    public Boolean extractViewsAfterClusterConfig() {
        return Boolean.parseBoolean(this.getProperty(VIEW_EXTRACT_AFTER_CLUSTER_CONFIG));
    }

    public int getViewRequestThreadPoolTimeout() {
        return Integer.parseInt(this.getProperty(VIEW_REQUEST_THREADPOOL_TIMEOUT));
    }

    public int getPropertyProvidersThreadPoolCoreSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_PROVIDER_THREADPOOL_CORE_SIZE));
    }

    public int getPropertyProvidersThreadPoolMaxSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_PROVIDER_THREADPOOL_MAX_SIZE));
    }

    public int getPropertyProvidersWorkerQueueSize() {
        return Integer.parseInt(this.getProperty(PROPERTY_PROVIDER_THREADPOOL_WORKER_QUEUE_SIZE));
    }

    public long getPropertyProvidersCompletionServiceTimeout() {
        return Long.parseLong(this.getProperty(PROPERTY_PROVIDER_THREADPOOL_COMPLETION_TIMEOUT));
    }

    public long getViewExtractionThreadPoolTimeout() {
        return Integer.parseInt(this.getProperty(VIEW_EXTRACTION_THREADPOOL_TIMEOUT));
    }

    public int getHttpSessionInactiveTimeout() {
        return Integer.parseInt(this.getProperty(SERVER_HTTP_SESSION_INACTIVE_TIMEOUT));
    }

    public String getAlertTemplateFile() {
        return StringUtils.strip((String)this.getProperty(ALERT_TEMPLATE_FILE));
    }

    public int getAlertEventPublisherCorePoolSize() {
        return Integer.parseInt(this.getProperty(ALERTS_EXECUTION_SCHEDULER_THREADS_CORE_SIZE));
    }

    public int getAlertEventPublisherMaxPoolSize() {
        return Integer.parseInt(this.getProperty(ALERTS_EXECUTION_SCHEDULER_THREADS_MAX_SIZE));
    }

    public int getAlertEventPublisherWorkerQueueSize() {
        return Integer.parseInt(this.getProperty(ALERTS_EXECUTION_SCHEDULER_WORKER_QUEUE_SIZE));
    }

    public String getNodeRecoveryType() {
        return this.getProperty(RECOVERY_TYPE);
    }

    public String getNodeRecoveryMaxCount() {
        return this.getProperty(RECOVERY_MAX_COUNT);
    }

    public String getNodeRecoveryLifetimeMaxCount() {
        return this.getProperty(RECOVERY_LIFETIME_MAX_COUNT);
    }

    public String getNodeRecoveryWindowInMin() {
        return this.getProperty(RECOVERY_WINDOW_IN_MIN);
    }

    public String getRecoveryDisabledComponents() {
        return this.getProperty(RECOVERY_DISABLED_COMPONENTS);
    }

    public String getRecoveryEnabledComponents() {
        return this.getProperty(RECOVERY_ENABLED_COMPONENTS);
    }

    public String getNodeRecoveryRetryGap() {
        return this.getProperty(RECOVERY_RETRY_GAP);
    }

    public String getDefaultKdcPort() {
        return this.getProperty(KDC_PORT);
    }

    public int getKdcConnectionCheckTimeout() {
        return Integer.parseInt(this.getProperty(KDC_CONNECTION_CHECK_TIMEOUT));
    }

    public File getKerberosKeytabCacheDir() {
        return new File(this.getProperty(KERBEROSTAB_CACHE_DIR));
    }

    public boolean isKerberosJaasConfigurationCheckEnabled() {
        return Boolean.parseBoolean(this.getProperty(KERBEROS_CHECK_JAAS_CONFIGURATION));
    }

    public LdapUsernameCollisionHandlingBehavior getLdapSyncCollisionHandlingBehavior() {
        return LdapUsernameCollisionHandlingBehavior.translate(this.getProperty(LDAP_SYNC_USERNAME_COLLISIONS_BEHAVIOR), LdapUsernameCollisionHandlingBehavior.ADD);
    }

    public DatabaseType getDatabaseType() {
        DatabaseType databaseType;
        String dbUrl = this.getDatabaseUrl();
        if (dbUrl.contains(DatabaseType.POSTGRES.getName())) {
            databaseType = DatabaseType.POSTGRES;
        } else if (dbUrl.contains(DatabaseType.ORACLE.getName())) {
            databaseType = DatabaseType.ORACLE;
        } else if (dbUrl.contains(DatabaseType.MYSQL.getName())) {
            databaseType = DatabaseType.MYSQL;
        } else if (dbUrl.contains(DatabaseType.DERBY.getName())) {
            databaseType = DatabaseType.DERBY;
        } else if (dbUrl.contains(DatabaseType.SQL_SERVER.getName())) {
            databaseType = DatabaseType.SQL_SERVER;
        } else if (dbUrl.contains(DatabaseType.SQL_ANYWHERE.getName())) {
            databaseType = DatabaseType.SQL_ANYWHERE;
        } else if (dbUrl.contains(DatabaseType.H2.getName())) {
            databaseType = DatabaseType.H2;
        } else {
            throw new RuntimeException("The database type could be not determined from the JDBC URL " + dbUrl);
        }
        return databaseType;
    }

    public String getDatabaseSchema() {
        DatabaseType databaseType = this.getDatabaseType();
        String databaseSchema = databaseType.equals((Object)DatabaseType.POSTGRES) ? this.getServerJDBCPostgresSchemaName() : (databaseType.equals((Object)DatabaseType.MYSQL) ? this.getServerDBName() : (databaseType.equals((Object)DatabaseType.ORACLE) ? this.getDatabaseUser() : (databaseType.equals((Object)DatabaseType.DERBY) ? "obdp" : (databaseType.equals((Object)DatabaseType.H2) ? "obdp" : null))));
        return databaseSchema;
    }

    public ConnectionPoolType getConnectionPoolType() {
        String connectionPoolType = this.getProperty(SERVER_JDBC_CONNECTION_POOL);
        if (connectionPoolType.equals(ConnectionPoolType.C3P0.getName())) {
            return ConnectionPoolType.C3P0;
        }
        return ConnectionPoolType.INTERNAL;
    }

    public int getConnectionPoolMinimumSize() {
        return Integer.parseInt(this.getProperty(SERVER_JDBC_CONNECTION_POOL_MIN_SIZE));
    }

    public int getConnectionPoolMaximumSize() {
        return Integer.parseInt(this.getProperty(SERVER_JDBC_CONNECTION_POOL_MAX_SIZE));
    }

    public int getConnectionPoolMaximumAge() {
        return Integer.parseInt(this.getProperty(SERVER_JDBC_CONNECTION_POOL_MAX_AGE));
    }

    public int getConnectionPoolMaximumIdle() {
        return Integer.parseInt(this.getProperty(SERVER_JDBC_CONNECTION_POOL_MAX_IDLE_TIME));
    }

    public int getConnectionPoolMaximumExcessIdle() {
        return Integer.parseInt(this.getProperty(SERVER_JDBC_CONNECTION_POOL_MAX_IDLE_TIME_EXCESS));
    }

    public int getConnectionPoolAcquisitionSize() {
        return Integer.parseInt(this.getProperty(SERVER_JDBC_CONNECTION_POOL_AQUISITION_SIZE));
    }

    public int getConnectionPoolAcquisitionRetryAttempts() {
        return Integer.parseInt(this.getProperty(SERVER_JDBC_CONNECTION_POOL_ACQUISITION_RETRY_ATTEMPTS));
    }

    public int getConnectionPoolAcquisitionRetryDelay() {
        return Integer.parseInt(this.getProperty(SERVER_JDBC_CONNECTION_POOL_ACQUISITION_RETRY_DELAY));
    }

    public int getConnectionPoolIdleTestInternval() {
        return Integer.parseInt(this.getProperty(SERVER_JDBC_CONNECTION_POOL_IDLE_TEST_INTERVAL));
    }

    public void setProperty(String key, String value) {
        if (null == value) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value);
        }
    }

    public int getMetricCacheTTLSeconds() {
        return Integer.parseInt(this.getProperty(TIMELINE_METRICS_CACHE_TTL));
    }

    public int getMetricCacheIdleSeconds() {
        return Integer.parseInt(this.getProperty(TIMELINE_METRICS_CACHE_IDLE_TIME));
    }

    public int getMetricCacheEntryUnitSize() {
        return Integer.parseInt(this.getProperty(TIMELINE_METRICS_CACHE_ENTRY_UNIT_SIZE));
    }

    public int getMetricsRequestReadTimeoutMillis() {
        return Integer.parseInt(this.getProperty(TIMELINE_METRICS_REQUEST_READ_TIMEOUT));
    }

    public int getMetricsRequestIntervalReadTimeoutMillis() {
        return Integer.parseInt(this.getProperty(TIMELINE_METRICS_REQUEST_INTERVAL_READ_TIMEOUT));
    }

    public int getMetricsRequestConnectTimeoutMillis() {
        return Integer.parseInt(this.getProperty(TIMELINE_METRICS_REQUEST_CONNECT_TIMEOUT));
    }

    public boolean isMetricsCacheDisabled() {
        return Boolean.parseBoolean(this.getProperty(TIMELINE_METRICS_CACHE_DISABLE));
    }

    public boolean isMetricsServiceDisabled() {
        return Boolean.parseBoolean(this.getProperty(AMBARISERVER_METRICS_DISABLE));
    }

    public Long getMetricRequestBufferTimeCatchupInterval() {
        return Long.parseLong(this.getProperty(TIMELINE_METRICS_REQUEST_CATCHUP_INTERVAL));
    }

    public String getMetricsCacheManagerHeapPercent() {
        String percent = this.getProperty(TIMELINE_METRICS_CACHE_HEAP_PERCENT);
        return percent.trim().endsWith("%") ? percent.trim() : percent.trim() + "%";
    }

    public boolean useMetricsCacheCustomSizingEngine() {
        return Boolean.parseBoolean(this.getProperty(TIMELINE_METRICS_CACHE_USE_CUSTOM_SIZING_ENGINE));
    }

    public AmbariKerberosAuthenticationProperties getKerberosAuthenticationProperties() {
        return this.kerberosAuthenticationProperties;
    }

    public String getServerTempDir() {
        return this.getProperty(SERVER_TMP_DIR);
    }

    public boolean isAlertCacheEnabled() {
        return Boolean.parseBoolean(this.getProperty(ALERTS_CACHE_ENABLED));
    }

    public int getAlertCacheFlushInterval() {
        return Integer.parseInt(this.getProperty(ALERTS_CACHE_FLUSH_INTERVAL));
    }

    public int getAlertCacheSize() {
        return Integer.parseInt(this.getProperty(ALERTS_CACHE_SIZE));
    }

    public String getAmbariDisplayUrl() {
        return this.getProperty(AMBARI_DISPLAY_URL);
    }

    public int getOperationsRetryAttempts() {
        int RETRY_ATTEMPTS_LIMIT = 10;
        String property = this.getProperty(OPERATIONS_RETRY_ATTEMPTS);
        int attempts = Integer.parseInt(property);
        if (attempts < 0) {
            LOG.warn("Invalid operations retry attempts number ({}), should be [0,{}]. Value reset to default {}", new Object[]{attempts, 10, OPERATIONS_RETRY_ATTEMPTS.getDefaultValue()});
            attempts = OPERATIONS_RETRY_ATTEMPTS.getDefaultValue();
        } else if (attempts > 10) {
            LOG.warn("Invalid operations retry attempts number ({}), should be [0,{}]. Value set to {}", new Object[]{attempts, 10, 10});
            attempts = 10;
        }
        if (attempts > 0) {
            LOG.info("Operations retry enabled. Number of retry attempts: {}", (Object)attempts);
        }
        return attempts;
    }

    public int getVersionDefinitionConnectTimeout() {
        return NumberUtils.toInt((String)this.getProperty(VERSION_DEFINITION_CONNECT_TIMEOUT));
    }

    public int getVersionDefinitionReadTimeout() {
        return NumberUtils.toInt((String)this.getProperty(VERSION_DEFINITION_READ_TIMEOUT));
    }

    public Boolean getGplLicenseAccepted() {
        Properties actualProps = Configuration.readConfigFile();
        String defaultGPLAcceptedValue = null;
        if (null != GPL_LICENSE_ACCEPTED.getDefaultValue()) {
            defaultGPLAcceptedValue = String.valueOf(GPL_LICENSE_ACCEPTED.getDefaultValue());
        }
        return Boolean.valueOf(actualProps.getProperty(GPL_LICENSE_ACCEPTED.getKey(), defaultGPLAcceptedValue));
    }

    public String getAgentStackRetryOnInstallCount() {
        return this.getProperty(AGENT_STACK_RETRY_COUNT);
    }

    public String isAgentStackRetryOnInstallEnabled() {
        return this.getProperty(AGENT_STACK_RETRY_ON_REPO_UNAVAILABILITY);
    }

    public boolean isAuditLogEnabled() {
        return Boolean.parseBoolean(this.getProperty(AUDIT_LOG_ENABLED));
    }

    public boolean isServerLocksProfilingEnabled() {
        return Boolean.parseBoolean(this.getProperty(SERVER_LOCKS_PROFILING));
    }

    public int getAuditLoggerCapacity() {
        return NumberUtils.toInt((String)this.getProperty(AUDIT_LOGGER_CAPACITY));
    }

    public Integer getSNMPUdpBindPort() {
        String udpPort = this.getProperty(ALERTS_SNMP_DISPATCH_UDP_PORT);
        return StringUtils.isEmpty((String)udpPort) ? null : Integer.valueOf(Integer.parseInt(udpPort));
    }

    public Integer getAmbariSNMPUdpBindPort() {
        String udpPort = this.getProperty(ALERTS_AMBARI_SNMP_DISPATCH_UDP_PORT);
        return StringUtils.isEmpty((String)udpPort) ? null : Integer.valueOf(Integer.parseInt(udpPort));
    }

    public String getProxyHostAndPorts() {
        return this.getProperty(PROXY_ALLOWED_HOST_PORTS);
    }

    public int getMetricsServiceCacheTimeout() {
        return Integer.parseInt(this.getProperty(METRIC_RETRIEVAL_SERVICE_CACHE_TIMEOUT));
    }

    public int getMetricsServiceThreadPriority() {
        int priority = Integer.parseInt(this.getProperty(METRIC_RETRIEVAL_SERVICE_THREAD_PRIORITY));
        if (priority < 1 || priority > 10) {
            priority = 5;
        }
        return priority;
    }

    public int getMetricsServiceThreadPoolCoreSize() {
        return Integer.parseInt(this.getProperty(METRIC_RETRIEVAL_SERVICE_THREADPOOL_CORE_SIZE));
    }

    public int getMetricsServiceThreadPoolMaxSize() {
        return Integer.parseInt(this.getProperty(METRIC_RETRIEVAL_SERVICE_THREADPOOL_MAX_SIZE));
    }

    public int getMetricsServiceWorkerQueueSize() {
        return Integer.parseInt(this.getProperty(METRIC_RETRIEVAL_SERVICE_THREADPOOL_WORKER_QUEUE_SIZE));
    }

    public int getMetricsServiceRequestTTL() {
        return Integer.parseInt(this.getProperty(METRIC_RETRIEVAL_SERVICE_REQUEST_TTL));
    }

    public boolean isMetricsServiceRequestTTLCacheEnabled() {
        return Boolean.parseBoolean(this.getProperty(METRIC_RETRIEVAL_SERVICE_REQUEST_TTL_ENABLED));
    }

    public boolean isActiveInstance() {
        return Boolean.parseBoolean(this.getProperty(ACTIVE_INSTANCE));
    }

    public boolean isUserHookEnabled() {
        return Boolean.parseBoolean(this.getProperty(POST_USER_CREATION_HOOK_ENABLED));
    }

    public int getParallelTopologyTaskCreationThreadPoolSize() {
        try {
            return Integer.parseInt(this.getProperty(TOPOLOGY_TASK_PARALLEL_CREATION_THREAD_COUNT));
        }
        catch (NumberFormatException e) {
            return TOPOLOGY_TASK_PARALLEL_CREATION_THREAD_COUNT.getDefaultValue();
        }
    }

    public boolean isParallelTopologyTaskCreationEnabled() {
        return Boolean.parseBoolean(this.getProperty(TOPOLOGY_TASK_PARALLEL_CREATION_ENABLED));
    }

    public int getLogSearchPortalConnectTimeout() {
        return NumberUtils.toInt((String)this.getProperty(LOGSEARCH_PORTAL_CONNECT_TIMEOUT));
    }

    public int getLogSearchPortalReadTimeout() {
        return NumberUtils.toInt((String)this.getProperty(LOGSEARCH_PORTAL_READ_TIMEOUT));
    }

    public String getLogSearchPortalExternalAddress() {
        return this.getProperty(LOGSEARCH_PORTAL_EXTERNAL_ADDRESS);
    }

    public int getLogSearchMetadataCacheExpireTimeout() {
        return NumberUtils.toInt((String)this.getProperty(LOGSEARCH_METADATA_CACHE_EXPIRE_TIMEOUT));
    }

    public int getTlsEphemeralDhKeySize() {
        int keySize = NumberUtils.toInt((String)this.getProperty(TLS_EPHEMERAL_DH_KEY_SIZE));
        if (keySize == 0) {
            throw new IllegalArgumentException("Invalid " + TLS_EPHEMERAL_DH_KEY_SIZE + " " + this.getProperty(TLS_EPHEMERAL_DH_KEY_SIZE));
        }
        return keySize;
    }

    public String getDispatchScriptDirectory() {
        return this.getProperty(DISPATCH_PROPERTY_SCRIPT_DIRECTORY);
    }

    public boolean isSecurityPasswordEncryptionEnabled() {
        return Boolean.parseBoolean(this.getProperty(SECURITY_PASSWORD_ENCRYPTON_ENABLED));
    }

    public boolean isSensitiveDataEncryptionEnabled() {
        return Boolean.parseBoolean(this.getProperty(SECURITY_SENSITIVE_DATA_ENCRYPTON_ENABLED));
    }

    public boolean shouldEncryptSensitiveData() {
        return this.isSecurityPasswordEncryptionEnabled() && this.isSensitiveDataEncryptionEnabled();
    }

    public int getDefaultMaxParallelismForUpgrades() {
        return Integer.parseInt(this.getProperty(DEFAULT_MAX_DEGREE_OF_PARALLELISM_FOR_UPGRADES));
    }

    public int getKerberosServerActionThreadPoolSize() {
        return Integer.parseInt(this.getProperty(KERBEROS_SERVER_ACTION_THREADPOOL_SIZE));
    }

    public int getAgentCommandPublisherThreadPoolSize() {
        return Integer.parseInt(this.getProperty(AGENT_COMMAND_PUBLISHER_THREADPOOL_SIZE));
    }

    public int getDefaultForkJoinPoolSize() {
        return Integer.parseInt(this.getProperty(DEFAULT_FORK_JOIN_THREADPOOL_SIZE));
    }

    public int getKerberosServerActionFinalizeTimeout() {
        return Integer.parseInt(this.getProperty(KERBEROS_SERVER_ACTION_FINALIZE_SECONDS));
    }

    public Class<? extends HostGroupStrategy> getAddServiceHostGroupStrategyClass() throws ClassNotFoundException {
        return Class.forName(this.getProperty(ADD_SERVICE_HOST_GROUP_STRATEGY)).asSubclass(HostGroupStrategy.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String OUTPUT_ARGUMENT = "output";
        Options options = new Options();
        options.addOption(Option.builder().longOpt("output").desc("The absolute location of the index.md file to generate").required().type(String.class).hasArg().valueSeparator(' ').build());
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(options, args);
        String outputFile = (String)line.getParsedOptionValue("output");
        TreeMap<String, Field> sortedFields = new TreeMap<String, Field>();
        ArrayList<Field> fields = new ArrayList<Field>(500);
        for (Field field : Configuration.class.getFields()) {
            if (field.getType() != ConfigurationProperty.class) continue;
            fields.add(field);
            ConfigurationProperty configurationProperty = (ConfigurationProperty)field.get(null);
            sortedFields.put(configurationProperty.getKey(), field);
        }
        StringBuilder allPropertiesBuffer = new StringBuilder("| Property Name | Description | Default |");
        allPropertiesBuffer.append(System.lineSeparator());
        allPropertiesBuffer.append("| --- | --- | --- |");
        allPropertiesBuffer.append(System.lineSeparator());
        for (String fieldKey : sortedFields.keySet()) {
            Field field;
            field = (Field)sortedFields.get(fieldKey);
            Markdown markdown = field.getAnnotation(Markdown.class);
            if (null == markdown) {
                ConfigurationMarkdown configMarkdown = field.getAnnotation(ConfigurationMarkdown.class);
                markdown = configMarkdown.markdown();
            }
            if (markdown.internal()) continue;
            ConfigurationProperty configurationProperty = (ConfigurationProperty)field.get(null);
            String key = configurationProperty.getKey();
            Object defaultValue = configurationProperty.getDefaultValue();
            allPropertiesBuffer.append("| ").append(key).append(" | ");
            StringBuilder description = new StringBuilder(markdown.description());
            if (StringUtils.isNotEmpty((String)markdown.relatedTo())) {
                String[] relatedTo = String.format(MARKDOWN_RELATED_TO_TEMPLATE, markdown.relatedTo());
                description.append(HTML_BREAK_TAG).append(HTML_BREAK_TAG).append((String)relatedTo);
            }
            if (markdown.examples().length > 0) {
                description.append(HTML_BREAK_TAG).append(HTML_BREAK_TAG);
                description.append("The following are examples of valid values:").append("<ul>");
                for (String example : markdown.examples()) {
                    description.append("<li>").append("`").append(example).append("`");
                }
                description.append("</ul>");
            }
            allPropertiesBuffer.append((CharSequence)description);
            allPropertiesBuffer.append(" |");
            if (null != defaultValue && StringUtils.isNotEmpty((String)defaultValue.toString())) {
                allPropertiesBuffer.append("`").append(defaultValue).append("`");
            }
            allPropertiesBuffer.append(" | ").append(System.lineSeparator());
        }
        StringBuilder baselineBuffer = new StringBuilder(1024);
        for (ConfigurationGrouping grouping : ConfigurationGrouping.values()) {
            baselineBuffer.append("#### ").append((Object)grouping);
            baselineBuffer.append(System.lineSeparator());
            baselineBuffer.append("| Property Name | ");
            for (ClusterSizeType clusterSizeType : ClusterSizeType.values()) {
                baselineBuffer.append((Object)clusterSizeType).append(" | ");
            }
            baselineBuffer.append(System.lineSeparator());
            baselineBuffer.append("| --- | --- | --- | --- | --- |");
            baselineBuffer.append(System.lineSeparator());
            for (Field field : fields) {
                ConfigurationMarkdown configMarkdown = field.getAnnotation(ConfigurationMarkdown.class);
                if (null == configMarkdown || configMarkdown.group() != grouping) continue;
                ConfigurationProperty configurationProperty = (ConfigurationProperty)field.get(null);
                ClusterScale[] scaleValues = configMarkdown.scaleValues();
                TreeMap<ClusterSizeType, String> miniSort = new TreeMap<ClusterSizeType, String>();
                for (ClusterScale clusterScale : scaleValues) {
                    miniSort.put(clusterScale.clusterSize(), clusterScale.value());
                }
                baselineBuffer.append("| ").append(configurationProperty.getKey()).append(" | ");
                for (ClusterSizeType clusterSizeType : miniSort.keySet()) {
                    baselineBuffer.append((String)miniSort.get((Object)clusterSizeType)).append(" | ");
                }
                baselineBuffer.append(System.lineSeparator());
            }
            baselineBuffer.append(System.lineSeparator());
        }
        InputStream inputStream = null;
        try {
            inputStream = System.getProperties().containsKey(OBDP_CONFIGURATION_MD_TEMPLATE_PROPERTY) ? new FileInputStream(System.getProperties().getProperty(OBDP_CONFIGURATION_MD_TEMPLATE_PROPERTY)) : Configuration.class.getResourceAsStream(MARKDOWN_TEMPLATE_FILE);
            String template = IOUtils.toString((InputStream)inputStream);
            String markdown = template.replace(MARKDOWN_CONFIGURATION_TABLE_KEY, allPropertiesBuffer.toString());
            markdown = markdown.replace(MARKDOWN_BASELINE_VALUES_KEY, baselineBuffer.toString());
            File file = new File(outputFile);
            FileUtils.writeStringToFile((File)file, (String)markdown, (Charset)Charset.defaultCharset());
            System.out.println("Successfully created " + outputFile);
            LOG.info("Successfully created {}", (Object)outputFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    private AmbariKerberosAuthenticationProperties createKerberosAuthenticationProperties() {
        String message;
        AmbariKerberosAuthenticationProperties kerberosAuthProperties = new AmbariKerberosAuthenticationProperties();
        kerberosAuthProperties.setKerberosAuthenticationEnabled(Boolean.valueOf(this.getProperty(KERBEROS_AUTH_ENABLED)));
        if (!kerberosAuthProperties.isKerberosAuthenticationEnabled()) {
            return kerberosAuthProperties;
        }
        String spnegoPrincipalName = this.getProperty(KERBEROS_AUTH_SPNEGO_PRINCIPAL);
        if (spnegoPrincipalName != null && spnegoPrincipalName.contains("_HOST")) {
            String hostName = StageUtils.getHostName();
            if (StringUtils.isEmpty((String)hostName)) {
                LOG.warn("Cannot replace _HOST in the configured SPNEGO principal name with the host name this host since it is not available");
            } else {
                LOG.info("Replacing _HOST in the configured SPNEGO principal name with the host name this host: {}", (Object)hostName);
                spnegoPrincipalName = spnegoPrincipalName.replaceAll("_HOST", hostName);
            }
        }
        kerberosAuthProperties.setSpnegoPrincipalName(spnegoPrincipalName);
        if (StringUtils.isEmpty((String)kerberosAuthProperties.getSpnegoPrincipalName())) {
            message = String.format("The SPNEGO principal name specified in %s is empty. This will cause issues authenticating users using Kerberos.", KERBEROS_AUTH_SPNEGO_PRINCIPAL.getKey());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        kerberosAuthProperties.setSpnegoKeytabFilePath(this.getProperty(KERBEROS_AUTH_SPNEGO_KEYTAB_FILE));
        if (StringUtils.isEmpty((String)kerberosAuthProperties.getSpnegoKeytabFilePath())) {
            message = String.format("The SPNEGO keytab file path specified in %s is empty. This will cause issues authenticating users using Kerberos.", KERBEROS_AUTH_SPNEGO_KEYTAB_FILE.getKey());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        File keytabFile = new File(kerberosAuthProperties.getSpnegoKeytabFilePath());
        if (!keytabFile.exists()) {
            String message2 = String.format("The SPNEGO keytab file path (%s) specified in %s does not exist. This will cause issues authenticating users using Kerberos. . Make sure proper keytab file provided later.", keytabFile.getAbsolutePath(), KERBEROS_AUTH_SPNEGO_KEYTAB_FILE.getKey());
            LOG.error(message2);
        } else if (!keytabFile.canRead()) {
            String message3 = String.format("The SPNEGO keytab file path (%s) specified in %s cannot be read. This will cause issues authenticating users using Kerberos. . Make sure proper keytab file provided later.", keytabFile.getAbsolutePath(), KERBEROS_AUTH_SPNEGO_KEYTAB_FILE.getKey());
            LOG.error(message3);
        }
        kerberosAuthProperties.setAuthToLocalRules(this.getProperty(KERBEROS_AUTH_AUTH_TO_LOCAL_RULES));
        LOG.info("Kerberos authentication is enabled:\n \t{}: {}\n\t{}: {}\n\t{}: {}\n\t{}: {}\n", new Object[]{KERBEROS_AUTH_ENABLED.getKey(), kerberosAuthProperties.isKerberosAuthenticationEnabled(), KERBEROS_AUTH_SPNEGO_PRINCIPAL.getKey(), kerberosAuthProperties.getSpnegoPrincipalName(), KERBEROS_AUTH_SPNEGO_KEYTAB_FILE.getKey(), kerberosAuthProperties.getSpnegoKeytabFilePath(), KERBEROS_AUTH_AUTH_TO_LOCAL_RULES.getKey(), kerberosAuthProperties.getAuthToLocalRules()});
        return kerberosAuthProperties;
    }

    public int getKerberosOperationRetries() {
        return Integer.parseInt(this.getProperty(KERBEROS_OPERATION_RETRIES));
    }

    public int getKerberosOperationRetryTimeout() {
        return Integer.parseInt(this.getProperty(KERBEROS_OPERATION_RETRY_TIMEOUT));
    }

    public boolean validateKerberosOperationSSLCertTrust() {
        return Boolean.parseBoolean(this.getProperty(KERBEROS_OPERATION_VERIFY_KDC_TRUST));
    }

    public Integer getAgentApiAcceptors() {
        String acceptors = this.getProperty(SRVR_AGENT_ACCEPTOR_THREAD_COUNT);
        return StringUtils.isEmpty((String)acceptors) ? null : Integer.valueOf(Integer.parseInt(acceptors));
    }

    public Integer getClientApiAcceptors() {
        String acceptors = this.getProperty(SRVR_API_ACCEPTOR_THREAD_COUNT);
        return StringUtils.isEmpty((String)acceptors) ? null : Integer.valueOf(Integer.parseInt(acceptors));
    }

    public String getPamConfigurationFile() {
        return this.getProperty(PAM_CONFIGURATION_FILE);
    }

    public String getAutoGroupCreation() {
        return this.getProperty(AUTO_GROUP_CREATION);
    }

    public int getMaxAuthenticationFailures() {
        return Integer.parseInt(this.getProperty(MAX_LOCAL_AUTHENTICATION_FAILURES));
    }

    public boolean showLockedOutUserMessage() {
        return Boolean.parseBoolean(this.getProperty(SHOW_LOCKED_OUT_USER_MESSAGE));
    }

    public int getAlertServiceCorePoolSize() {
        return Integer.parseInt(this.getProperty(SERVER_SIDE_ALERTS_CORE_POOL_SIZE));
    }

    public boolean isServerShowErrorStacks() {
        return Boolean.parseBoolean(this.getProperty(SERVER_SHOW_ERROR_STACKS));
    }

    public boolean areFileVDFAllowed() {
        return Boolean.parseBoolean(this.getProperty(VDF_FROM_FILESYSTEM));
    }

    static {
        KDC_PORT = new ConfigurationProperty<String>("default.kdcserver.port", "88");
        KDC_CONNECTION_CHECK_TIMEOUT = new ConfigurationProperty<Integer>("kdcserver.connection.check.timeout", 10000);
        KERBEROSTAB_CACHE_DIR = new ConfigurationProperty<String>("kerberos.keytab.cache.dir", AmbariPath.getPath("/var/lib/obdp-server/data/cache"));
        KERBEROS_CHECK_JAAS_CONFIGURATION = new ConfigurationProperty<Boolean>("kerberos.check.jaas.configuration", Boolean.FALSE);
        RECOVERY_TYPE = new ConfigurationProperty<Object>("recovery.type", null);
        RECOVERY_LIFETIME_MAX_COUNT = new ConfigurationProperty<Object>("recovery.lifetime_max_count", null);
        RECOVERY_MAX_COUNT = new ConfigurationProperty<Object>("recovery.max_count", null);
        RECOVERY_WINDOW_IN_MIN = new ConfigurationProperty<Object>("recovery.window_in_minutes", null);
        RECOVERY_RETRY_GAP = new ConfigurationProperty<Object>("recovery.retry_interval", null);
        RECOVERY_DISABLED_COMPONENTS = new ConfigurationProperty<Object>("recovery.disabled_components", null);
        RECOVERY_ENABLED_COMPONENTS = new ConfigurationProperty<Object>("recovery.enabled_components", null);
        PROXY_ALLOWED_HOST_PORTS = new ConfigurationProperty<String>("proxy.allowed.hostports", "*:*");
        PARALLEL_STAGE_EXECUTION = new ConfigurationProperty<Boolean>("server.stages.parallel", Boolean.TRUE);
        VIEW_EXTRACT_AFTER_CLUSTER_CONFIG = new ConfigurationProperty<Boolean>("view.extract-after-cluster-config", Boolean.FALSE);
        COMMAND_EXECUTION_TYPE = new ConfigurationProperty<String>("server.stage.command.execution_type", CommandExecutionType.STAGE.toString());
        AGENT_TASK_TIMEOUT = new ConfigurationProperty<Long>("agent.task.timeout", 900L);
        AGENT_SERVICE_CHECK_TASK_TIMEOUT = new ConfigurationProperty<Long>("agent.service.check.task.timeout", 0L);
        AGENT_PACKAGE_INSTALL_TASK_TIMEOUT = new ConfigurationProperty<Long>("agent.package.install.task.timeout", 1800L);
        AGENT_PACKAGE_PARALLEL_COMMANDS_LIMIT = new ConfigurationProperty<Integer>("agent.package.parallel.commands.limit", 100);
        SERVER_TASK_TIMEOUT = new ConfigurationProperty<Integer>("server.task.timeout", 1200);
        HOOKS_FOLDER = new ConfigurationProperty<String>("stack.hooks.folder", "stack-hooks");
        CUSTOM_ACTION_DEFINITION = new ConfigurationProperty<String>("custom.action.definitions", AmbariPath.getPath("/var/lib/obdp-server/resources/custom_action_definitions"));
        SHARED_RESOURCES_DIR = new ConfigurationProperty<String>("shared.resources.dir", AmbariPath.getPath("/usr/lib/obdp-server/lib/obdp_commons/resources"));
        ANONYMOUS_AUDIT_NAME = new ConfigurationProperty<String>("anonymous.audit.name", "_anonymous");
        SYS_PREPPED_HOSTS = new ConfigurationProperty<String>("packages.pre.installed", "false");
        LEGACY_OVERRIDE = new ConfigurationProperty<String>("repositories.legacy-override.enabled", "false");
        SERVER_CONNECTION_MAX_IDLE_TIME = new ConfigurationProperty<Integer>("server.connection.max.idle.millis", 900000);
        CLIENT_THREADPOOL_SIZE = new ConfigurationProperty<Integer>("client.threadpool.size.max", 25);
        AGENT_THREADPOOL_SIZE = new ConfigurationProperty<Integer>("agent.threadpool.size.max", 25);
        MESSAGING_THREAD_POOL_SIZE = new ConfigurationProperty<Integer>("messaging.threadpool.size", 10);
        REGISTRATION_THREAD_POOL_SIZE = new ConfigurationProperty<Integer>("registration.threadpool.size", 10);
        SUBSCRIPTION_REGISTRY_CACHE_MAX_SIZE = new ConfigurationProperty<Integer>("subscription.registry.cache.size", 1500);
        AGENTS_REGISTRATION_QUEUE_SIZE = new ConfigurationProperty<Integer>("agents.registration.queue.size", 200);
        AGENTS_REPORT_PROCESSING_PERIOD = new ConfigurationProperty<Integer>("agents.reports.processing.period", 1);
        AGENTS_REPORT_PROCESSING_START_TIMEOUT = new ConfigurationProperty<Integer>("agents.reports.processing.start.timeout", 5);
        AGENTS_REPORT_THREAD_POOL_SIZE = new ConfigurationProperty<Integer>("agents.reports.thread.pool.size", 10);
        API_HEARTBEAT_INTERVAL = new ConfigurationProperty<Integer>("api.heartbeat.interval", 10000);
        STOMP_MAX_INCOMING_MESSAGE_SIZE = new ConfigurationProperty<Integer>("stomp.max_incoming.message.size", 0x200000);
        STOMP_MAX_BUFFER_MESSAGE_SIZE = new ConfigurationProperty<Integer>("stomp.max_buffer.message.size", 0x500000);
        EXECUTION_COMMANDS_RETRY_COUNT = new ConfigurationProperty<Integer>("execution.command.retry.count", 4);
        EXECUTION_COMMANDS_RETRY_INTERVAL = new ConfigurationProperty<Integer>("execution.command.retry.interval", 15);
        VIEW_EXTRACTION_THREADPOOL_MAX_SIZE = new ConfigurationProperty<Integer>("view.extraction.threadpool.size.max", 20);
        VIEW_EXTRACTION_THREADPOOL_CORE_SIZE = new ConfigurationProperty<Integer>("view.extraction.threadpool.size.core", 10);
        VIEW_EXTRACTION_THREADPOOL_TIMEOUT = new ConfigurationProperty<Long>("view.extraction.threadpool.timeout", 100000L);
        VIEW_REQUEST_THREADPOOL_MAX_SIZE = new ConfigurationProperty<Integer>("view.request.threadpool.size.max", 0);
        VIEW_REQUEST_THREADPOOL_TIMEOUT = new ConfigurationProperty<Integer>("view.request.threadpool.timeout", 2000);
        PROPERTY_PROVIDER_THREADPOOL_MAX_SIZE = new ConfigurationProperty<Integer>("server.property-provider.threadpool.size.max", PROCESSOR_BASED_THREADPOOL_MAX_SIZE_DEFAULT);
        PROPERTY_PROVIDER_THREADPOOL_CORE_SIZE = new ConfigurationProperty<Integer>("server.property-provider.threadpool.size.core", PROCESSOR_BASED_THREADPOOL_CORE_SIZE_DEFAULT);
        PROPERTY_PROVIDER_THREADPOOL_WORKER_QUEUE_SIZE = new ConfigurationProperty<Integer>("server.property-provider.threadpool.worker.size", Integer.MAX_VALUE);
        PROPERTY_PROVIDER_THREADPOOL_COMPLETION_TIMEOUT = new ConfigurationProperty<Long>("server.property-provider.threadpool.completion.timeout", 5000L);
        SERVER_HTTP_SESSION_INACTIVE_TIMEOUT = new ConfigurationProperty<Integer>("server.http.session.inactive_timeout", 1800);
        TIMELINE_METRICS_CACHE_DISABLE = new ConfigurationProperty<Boolean>("server.timeline.metrics.cache.disabled", Boolean.FALSE);
        TIMELINE_METRICS_CACHE_TTL = new ConfigurationProperty<Integer>("server.timeline.metrics.cache.entry.ttl.seconds", 3600);
        TIMELINE_METRICS_CACHE_IDLE_TIME = new ConfigurationProperty<Integer>("server.timeline.metrics.cache.entry.idle.seconds", 1800);
        TIMELINE_METRICS_CACHE_ENTRY_UNIT_SIZE = new ConfigurationProperty<Integer>("server.timeline.metrics.cache.entry.entry.unit.size", 100);
        TIMELINE_METRICS_REQUEST_READ_TIMEOUT = new ConfigurationProperty<Integer>("server.timeline.metrics.cache.read.timeout.millis", 10000);
        TIMELINE_METRICS_REQUEST_INTERVAL_READ_TIMEOUT = new ConfigurationProperty<Integer>("server.timeline.metrics.cache.interval.read.timeout.millis", 10000);
        TIMELINE_METRICS_REQUEST_CONNECT_TIMEOUT = new ConfigurationProperty<Integer>("server.timeline.metrics.cache.connect.timeout.millis", 5000);
        TIMELINE_METRICS_REQUEST_CATCHUP_INTERVAL = new ConfigurationProperty<Long>("server.timeline.metrics.cache.catchup.interval", 300000L);
        TIMELINE_METRICS_CACHE_HEAP_PERCENT = new ConfigurationProperty<String>("server.timeline.metrics.cache.heap.percent", "15%");
        TIMELINE_METRICS_CACHE_USE_CUSTOM_SIZING_ENGINE = new ConfigurationProperty<Boolean>("server.timeline.metrics.cache.use.custom.sizing.engine", Boolean.TRUE);
        AMBARI_METRICS_HTTPS_ENABLED = new ConfigurationProperty<Boolean>("server.timeline.metrics.https.enabled", Boolean.FALSE);
        ALERT_TEMPLATE_FILE = new ConfigurationProperty<Object>("alerts.template.file", null);
        ALERTS_EXECUTION_SCHEDULER_THREADS_CORE_SIZE = new ConfigurationProperty<Integer>("alerts.execution.scheduler.threadpool.size.core", 2);
        ALERTS_EXECUTION_SCHEDULER_THREADS_MAX_SIZE = new ConfigurationProperty<Integer>("alerts.execution.scheduler.threadpool.size.max", 2);
        ALERTS_EXECUTION_SCHEDULER_WORKER_QUEUE_SIZE = new ConfigurationProperty<Integer>("alerts.execution.scheduler.threadpool.worker.size", 2000);
        ALERTS_CACHE_ENABLED = new ConfigurationProperty<Boolean>("alerts.cache.enabled", Boolean.FALSE);
        ALERTS_CACHE_FLUSH_INTERVAL = new ConfigurationProperty<Integer>("alerts.cache.flush.interval", 10);
        ALERTS_CACHE_SIZE = new ConfigurationProperty<Integer>("alerts.cache.size", 50000);
        HTTP_STRICT_TRANSPORT_HEADER_VALUE = new ConfigurationProperty<String>("http.strict-transport-security", "max-age=31536000");
        HTTP_X_FRAME_OPTIONS_HEADER_VALUE = new ConfigurationProperty<String>("http.x-frame-options", "DENY");
        HTTP_X_XSS_PROTECTION_HEADER_VALUE = new ConfigurationProperty<String>("http.x-xss-protection", "1; mode=block");
        HTTP_CONTENT_SECURITY_POLICY_HEADER_VALUE = new ConfigurationProperty<String>("http.content-security-policy", JDBC_IN_MEMORY_PASSWORD);
        HTTP_X_CONTENT_TYPE_HEADER_VALUE = new ConfigurationProperty<String>("http.x-content-type-options", "nosniff");
        HTTP_CACHE_CONTROL_HEADER_VALUE = new ConfigurationProperty<String>("http.cache-control", "no-store");
        HTTP_PRAGMA_HEADER_VALUE = new ConfigurationProperty<String>("http.pragma", "no-cache");
        HTTP_CHARSET = new ConfigurationProperty<String>("http.charset", "utf-8");
        VIEWS_HTTP_STRICT_TRANSPORT_HEADER_VALUE = new ConfigurationProperty<String>("views.http.strict-transport-security", "max-age=31536000");
        VIEWS_HTTP_X_FRAME_OPTIONS_HEADER_VALUE = new ConfigurationProperty<String>("views.http.x-frame-options", "SAMEORIGIN");
        VIEWS_HTTP_X_XSS_PROTECTION_HEADER_VALUE = new ConfigurationProperty<String>("views.http.x-xss-protection", "1; mode=block");
        VIEWS_HTTP_CONTENT_SECURITY_POLICY_HEADER_VALUE = new ConfigurationProperty<String>("views.http.content-security-policy", JDBC_IN_MEMORY_PASSWORD);
        VIEWS_HTTP_X_CONTENT_TYPE_HEADER_VALUE = new ConfigurationProperty<String>("views.http.x-content-type-options", "nosniff");
        VIEWS_HTTP_CACHE_CONTROL_HEADER_VALUE = new ConfigurationProperty<String>("views.http.cache-control", "no-store");
        VIEWS_ADDITIONAL_CLASSPATH_VALUE = new ConfigurationProperty<String>("views.additional.classpath", JDBC_IN_MEMORY_PASSWORD);
        VIEWS_HTTP_PRAGMA_HEADER_VALUE = new ConfigurationProperty<String>("views.http.pragma", "no-cache");
        VIEWS_HTTP_CHARSET = new ConfigurationProperty<String>("views.http.charset", "utf-8");
        VERSION_DEFINITION_CONNECT_TIMEOUT = new ConfigurationProperty<Integer>("server.version_definition.connect.timeout.millis", 5000);
        VERSION_DEFINITION_READ_TIMEOUT = new ConfigurationProperty<Integer>("server.version_definition.read.timeout.millis", 5000);
        AGENT_STACK_RETRY_ON_REPO_UNAVAILABILITY = new ConfigurationProperty<Boolean>("agent.stack.retry.on_repo_unavailability", Boolean.FALSE);
        AGENT_STACK_RETRY_COUNT = new ConfigurationProperty<Integer>("agent.stack.retry.tries", 5);
        AUDIT_LOG_ENABLED = new ConfigurationProperty<Boolean>("auditlog.enabled", Boolean.TRUE);
        AUDIT_LOGGER_CAPACITY = new ConfigurationProperty<Integer>("auditlog.logger.capacity", 10000);
        ALERTS_SNMP_DISPATCH_UDP_PORT = new ConfigurationProperty<Object>("alerts.snmp.dispatcher.udp.port", null);
        ALERTS_AMBARI_SNMP_DISPATCH_UDP_PORT = new ConfigurationProperty<Object>("alerts.ambari.snmp.dispatcher.udp.port", null);
        METRIC_RETRIEVAL_SERVICE_CACHE_TIMEOUT = new ConfigurationProperty<Integer>("metrics.retrieval-service.cache.timeout", 30);
        METRIC_RETRIEVAL_SERVICE_THREAD_PRIORITY = new ConfigurationProperty<Integer>("server.metrics.retrieval-service.thread.priority", 5);
        METRIC_RETRIEVAL_SERVICE_THREADPOOL_MAX_SIZE = new ConfigurationProperty<Integer>("server.metrics.retrieval-service.threadpool.size.max", PROCESSOR_BASED_THREADPOOL_MAX_SIZE_DEFAULT);
        METRIC_RETRIEVAL_SERVICE_THREADPOOL_CORE_SIZE = new ConfigurationProperty<Integer>("server.metrics.retrieval-service.threadpool.size.core", PROCESSOR_BASED_THREADPOOL_CORE_SIZE_DEFAULT);
        METRIC_RETRIEVAL_SERVICE_THREADPOOL_WORKER_QUEUE_SIZE = new ConfigurationProperty<Integer>("server.metrics.retrieval-service.threadpool.worker.size", 10 * METRIC_RETRIEVAL_SERVICE_THREADPOOL_MAX_SIZE.getDefaultValue());
        METRIC_RETRIEVAL_SERVICE_REQUEST_TTL_ENABLED = new ConfigurationProperty<Boolean>("metrics.retrieval-service.request.ttl.enabled", Boolean.TRUE);
        METRIC_RETRIEVAL_SERVICE_REQUEST_TTL = new ConfigurationProperty<Integer>("metrics.retrieval-service.request.ttl", 5);
        ACTIVE_INSTANCE = new ConfigurationProperty<Boolean>("active.instance", Boolean.TRUE);
        POST_USER_CREATION_HOOK_ENABLED = new ConfigurationProperty<Boolean>("ambari.post.user.creation.hook.enabled", Boolean.FALSE);
        POST_USER_CREATION_HOOK = new ConfigurationProperty<String>("ambari.post.user.creation.hook", "/var/lib/obdp-server/resources/scripts/post-user-creation-hook.sh");
        LOG4JMONITOR_DELAY = new ConfigurationProperty<Long>("log4j.monitor.delay", TimeUnit.MINUTES.toMillis(5L));
        TOPOLOGY_TASK_PARALLEL_CREATION_ENABLED = new ConfigurationProperty<Boolean>("topology.task.creation.parallel", Boolean.FALSE);
        TOPOLOGY_TASK_PARALLEL_CREATION_THREAD_COUNT = new ConfigurationProperty<Integer>("topology.task.creation.parallel.threads", 10);
        SRVR_AGENT_ACCEPTOR_THREAD_COUNT = new ConfigurationProperty<Object>("agent.api.acceptor.count", null);
        SRVR_API_ACCEPTOR_THREAD_COUNT = new ConfigurationProperty<Object>("client.api.acceptor.count", null);
        LOGSEARCH_PORTAL_CONNECT_TIMEOUT = new ConfigurationProperty<Integer>("logsearch.portal.connect.timeout", 5000);
        LOGSEARCH_PORTAL_READ_TIMEOUT = new ConfigurationProperty<Integer>("logsearch.portal.read.timeout", 5000);
        LOGSEARCH_PORTAL_EXTERNAL_ADDRESS = new ConfigurationProperty<String>("logsearch.portal.external.address", JDBC_IN_MEMORY_PASSWORD);
        AMBARISERVER_METRICS_DISABLE = new ConfigurationProperty<Boolean>("ambariserver.metrics.disable", false);
        LOGSEARCH_METADATA_CACHE_EXPIRE_TIMEOUT = new ConfigurationProperty<Integer>("logsearch.metadata.cache.expire.timeout", 24);
        SERVER_STARTUP_WEB_TIMEOUT = new ConfigurationProperty<Integer>("server.startup.web.timeout", 50);
        TLS_EPHEMERAL_DH_KEY_SIZE = new ConfigurationProperty<Integer>("security.server.tls.ephemeral_dh_key_size", 2048);
        DISPATCH_PROPERTY_SCRIPT_DIRECTORY = new ConfigurationProperty<String>("notification.dispatch.alert.script.directory", AmbariPath.getPath("/var/lib/obdp-server/resources/scripts"));
        SECURITY_PASSWORD_ENCRYPTON_ENABLED = new ConfigurationProperty<Boolean>("security.passwords.encryption.enabled", false);
        SECURITY_SENSITIVE_DATA_ENCRYPTON_ENABLED = new ConfigurationProperty<Boolean>("security.server.encrypt_sensitive_data", false);
        MAX_LOCAL_AUTHENTICATION_FAILURES = new ConfigurationProperty<Integer>("authentication.local.max.failures", 0);
        SHOW_LOCKED_OUT_USER_MESSAGE = new ConfigurationProperty<String>("authentication.local.show.locked.account.messages", "false");
        SERVER_SIDE_ALERTS_CORE_POOL_SIZE = new ConfigurationProperty<Integer>("alerts.server.side.scheduler.threadpool.size.core", 4);
        DEFAULT_MAX_DEGREE_OF_PARALLELISM_FOR_UPGRADES = new ConfigurationProperty<Integer>("stack.upgrade.default.parallelism", 100);
        KERBEROS_SERVER_ACTION_FINALIZE_SECONDS = new ConfigurationProperty<Integer>("server.kerberos.finalize.timeout", 600);
        KERBEROS_SERVER_ACTION_THREADPOOL_SIZE = new ConfigurationProperty<Integer>("server.kerberos.action.threadpool.size", 1);
        AGENT_COMMAND_PUBLISHER_THREADPOOL_SIZE = new ConfigurationProperty<Integer>("server.pools.agent.command.publisher.size", 5);
        DEFAULT_FORK_JOIN_THREADPOOL_SIZE = new ConfigurationProperty<Integer>("server.pools.default.size", 5);
        SERVER_SHOW_ERROR_STACKS = new ConfigurationProperty<String>("server.show.error.stacks", "false");
        ADD_SERVICE_HOST_GROUP_STRATEGY = new ConfigurationProperty<String>("addservice.hostgroup.strategy", GroupByComponentsStrategy.class.getName());
        VDF_FROM_FILESYSTEM = new ConfigurationProperty<Boolean>("server.version_definition.allow_from_filesystem", Boolean.FALSE);
        LOG = LoggerFactory.getLogger(Configuration.class);
        if (System.getProperty("os.name").contains("Windows")) {
            DEF_ARCHIVE_EXTENSION = ".zip";
            DEF_ARCHIVE_CONTENT_TYPE = "application/zip";
        } else {
            DEF_ARCHIVE_EXTENSION = ".tar.gz";
            DEF_ARCHIVE_CONTENT_TYPE = "application/x-ustar";
        }
    }

    public static class ConfigurationProperty<T>
    implements Comparable<ConfigurationProperty<?>> {
        private final String m_key;
        private final T m_defaultValue;

        private ConfigurationProperty(String key, T defaultValue) {
            this.m_key = key;
            this.m_defaultValue = defaultValue;
        }

        public String getKey() {
            return this.m_key;
        }

        public T getDefaultValue() {
            return this.m_defaultValue;
        }

        public int hashCode() {
            return this.m_key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigurationProperty other = (ConfigurationProperty)obj;
            return StringUtils.equals((String)this.m_key, (String)other.m_key);
        }

        public String toString() {
            return this.m_key;
        }

        @Override
        public int compareTo(ConfigurationProperty<?> o) {
            return this.m_key.compareTo(o.m_key);
        }
    }

    public static enum LdapUsernameCollisionHandlingBehavior {
        ADD,
        CONVERT,
        SKIP;


        public static LdapUsernameCollisionHandlingBehavior translate(String value, LdapUsernameCollisionHandlingBehavior defaultValue) {
            String processedValue = StringUtils.upperCase((String)StringUtils.trim((String)value));
            if (StringUtils.isEmpty((String)processedValue)) {
                return defaultValue;
            }
            try {
                return LdapUsernameCollisionHandlingBehavior.valueOf(processedValue);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Invalid LDAP username collision value ({}), using the default value ({})", (Object)value, (Object)defaultValue.name().toLowerCase());
                return defaultValue;
            }
        }
    }

    public static enum DatabaseType {
        POSTGRES("postgres"),
        ORACLE("oracle"),
        MYSQL("mysql"),
        DERBY("derby"),
        SQL_SERVER("sqlserver"),
        SQL_ANYWHERE("sqlanywhere"),
        H2("h2");

        private static final Map<String, DatabaseType> m_mappedTypes;
        private String m_databaseType;

        private DatabaseType(String databaseType) {
            this.m_databaseType = databaseType;
        }

        public String getName() {
            return this.m_databaseType;
        }

        public DatabaseType get(String databaseTypeName) {
            return m_mappedTypes.get(databaseTypeName);
        }

        static {
            m_mappedTypes = new HashMap<String, DatabaseType>(5);
            for (DatabaseType databaseType : EnumSet.allOf(DatabaseType.class)) {
                m_mappedTypes.put(databaseType.getName(), databaseType);
            }
        }
    }

    public static enum ConnectionPoolType {
        INTERNAL("internal"),
        C3P0("c3p0");

        private String m_name;

        private ConnectionPoolType(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }
    }

    public static enum ConfigurationGrouping {
        ALERTS("Alerts & Notifications"),
        JETTY_THREAD_POOL("Jetty API & Agent Thread Pools");

        private String m_description;

        private ConfigurationGrouping(String description) {
            this.m_description = description;
        }

        public String toString() {
            return this.m_description;
        }
    }

    public static enum ClusterSizeType {
        HOSTS_10("10 Hosts"),
        HOSTS_50("~50 Hosts"),
        HOSTS_100("~100 Hosts"),
        HOSTS_500("500+ Hosts");

        private String m_description;

        private ClusterSizeType(String description) {
            this.m_description = description;
        }

        public String toString() {
            return this.m_description;
        }
    }
}

