/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.configuration;

import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.utils.PasswordUtils;

public class ComponentSSLConfiguration {
    private String truststorePath;
    private String truststorePassword;
    private String truststoreType;
    private boolean httpsEnabled;
    private static ComponentSSLConfiguration singleton = new ComponentSSLConfiguration();

    protected ComponentSSLConfiguration() {
    }

    public void init(Configuration configuration) {
        this.truststorePath = configuration.getProperty(Configuration.SSL_TRUSTSTORE_PATH.getKey());
        this.truststorePassword = this.getPassword(configuration);
        this.truststoreType = configuration.getProperty(Configuration.SSL_TRUSTSTORE_TYPE.getKey());
        this.httpsEnabled = Boolean.parseBoolean(configuration.getProperty(Configuration.AMBARI_METRICS_HTTPS_ENABLED.getKey()));
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public static ComponentSSLConfiguration instance() {
        return singleton;
    }

    private String getPassword(Configuration configuration) {
        String rawPassword = configuration.getProperty(Configuration.SSL_TRUSTSTORE_PASSWORD.getKey());
        String password = PasswordUtils.getInstance().readPasswordFromStore(rawPassword, configuration);
        return password == null ? rawPassword : password;
    }
}

