/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.collections.functors;

import id.onyx.obdp.server.collections.functors.ContextTransformer;
import id.onyx.obdp.server.collections.functors.OperationPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.functors.EqualPredicate;

public class EqualsPredicate
extends OperationPredicate {
    public static final String NAME = "equals";
    private final EqualPredicate delegate;

    public static EqualsPredicate fromMap(Map<String, Object> map) {
        Object data;
        Object object = data = map == null ? null : map.get(NAME);
        if (data == null) {
            throw new IllegalArgumentException("Missing data for 'equals' operation");
        }
        if (data instanceof Collection) {
            Collection collection = (Collection)data;
            if (collection.size() == 2) {
                Iterator iterator = collection.iterator();
                Object d1 = iterator.next();
                Object d2 = iterator.next();
                if (d1 instanceof String && d2 instanceof String) {
                    return new EqualsPredicate(new ContextTransformer((String)d1), (String)d2);
                }
                throw new IllegalArgumentException(String.format("Unexpected data types: %s and %s", d1.getClass().getName(), d2.getClass().getName()));
            }
            throw new IllegalArgumentException(String.format("Missing data for 'equals' operation - 2 predicates are needed, %d found", collection.size()));
        }
        throw new IllegalArgumentException(String.format("Unexpected data type for 'equals' operation - %s", data.getClass().getName()));
    }

    public EqualsPredicate(ContextTransformer transformer, String value) {
        super(NAME, transformer);
        this.delegate = new EqualPredicate((Object)value);
    }

    public String getValue() {
        Object o = this.delegate == null ? null : this.delegate.getValue();
        return o == null ? null : o.toString();
    }

    @Override
    public Map<String, Object> toMap() {
        return Collections.singletonMap(NAME, new ArrayList<String>(Arrays.asList(this.getContextKey(), this.delegate.getValue().toString())));
    }

    @Override
    public boolean evaluateTransformedData(Object data) {
        return this.delegate.evaluate(data);
    }
}

