/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.collections.functors;

import java.util.Map;
import org.apache.commons.collections4.Transformer;

public class ContextTransformer
implements Transformer {
    private final String key;

    public ContextTransformer(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public Object transform(Object o) {
        return this.transform(this.key, o);
    }

    private Object transform(String key, Object o) {
        Object transformedData = null;
        if (key != null && o instanceof Map) {
            Map data = (Map)o;
            if (data.containsKey(key)) {
                transformedData = data.get(key);
            } else {
                String[] parts = key.split("\\/", 2);
                if (parts.length == 2) {
                    transformedData = parts[0].isEmpty() ? this.transform(parts[1], o) : this.transform(parts[1], data.get(parts[0]));
                }
            }
        }
        return transformedData;
    }

    public int hashCode() {
        return 37 * (this.key == null ? 0 : this.key.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ContextTransformer && this.hashCode() == obj.hashCode()) {
            ContextTransformer t = (ContextTransformer)obj;
            return this.key == null ? t.key == null : this.key.equals(t.key);
        }
        return false;
    }
}

