/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.collections.functors;

import id.onyx.obdp.server.collections.functors.ContextTransformer;
import id.onyx.obdp.server.collections.functors.OperationPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ContainsPredicate
extends OperationPredicate {
    public static final String NAME = "contains";
    private final String value;

    public static ContainsPredicate fromMap(Map<String, Object> map) {
        Object data;
        Object object = data = map == null ? null : map.get(NAME);
        if (data == null) {
            throw new IllegalArgumentException("Missing data for 'contains' operation");
        }
        if (data instanceof Collection) {
            Collection collection = (Collection)data;
            if (collection.size() == 2) {
                Iterator iterator = collection.iterator();
                Object d1 = iterator.next();
                Object d2 = iterator.next();
                if (d1 instanceof String && d2 instanceof String) {
                    return new ContainsPredicate(new ContextTransformer((String)d1), (String)d2);
                }
                throw new IllegalArgumentException(String.format("Unexpected data types: %s and %s", d1.getClass().getName(), d2.getClass().getName()));
            }
            throw new IllegalArgumentException(String.format("Missing data for 'contains' operation - 2 predicates are needed, %d found", collection.size()));
        }
        throw new IllegalArgumentException(String.format("Unexpected data type for 'contains' operation - %s", data.getClass().getName()));
    }

    public ContainsPredicate(ContextTransformer transformer, String value) {
        super(NAME, transformer);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    protected boolean evaluateTransformedData(Object data) {
        return this.value != null && data instanceof Set && ((Set)data).contains(this.value);
    }

    @Override
    public Map<String, Object> toMap() {
        return Collections.singletonMap(NAME, new ArrayList<String>(Arrays.asList(this.getContextKey(), this.value)));
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * (this.value == null ? 0 : this.value.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (super.equals(obj) && obj instanceof ContainsPredicate && this.hashCode() == obj.hashCode()) {
            ContainsPredicate p = (ContainsPredicate)obj;
            return this.value == null ? p.value == null : this.value.equals(p.value);
        }
        return false;
    }
}

