/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.collections;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import id.onyx.obdp.server.collections.Predicate;
import id.onyx.obdp.server.collections.functors.PredicateClassFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class PredicateUtils {
    private static final Type PARSED_TYPE = new TypeToken<Map<String, Object>>(){}.getType();

    public static Map<String, Object> toMap(Predicate predicate) {
        return predicate == null ? null : predicate.toMap();
    }

    public static Predicate fromMap(Map<?, ?> map) {
        Predicate predicate = null;
        if (map != null && !map.isEmpty()) {
            if (map.size() == 1) {
                Map.Entry<?, ?> entry = map.entrySet().iterator().next();
                String name = Objects.toString(entry.getKey());
                Class<? extends Predicate> predicateClass = PredicateClassFactory.getPredicateClass(name);
                if (predicateClass == null) {
                    throw new IllegalArgumentException(String.format("Unexpected predicate name - %s", name));
                }
                try {
                    Method method = predicateClass.getMethod("fromMap", Map.class);
                    if (method == null) {
                        throw new UnsupportedOperationException(String.format("Cannot translate data to a %s - %s", predicateClass.getName(), "Failed to find toMap method"));
                    }
                    predicate = (Predicate)method.invoke(null, Collections.singletonMap(name, entry.getValue()));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new UnsupportedOperationException(String.format("Cannot translate data to a %s - %s", predicateClass.getName(), e.getLocalizedMessage()), e);
                }
            } else {
                throw new IllegalArgumentException(String.format("Too many map entries have been encountered - %d", map.size()));
            }
        }
        return predicate;
    }

    public static String toJSON(Predicate predicate) {
        return predicate == null ? null : predicate.toJSON();
    }

    public static Predicate fromJSON(String json) {
        Map map = (Map)new Gson().fromJson(json, PARSED_TYPE);
        return StringUtils.isEmpty((String)json) ? null : PredicateUtils.fromMap(map);
    }
}

