/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.cleanup;

import com.google.inject.Singleton;
import id.onyx.obdp.server.cleanup.CleanupService;
import id.onyx.obdp.server.cleanup.TimeBasedCleanupPolicy;
import id.onyx.obdp.server.orm.dao.Cleanable;
import jakarta.inject.Inject;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CleanupServiceImpl
implements CleanupService<TimeBasedCleanupPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanupServiceImpl.class);
    private Set<Cleanable> cleanables;

    @Inject
    protected CleanupServiceImpl(Set<Cleanable> cleanables) {
        this.cleanables = cleanables;
    }

    @Override
    public CleanupService.CleanupResult cleanup(TimeBasedCleanupPolicy cleanupPolicy) {
        long affectedRows = 0L;
        int errorCount = 0;
        for (Cleanable cleanable : this.cleanables) {
            LOGGER.info("Running the purge process for DAO: [{}] with cleanup policy: [{}]", (Object)cleanable, (Object)cleanupPolicy);
            try {
                affectedRows += cleanable.cleanup(cleanupPolicy);
            }
            catch (Exception ex) {
                LOGGER.error("Running the purge process for DAO: [{}] failed with: {}", (Object)cleanable, (Object)ex);
                ++errorCount;
            }
        }
        return new Result(affectedRows, errorCount);
    }

    class Result
    implements CleanupService.CleanupResult {
        private final long affectedRows;
        private final int errorCount;

        public Result(long affectedRows, int errorCount) {
            this.affectedRows = affectedRows;
            this.errorCount = errorCount;
        }

        @Override
        public long getAffectedRows() {
            return this.affectedRows;
        }

        @Override
        public int getErrorCount() {
            return this.errorCount;
        }
    }
}

