/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.cleanup;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import id.onyx.obdp.server.cleanup.ClasspathScannerUtils;
import id.onyx.obdp.server.cleanup.CleanupServiceImpl;
import id.onyx.obdp.server.orm.dao.Cleanable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupModule.class);

    protected List<Class<?>> getSelectors() {
        ArrayList selectorList = new ArrayList();
        selectorList.add(Cleanable.class);
        return selectorList;
    }

    protected List<Class<?>> getExclusions() {
        return Collections.emptyList();
    }

    protected String getPackageToScan() {
        return Cleanable.class.getPackage().getName();
    }

    protected void configure() {
        Multibinder multiBinder = Multibinder.newSetBinder((Binder)this.binder(), Cleanable.class);
        Set<Class<?>> bindingSet = ClasspathScannerUtils.findOnClassPath(this.getPackageToScan(), this.getExclusions(), this.getSelectors());
        for (Class<?> clazz : bindingSet) {
            LOG.info("Binding cleaner {}", clazz);
            multiBinder.addBinding().to(clazz).in(Scopes.SINGLETON);
        }
        this.bind(CleanupServiceImpl.class).in(Scopes.SINGLETON);
    }
}

