/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.cleanup;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.persist.jpa.OBDPJpaPersistService;
import id.onyx.obdp.server.audit.AuditLoggerModule;
import id.onyx.obdp.server.cleanup.CleanupModule;
import id.onyx.obdp.server.cleanup.CleanupService;
import id.onyx.obdp.server.cleanup.CleanupServiceImpl;
import id.onyx.obdp.server.cleanup.TimeBasedCleanupPolicy;
import id.onyx.obdp.server.controller.ControllerModule;
import id.onyx.obdp.server.ldap.LdapModule;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanupDriver.class);
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String CLUSTER_NAME_ARG = "cluster-name";
    private static final String FROM_DATE_ARG = "from-date";

    private static Options getOptions() {
        Options options = new Options();
        options.addOption(Option.builder().longOpt(CLUSTER_NAME_ARG).desc("The cluster name").required().type(String.class).hasArg().valueSeparator(' ').build());
        options.addOption(Option.builder().longOpt(FROM_DATE_ARG).desc("Date up until data will be purged.").required().type(String.class).hasArg().valueSeparator(' ').build());
        return options;
    }

    private static CleanupContext processArguments(String ... args) {
        DefaultParser cmdLineParser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN);
        CleanupContext ctx = null;
        try {
            CommandLine line = cmdLineParser.parse(CleanupDriver.getOptions(), args);
            String clusterName = (String)line.getParsedOptionValue(CLUSTER_NAME_ARG);
            Date fromDate = df.parse(line.getOptionValue(FROM_DATE_ARG));
            ctx = new CleanupContext(clusterName, fromDate.getTime());
        }
        catch (Exception exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            LOGGER.error("Parsing failed.  Reason: ", (Throwable)exp);
            formatter.printHelp("db-purge-history", CleanupDriver.getOptions());
            System.exit(1);
        }
        return ctx;
    }

    public static void main(String ... args) throws Exception {
        LOGGER.info("DB-PURGE - Starting the database purge process ...");
        CleanupContext cleanupContext = CleanupDriver.processArguments(args);
        Injector injector = Guice.createInjector((Module[])new Module[]{new ControllerModule(), new AuditLoggerModule(), new CleanupModule(), new LdapModule()});
        ((OBDPJpaPersistService)((Object)injector.getInstance(OBDPJpaPersistService.class))).start();
        CleanupServiceImpl cleanupService = (CleanupServiceImpl)injector.getInstance(CleanupServiceImpl.class);
        CleanupService.CleanupResult result = cleanupService.cleanup(new TimeBasedCleanupPolicy(cleanupContext.getClusterName(), cleanupContext.getFromDayTimestamp()));
        ((OBDPJpaPersistService)((Object)injector.getInstance(OBDPJpaPersistService.class))).stop();
        if (result.getErrorCount() > 0) {
            LOGGER.warn("DB-PURGE - completed with error, check Ambari Server log for details ! Number of affected records [{}]", (Object)result.getAffectedRows());
            System.exit(2);
        }
        LOGGER.info("DB-PURGE - completed. Number of affected records [{}]", (Object)result.getAffectedRows());
    }

    private static class CleanupContext {
        private String clusterName;
        private Long fromDayTimestamp;

        public CleanupContext(String clusterName, Long fromDayTimestamp) {
            this.clusterName = clusterName;
            this.fromDayTimestamp = fromDayTimestamp;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public Long getFromDayTimestamp() {
            return this.fromDayTimestamp;
        }
    }
}

