/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.cleanup;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScannerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathScannerUtils.class);

    public static Set<Class<?>> findOnClassPath(String packageName, List<Class<?>> exclusions, List<Class<?>> selectors) {
        return ClasspathScannerUtils.findOnClassPath(ClasspathScannerUtils.class.getClassLoader(), packageName, exclusions, selectors);
    }

    public static Set<Class<?>> findOnClassPath(ClassLoader classLoader, String packageName, List<Class<?>> exclusions, List<Class<?>> selectors) {
        LinkedHashSet bindingSet = new LinkedHashSet();
        try {
            ClassPath classpath = ClassPath.from((ClassLoader)classLoader);
            LOGGER.info("Checking package [{}] for binding candidates.", (Object)packageName);
            for (ClassPath.ClassInfo classInfo : classpath.getTopLevelClassesRecursive(packageName)) {
                Class candidate = classInfo.load();
                if (exclusions.contains(candidate)) {
                    LOGGER.debug("Candidate [{}] is excluded excluded.", (Object)candidate);
                    continue;
                }
                if (ClasspathScannerUtils.isEligible(candidate, selectors)) {
                    LOGGER.debug("Found class [{}]", (Object)candidate);
                    bindingSet.add(candidate);
                    continue;
                }
                LOGGER.debug("Candidate [{}] doesn't match.", (Object)candidate);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failure during configuring JUICE bindings.", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return bindingSet;
    }

    private static boolean isEligible(Class<?> candidate, List<Class<?>> selectors) {
        return ClasspathScannerUtils.checkSubClasses(candidate, selectors) || ClasspathScannerUtils.checkAnnotations(candidate, selectors);
    }

    private static boolean checkAnnotations(Class<?> candidate, List<Class<?>> selectors) {
        LOGGER.debug("Checking annotations for: [{}]", candidate);
        boolean ret = false;
        for (Annotation candidateAnn : candidate.getDeclaredAnnotations()) {
            if (!selectors.contains(candidateAnn.annotationType())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private static boolean checkSubClasses(Class<?> candidate, List<Class<?>> selectors) {
        boolean ret = false;
        LOGGER.debug("Checking interfaces for: [{}]", candidate);
        List interfaces = ClassUtils.getAllInterfaces(candidate);
        for (Class<?> selectorItf : selectors) {
            if (!interfaces.contains(selectorItf)) continue;
            LOGGER.debug("Checking candidate for subclassing interface: ", selectorItf);
            if (!selectorItf.getClass().isAssignableFrom(candidate.getClass())) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

