/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.UpgradeState;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.COMPONENT_VERSION, order=7.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class VersionMismatchCheck
extends ClusterCheck {
    static final UpgradeCheckDescription VERSION_MISMATCH = new UpgradeCheckDescription("VERSION_MISMATCH", UpgradeCheckType.HOST, "All components must be reporting the expected version", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"There are components which are not reporting the expected stack version: \n%s").build());

    public VersionMismatchCheck() {
        super(VERSION_MISMATCH);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        Map<String, Service> services = cluster.getServices();
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (Service service : services.values()) {
            this.validateService(service, result, errorMessages);
        }
        if (!result.getFailedOn().isEmpty()) {
            result.setStatus(UpgradeCheckStatus.WARNING);
            String failReason = this.getFailReason(result, request);
            result.setFailReason(String.format(failReason, StringUtils.join(errorMessages, (String)"\n")));
            result.setFailReason(StringUtils.join(errorMessages, (String)"\n"));
        }
        return result;
    }

    private void validateService(Service service, UpgradeCheckResult result, List<String> errorMessages) throws OBDPException {
        Map<String, ServiceComponent> serviceComponents = service.getServiceComponents();
        for (ServiceComponent serviceComponent : serviceComponents.values()) {
            this.validateServiceComponent(serviceComponent, result, errorMessages);
        }
    }

    private void validateServiceComponent(ServiceComponent serviceComponent, UpgradeCheckResult result, List<String> errorMessages) {
        Map<String, ServiceComponentHost> serviceComponentHosts = serviceComponent.getServiceComponentHosts();
        for (ServiceComponentHost serviceComponentHost : serviceComponentHosts.values()) {
            this.validateServiceComponentHost(serviceComponent, serviceComponentHost, result, errorMessages);
        }
    }

    private void validateServiceComponentHost(ServiceComponent serviceComponent, ServiceComponentHost serviceComponentHost, UpgradeCheckResult result, List<String> errorMessages) {
        if (serviceComponentHost.getUpgradeState().equals((Object)UpgradeState.VERSION_MISMATCH)) {
            String hostName = serviceComponentHost.getHostName();
            String serviceComponentName = serviceComponentHost.getServiceComponentName();
            String desiredVersion = serviceComponent.getDesiredVersion();
            String actualVersion = serviceComponentHost.getVersion();
            String message = hostName + "/" + serviceComponentName + " desired version: " + desiredVersion + ", actual version: " + actualVersion;
            result.getFailedOn().add(hostName);
            errorMessages.add(message);
        }
    }
}

