/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.checks.UpgradeCheckRegistry;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class UpgradeCheckRegistryProvider
implements Provider<UpgradeCheckRegistry> {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCheckRegistryProvider.class);
    @Inject
    private Injector m_injector;
    private UpgradeCheckRegistry m_checkRegistry;
    private Set<BeanDefinition> m_beanDefinitions = null;

    public UpgradeCheckRegistry get() {
        if (null == this.m_beanDefinitions || this.m_beanDefinitions.isEmpty()) {
            String packageName = ClusterCheck.class.getPackage().getName();
            LOG.info("Searching package {} for classes matching {}", (Object)packageName, UpgradeCheck.class);
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            AssignableTypeFilter filter = new AssignableTypeFilter(UpgradeCheck.class);
            scanner.addIncludeFilter((TypeFilter)filter);
            this.m_beanDefinitions = scanner.findCandidateComponents(packageName);
        }
        if (null == this.m_beanDefinitions || this.m_beanDefinitions.size() == 0) {
            LOG.error("No instances of {} found to register", UpgradeCheck.class);
            return null;
        }
        this.m_checkRegistry = new UpgradeCheckRegistry();
        this.m_injector.injectMembers((Object)this.m_checkRegistry);
        for (BeanDefinition beanDefinition : this.m_beanDefinitions) {
            String className = beanDefinition.getBeanClassName();
            Class clazz = ClassUtils.resolveClassName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
            try {
                UpgradeCheck upgradeCheck = (UpgradeCheck)this.m_injector.getInstance(clazz);
                this.m_checkRegistry.register(upgradeCheck);
                LOG.info("Registered pre-upgrade check {}", upgradeCheck.getClass());
            }
            catch (Exception exception) {
                LOG.error("Unable to bind and register upgrade check {}", (Object)clazz, (Object)exception);
            }
        }
        return this.m_checkRegistry;
    }
}

