/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCheckRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeCheckRegistry.class);
    @Inject
    private Provider<OBDPMetaInfo> metainfoProvider;
    @Inject
    private Injector m_injector;
    private final Set<UpgradeCheck> m_builtInChecks = new TreeSet<UpgradeCheck>(new PreUpgradeCheckComparator());
    private final Map<UpgradePack, PluginUpgradeChecks> m_pluginChecks = new HashMap<UpgradePack, PluginUpgradeChecks>();

    public void register(UpgradeCheck upgradeCheck) {
        this.m_builtInChecks.add(upgradeCheck);
    }

    public List<UpgradeCheck> getBuiltInUpgradeChecks() {
        return new ArrayList<UpgradeCheck>(this.m_builtInChecks);
    }

    public List<UpgradeCheck> getFilteredUpgradeChecks(UpgradePack upgradePack) throws OBDPException {
        ArrayList<UpgradeCheck> builtInRequiredChecks = new ArrayList<UpgradeCheck>();
        for (UpgradeCheck builtInCheck : this.m_builtInChecks) {
            if (!this.isBuiltInCheckRequired(builtInCheck, upgradePack.getType())) continue;
            builtInRequiredChecks.add(builtInCheck);
        }
        PluginUpgradeChecks pluginChecks = this.m_pluginChecks.get(upgradePack);
        if (null == pluginChecks) {
            pluginChecks = new PluginUpgradeChecks(new TreeSet<UpgradeCheck>(new PreUpgradeCheckComparator()), new TreeSet<String>());
            this.m_pluginChecks.put(upgradePack, pluginChecks);
            List<String> pluginCheckClassNames = upgradePack.getPrerequisiteChecks();
            if (null != pluginCheckClassNames && !pluginCheckClassNames.isEmpty()) {
                this.loadPluginUpgradeChecksFromStack(upgradePack, pluginChecks);
            }
        }
        TreeSet<UpgradeCheck> combinedUpgradeChecks = new TreeSet<UpgradeCheck>(new PreUpgradeCheckComparator());
        combinedUpgradeChecks.addAll(builtInRequiredChecks);
        combinedUpgradeChecks.addAll(pluginChecks.m_loadedChecks);
        return new LinkedList<UpgradeCheck>(combinedUpgradeChecks);
    }

    public Set<String> getFailedPluginClassNames() {
        Collection<PluginUpgradeChecks> pluginUpgradeChecks = this.m_pluginChecks.values();
        return pluginUpgradeChecks.stream().flatMap(plugins -> plugins.m_failedChecks.stream()).collect(Collectors.toSet());
    }

    private void loadPluginUpgradeChecksFromStack(UpgradePack upgradePack, PluginUpgradeChecks pluginChecks) throws OBDPException {
        HashSet<String> pluginCheckClassNames = new HashSet<String>(upgradePack.getPrerequisiteChecks());
        StackId ownerStackId = upgradePack.getOwnerStackId();
        StackInfo stackInfo = ((OBDPMetaInfo)this.metainfoProvider.get()).getStack(ownerStackId);
        URLClassLoader classLoader = stackInfo.getLibraryClassLoader();
        if (null != classLoader) {
            for (String pluginCheckClassName : pluginCheckClassNames) {
                try {
                    UpgradeCheck upgradeCheck = (UpgradeCheck)stackInfo.getLibraryInstance(this.m_injector, pluginCheckClassName);
                    pluginChecks.m_loadedChecks.add(upgradeCheck);
                    LOG.info("Registered pre-upgrade check {} for stack {}", (Object)pluginCheckClassName, (Object)ownerStackId);
                }
                catch (Exception exception) {
                    LOG.error("Unable to load the upgrade check {}", (Object)pluginCheckClassName, (Object)exception);
                    pluginChecks.m_failedChecks.add(pluginCheckClassName);
                }
            }
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addClassLoader((ClassLoader)classLoader).addUrls(classLoader.getURLs()).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}));
            Set upgradeChecksFromLoader = reflections.getSubTypesOf(UpgradeCheck.class);
            if (null != upgradeChecksFromLoader && !upgradeChecksFromLoader.isEmpty()) {
                for (Class clazz : upgradeChecksFromLoader) {
                    UpgradeCheckInfo upgradeCheckInfo;
                    if (pluginCheckClassNames.contains(clazz.getName()) || null == (upgradeCheckInfo = clazz.getAnnotation(UpgradeCheckInfo.class)) || !ArrayUtils.contains((Object[])upgradeCheckInfo.required(), (Object)upgradePack.getType())) continue;
                    try {
                        pluginChecks.m_loadedChecks.add((UpgradeCheck)clazz.newInstance());
                        LOG.info("Registered pre-upgrade check {} for stack {}", (Object)clazz, (Object)ownerStackId);
                    }
                    catch (Exception exception) {
                        LOG.error("Unable to load the upgrade check {}", (Object)clazz, (Object)exception);
                        pluginChecks.m_failedChecks.add(clazz.getName());
                    }
                }
            }
        } else {
            LOG.error("Unable to perform the following upgrade checks because no libraries could be loaded for the {} stack: {}", (Object)ownerStackId, (Object)StringUtils.join(pluginCheckClassNames, (String)", "));
            pluginChecks.m_failedChecks.addAll(pluginCheckClassNames);
        }
    }

    private boolean isBuiltInCheckRequired(UpgradeCheck upgradeCheck, UpgradeType upgradeType) {
        if (upgradeType == null) {
            return true;
        }
        UpgradeCheckInfo annotation = upgradeCheck.getClass().getAnnotation(UpgradeCheckInfo.class);
        if (null == annotation) {
            return false;
        }
        Object[] upgradeTypes = annotation.required();
        return ArrayUtils.contains((Object[])upgradeTypes, (Object)upgradeType);
    }

    private static final class PreUpgradeCheckComparator
    implements Comparator<UpgradeCheck> {
        private PreUpgradeCheckComparator() {
        }

        @Override
        public int compare(UpgradeCheck check1, UpgradeCheck check2) {
            int groupComparison;
            Class<?> clazz1 = check1.getClass();
            Class<?> clazz2 = check2.getClass();
            UpgradeCheckInfo annotation1 = clazz1.getAnnotation(UpgradeCheckInfo.class);
            UpgradeCheckInfo annotation2 = clazz2.getAnnotation(UpgradeCheckInfo.class);
            UpgradeCheckGroup group1 = UpgradeCheckGroup.DEFAULT;
            UpgradeCheckGroup group2 = UpgradeCheckGroup.DEFAULT;
            Float groupOrder1 = Float.valueOf(group1.getOrder().floatValue());
            Float groupOrder2 = Float.valueOf(group2.getOrder().floatValue());
            Float order1 = Float.valueOf(1.0f);
            Float order2 = Float.valueOf(1.0f);
            if (null != annotation1) {
                group1 = annotation1.group();
                groupOrder1 = Float.valueOf(group1.getOrder().floatValue());
                order1 = Float.valueOf(annotation1.order());
            }
            if (null != annotation2) {
                group2 = annotation2.group();
                groupOrder2 = Float.valueOf(group2.getOrder().floatValue());
                order2 = Float.valueOf(annotation2.order());
            }
            if ((groupComparison = groupOrder1.compareTo(groupOrder2)) != 0) {
                return groupComparison;
            }
            int orderComparison = order1.compareTo(order2);
            if (orderComparison != 0) {
                return orderComparison;
            }
            return clazz1.getName().compareTo(clazz2.getName());
        }
    }

    public static final class PluginUpgradeChecks {
        private final Set<UpgradeCheck> m_loadedChecks;
        private final Set<String> m_failedChecks;

        private PluginUpgradeChecks(Set<UpgradeCheck> loadedChecks, Set<String> failedChecks) {
            this.m_loadedChecks = loadedChecks;
            this.m_failedChecks = failedChecks;
        }
    }
}

