/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.orm.models.HostComponentSummary;
import id.onyx.obdp.server.state.CheckHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.LIVELINESS, order=2.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class ServicesUpCheck
extends ClusterCheck {
    private static final float SLAVE_THRESHOLD = 0.5f;
    static final UpgradeCheckDescription SERVICES_UP = new UpgradeCheckDescription("SERVICES_UP", UpgradeCheckType.SERVICE, "All services must be started", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The following Services must be started: {{fails}}. Try to do a Stop & Start in case they were started outside of Ambari.").build());

    public ServicesUpCheck() {
        super(SERVICES_UP);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        ArrayList<String> errorMessages = new ArrayList<String>();
        LinkedHashSet<ClusterCheck.ServiceDetail> failedServices = new LinkedHashSet<ClusterCheck.ServiceDetail>();
        Set<String> servicesInUpgrade = ((CheckHelper)this.checkHelperProvider.get()).getServicesInUpgrade(request);
        for (String serviceName : servicesInUpgrade) {
            Service service = cluster.getService(serviceName);
            if (service.isClientOnlyService()) continue;
            Map<String, ServiceComponent> serviceComponents = service.getServiceComponents();
            block1: for (Map.Entry<String, ServiceComponent> component : serviceComponents.entrySet()) {
                List<HostComponentSummary> hostComponentSummaries;
                ServiceComponent serviceComponent = component.getValue();
                if (serviceComponent.isClientComponent() || !serviceComponent.isVersionAdvertised() || (hostComponentSummaries = HostComponentSummary.getHostComponentSummaries(service.getName(), serviceComponent.getName())).isEmpty()) continue;
                boolean checkThreshold = false;
                if (!serviceComponent.isMasterComponent()) {
                    StackId stackId = service.getDesiredStackId();
                    ComponentInfo componentInfo = ((OBDPMetaInfo)this.obdpMetaInfo.get()).getComponent(stackId.getStackName(), stackId.getStackVersion(), serviceComponent.getServiceName(), serviceComponent.getName());
                    String cardinality = componentInfo.getCardinality();
                    if (null != cardinality && (cardinality.equals("ALL") || cardinality.matches("[1-9].*"))) {
                        checkThreshold = true;
                    }
                }
                if (checkThreshold) {
                    int total = hostComponentSummaries.size();
                    int up = 0;
                    int down = 0;
                    for (HostComponentSummary summary : hostComponentSummaries) {
                        if (this.isConsideredDown(cluster, serviceComponent, summary)) {
                            ++down;
                            continue;
                        }
                        ++up;
                    }
                    if (!((float)down / (float)total > 0.5f)) continue;
                    failedServices.add(new ClusterCheck.ServiceDetail(serviceName));
                    String message = MessageFormat.format("{0}: {1} out of {2} {3} are started; there should be {4,number,percent} started before upgrading.", service.getName(), up, total, serviceComponent.getName(), Float.valueOf(0.5f));
                    errorMessages.add(message);
                    continue;
                }
                for (HostComponentSummary summary : hostComponentSummaries) {
                    if (!this.isConsideredDown(cluster, serviceComponent, summary)) continue;
                    failedServices.add(new ClusterCheck.ServiceDetail(serviceName));
                    String message = MessageFormat.format("{0}: {1} (in {2} on host {3})", new Object[]{service.getName(), serviceComponent.getName(), summary.getCurrentState(), summary.getHostName()});
                    errorMessages.add(message);
                    continue block1;
                }
            }
        }
        if (!errorMessages.isEmpty()) {
            result.setFailedOn(failedServices.stream().map(failedService -> failedService.serviceName).collect(Collectors.toCollection(LinkedHashSet::new)));
            result.getFailedDetail().addAll(failedServices);
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason("The following Service Components should be in a started state.  Please invoke a service Stop and full Start and try again. " + StringUtils.join(errorMessages, (String)", "));
        }
        return result;
    }

    private boolean isConsideredDown(Cluster cluster, ServiceComponent serviceComponent, HostComponentSummary summary) throws OBDPException {
        Host host = ((Clusters)this.clustersProvider.get()).getHostById(summary.getHostId());
        MaintenanceState maintenanceState = host.getMaintenanceState(cluster.getClusterId());
        if (maintenanceState == MaintenanceState.ON && !serviceComponent.isMasterComponent()) {
            return false;
        }
        State desiredState = summary.getDesiredState();
        State currentState = summary.getCurrentState();
        switch (desiredState) {
            case INSTALLED: 
            case STARTED: {
                return currentState != State.STARTED;
            }
        }
        return false;
    }
}

