/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.state.CheckHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.Map;
import java.util.Set;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.MAINTENANCE_MODE, order=6.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class ServicesMaintenanceModeCheck
extends ClusterCheck {
    static final UpgradeCheckDescription SERVICES_MAINTENANCE_MODE = new UpgradeCheckDescription("SERVICES_MAINTENANCE_MODE", UpgradeCheckType.SERVICE, "No services can be in Maintenance Mode", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The following Services must not be in Maintenance Mode: {{fails}}.").build());

    public ServicesMaintenanceModeCheck() {
        super(SERVICES_MAINTENANCE_MODE);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(request.getClusterName());
        Set<String> servicesInUpgrade = ((CheckHelper)this.checkHelperProvider.get()).getServicesInUpgrade(request);
        for (String serviceName : servicesInUpgrade) {
            Service service = cluster.getService(serviceName);
            if (service.isClientOnlyService() || service.getMaintenanceState() != MaintenanceState.ON) continue;
            result.getFailedOn().add(service.getName());
        }
        if (!result.getFailedOn().isEmpty()) {
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason(this.getFailReason(result, request));
        }
        return result;
    }
}

