/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.DEFAULT)
public class ServicePresenceCheck
extends ClusterCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePresenceCheck.class);
    static final String KEY_SERVICE_REPLACED = "service_replaced";
    static final String KEY_SERVICE_REMOVED = "service_removed";
    static final String NO_UPGRADE_SUPPORT_SERVICES_PROPERTY_NAME = "no-upgrade-support-service-names";
    static final String REMOVED_SERVICES_PROPERTY_NAME = "removed-service-names";
    static final String REPLACED_SERVICES_PROPERTY_NAME = "replaced-service-names";
    static final String NEW_SERVICES_PROPERTY_NAME = "new-service-names";
    static final UpgradeCheckDescription SERVICE_PRESENCE_CHECK = new UpgradeCheckDescription("SERVICE_PRESENCE_CHECK", UpgradeCheckType.SERVICE, "Service Is Not Supported For Upgrades", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The %s service is currently installed on the cluster. This service does not support upgrades and must be removed before the upgrade can continue. After upgrading, %s can be reinstalled").put((Object)"service_removed", (Object)"The %s service is currently installed on the cluster. This service is removed from the new release and must be removed before the upgrade can continue.").build());

    public ServicePresenceCheck() {
        super(SERVICE_PRESENCE_CHECK);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        String msg;
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(request.getClusterName());
        Set<String> installedServices = cluster.getServices().keySet();
        List<String> noUpgradeSupportServices = this.getNoUpgradeSupportServices(request);
        Map<String, String> replacedServices = this.getReplacedServices(request);
        List<String> removedServices = this.getRemovedServices(request);
        ArrayList<String> failReasons = new ArrayList<String>();
        String reason = this.getFailReason(result, request);
        for (String string : noUpgradeSupportServices) {
            if (!installedServices.contains(string.toUpperCase())) continue;
            result.getFailedOn().add(string);
            msg = String.format(reason, string, string);
            failReasons.add(msg);
        }
        reason = this.getFailReason(KEY_SERVICE_REPLACED, result, request);
        for (Map.Entry entry : replacedServices.entrySet()) {
            String removedService = (String)entry.getKey();
            if (!installedServices.contains(removedService.toUpperCase())) continue;
            result.getFailedOn().add(removedService);
            String newService = (String)entry.getValue();
            String msg2 = String.format(reason, removedService, newService);
            failReasons.add(msg2);
        }
        reason = this.getFailReason(KEY_SERVICE_REMOVED, result, request);
        for (String string : removedServices) {
            if (!installedServices.contains(string.toUpperCase())) continue;
            result.getFailedOn().add(string);
            msg = String.format(reason, string, string);
            failReasons.add(msg);
        }
        if (!failReasons.isEmpty()) {
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason(StringUtils.join(failReasons, (char)'\n'));
        }
        return result;
    }

    private String getPropertyValue(UpgradeCheckRequest request, String propertyKey) {
        String value = null;
        Map checkProperties = request.getCheckConfigurations();
        if (checkProperties != null && checkProperties.containsKey(propertyKey)) {
            value = (String)checkProperties.get(propertyKey);
        }
        return value;
    }

    private List<String> getNoUpgradeSupportServices(UpgradeCheckRequest request) {
        ArrayList<String> result = new ArrayList<String>();
        String value = this.getPropertyValue(request, NO_UPGRADE_SUPPORT_SERVICES_PROPERTY_NAME);
        if (null != value) {
            String[] services;
            for (String service : services = value.split(",")) {
                if ((service = service.trim()).isEmpty()) continue;
                result.add(service);
            }
        }
        return result;
    }

    private List<String> getRemovedServices(UpgradeCheckRequest request) {
        ArrayList<String> result = new ArrayList<String>();
        String value = this.getPropertyValue(request, REMOVED_SERVICES_PROPERTY_NAME);
        if (null != value) {
            String[] services;
            for (String service : services = value.split(",")) {
                if ((service = service.trim()).isEmpty()) continue;
                result.add(service);
            }
        }
        return result;
    }

    private Map<String, String> getReplacedServices(UpgradeCheckRequest request) throws OBDPException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String value = this.getPropertyValue(request, REPLACED_SERVICES_PROPERTY_NAME);
        String newValue = this.getPropertyValue(request, NEW_SERVICES_PROPERTY_NAME);
        if (value == null && newValue == null) {
            return result;
        }
        if (value == null || newValue == null) {
            throw new OBDPException(String.format("Both %s and %s list must be specified in the upgrade XML file.", REPLACED_SERVICES_PROPERTY_NAME, NEW_SERVICES_PROPERTY_NAME));
        }
        List<String> oldServices = Arrays.asList(value.split(","));
        List<String> newServices = Arrays.asList(newValue.split(","));
        if (oldServices.size() != newServices.size()) {
            throw new OBDPException(String.format("%s must have the same number of services as the %s list.", NEW_SERVICES_PROPERTY_NAME, REPLACED_SERVICES_PROPERTY_NAME));
        }
        for (int i = 0; i < oldServices.size(); ++i) {
            String oldService = oldServices.get(i).trim();
            String newService = newServices.get(i).trim();
            if (oldService.isEmpty() || newService.isEmpty()) {
                throw new OBDPException(String.format("Make sure both %s and %s list only contain comma separated list of services.", NEW_SERVICES_PROPERTY_NAME, REPLACED_SERVICES_PROPERTY_NAME));
            }
            result.put(oldService, newService);
        }
        return result;
    }
}

