/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.metadata.ActionMetadata;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.ServiceConfigDAO;
import id.onyx.obdp.server.orm.entities.ServiceConfigEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.DEFAULT, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class ServiceCheckValidityCheck
extends ClusterCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCheckValidityCheck.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy hh:mm:ss");
    @Inject
    Provider<ServiceConfigDAO> serviceConfigDAOProvider;
    @Inject
    Provider<HostRoleCommandDAO> hostRoleCommandDAOProvider;
    @Inject
    Provider<ActionMetadata> actionMetadataProvider;
    static final UpgradeCheckDescription SERVICE_CHECK = new UpgradeCheckDescription("SERVICE_CHECK", UpgradeCheckType.SERVICE, "Last Service Check should be more recent than the last configuration change for the given service", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The following service configurations have been updated and their Service Checks should be run again: %s").build());

    public ServiceCheckValidityCheck() {
        super(SERVICE_CHECK);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        ServiceConfigDAO serviceConfigDAO = (ServiceConfigDAO)this.serviceConfigDAOProvider.get();
        HostRoleCommandDAO hostRoleCommandDAO = (HostRoleCommandDAO)this.hostRoleCommandDAOProvider.get();
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        long clusterId = cluster.getClusterId();
        HashMap<String, Long> lastServiceConfigUpdates = new HashMap<String, Long>();
        for (Service service : cluster.getServices().values()) {
            if (service.getMaintenanceState() != MaintenanceState.OFF || !this.hasAtLeastOneComponentVersionAdvertised(service)) continue;
            StackId stackId = service.getDesiredStackId();
            boolean isServiceWitNoConfigs = ((OBDPMetaInfo)this.obdpMetaInfo.get()).isServiceWithNoConfigs(stackId.getStackName(), stackId.getStackVersion(), service.getName());
            if (isServiceWitNoConfigs) {
                LOG.info(String.format("%s in %s version %s does not have customizable configurations. Skip checking service configuration history.", service.getName(), stackId.getStackName(), stackId.getStackVersion()));
                continue;
            }
            LOG.info(String.format("%s in %s version %s has customizable configurations. Check service configuration history.", service.getName(), stackId.getStackName(), stackId.getStackVersion()));
            ServiceConfigEntity lastServiceConfig = serviceConfigDAO.getLastServiceConfig(clusterId, service.getName());
            lastServiceConfigUpdates.put(service.getName(), lastServiceConfig.getCreateTimestamp());
        }
        List<HostRoleCommandDAO.LastServiceCheckDTO> lastServiceChecks = hostRoleCommandDAO.getLatestServiceChecksByRole(clusterId);
        HashMap<String, Long> lastServiceChecksByRole = new HashMap<String, Long>();
        for (HostRoleCommandDAO.LastServiceCheckDTO lastServiceCheck : lastServiceChecks) {
            lastServiceChecksByRole.put(lastServiceCheck.role, lastServiceCheck.endTime);
        }
        LinkedHashSet<ServiceCheckConfigDetail> failures = new LinkedHashSet<ServiceCheckConfigDetail>();
        for (Map.Entry entry : lastServiceConfigUpdates.entrySet()) {
            String serviceName = (String)entry.getKey();
            long configCreationTime = (Long)entry.getValue();
            String role = ((ActionMetadata)this.actionMetadataProvider.get()).getServiceCheckAction(serviceName);
            if (!lastServiceChecksByRole.containsKey(role)) {
                LOG.info("There was no service check found for service {} matching role {}", (Object)serviceName, (Object)role);
                failures.add(new ServiceCheckConfigDetail(serviceName, null, null));
                continue;
            }
            long lastServiceCheckTime = (Long)lastServiceChecksByRole.get(role);
            if (lastServiceCheckTime >= configCreationTime) continue;
            failures.add(new ServiceCheckConfigDetail(serviceName, lastServiceCheckTime, configCreationTime));
            LOG.info("The {} service (role {}) had its configurations updated on {}, but the last service check was {}", new Object[]{serviceName, role, DATE_FORMAT.format(new Date(configCreationTime)), DATE_FORMAT.format(new Date(lastServiceCheckTime))});
        }
        if (!failures.isEmpty()) {
            result.getFailedDetail().addAll(failures);
            LinkedHashSet failedServiceNames = failures.stream().map(failure -> failure.serviceName).collect(Collectors.toCollection(LinkedHashSet::new));
            result.setFailedOn(failedServiceNames);
            result.setStatus(UpgradeCheckStatus.FAIL);
            String failReason = this.getFailReason(result, request);
            result.setFailReason(String.format(failReason, StringUtils.join((Collection)failedServiceNames, (String)", ")));
        }
        return result;
    }

    private boolean hasAtLeastOneComponentVersionAdvertised(Service service) {
        Collection<ServiceComponent> components = service.getServiceComponents().values();
        for (ServiceComponent component : components) {
            if (!component.isVersionAdvertised()) continue;
            return true;
        }
        return false;
    }

    static class ServiceCheckConfigDetail
    implements Comparable<ServiceCheckConfigDetail> {
        @JsonProperty(value="service_name")
        final String serviceName;
        @JsonProperty(value="service_check_date")
        final Long serviceCheckDate;
        @JsonProperty(value="configuration_date")
        final Long configurationDate;

        ServiceCheckConfigDetail(String serviceName, @Nullable Long serviceCheckDate, @Nullable Long configurationDate) {
            this.serviceName = serviceName;
            this.serviceCheckDate = serviceCheckDate;
            this.configurationDate = configurationDate;
        }

        public int hashCode() {
            return Objects.hash(this.serviceName, this.serviceCheckDate, this.configurationDate);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceCheckConfigDetail other = (ServiceCheckConfigDetail)obj;
            return Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.serviceCheckDate, other.serviceCheckDate) && Objects.equals(this.configurationDate, other.configurationDate);
        }

        @Override
        public int compareTo(ServiceCheckConfigDetail other) {
            return this.serviceName.compareTo(other.serviceName);
        }
    }
}

