/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.state.CheckHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.spi.RepositoryType;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.REPOSITORY_VERSION, order=1.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED}, orchestration={RepositoryType.PATCH, RepositoryType.MAINT, RepositoryType.SERVICE})
public class RequiredServicesInRepositoryCheck
extends ClusterCheck {
    static final UpgradeCheckDescription VALID_SERVICES_INCLUDED_IN_REPOSITORY = new UpgradeCheckDescription("VALID_SERVICES_INCLUDED_IN_REPOSITORY", UpgradeCheckType.CLUSTER, "The repository is missing services which are required", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The following services are included in the upgrade but the repository is missing their dependencies:\n%s").build());

    public RequiredServicesInRepositoryCheck() {
        super(VALID_SERVICES_INCLUDED_IN_REPOSITORY);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        VersionDefinitionXml xml = ((CheckHelper)this.checkHelperProvider.get()).getVersionDefinitionXml(request);
        Set<String> missingDependencies = xml.getMissingDependencies(cluster, (OBDPMetaInfo)this.obdpMetaInfo.get());
        if (!missingDependencies.isEmpty()) {
            String failReasonTemplate = this.getFailReason(result, request);
            String message = String.format("The following services are also required to be included in this upgrade: %s", StringUtils.join(missingDependencies, (String)", "));
            result.setFailedOn(new LinkedHashSet<String>(missingDependencies));
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason(String.format(failReasonTemplate, message));
            Set missingServiceDetails = missingDependencies.stream().map(missingService -> new ClusterCheck.ServiceDetail((String)missingService)).collect(Collectors.toCollection(TreeSet::new));
            result.getFailedDetail().addAll(missingServiceDetails);
            return result;
        }
        result.setStatus(UpgradeCheckStatus.PASS);
        return result;
    }
}

