/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Map;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.DEFAULT, order=4.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class PreviousUpgradeCompleted
extends ClusterCheck {
    static final UpgradeCheckDescription PREVIOUS_UPGRADE_COMPLETED = new UpgradeCheckDescription("PREVIOUS_UPGRADE_COMPLETED", UpgradeCheckType.CLUSTER, "A previous upgrade did not complete.", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The last upgrade attempt did not complete. {{fails}}").build());
    public static final String ERROR_MESSAGE = "There is an existing {0} {1} {2} which has not completed. This {3} must be completed before a new upgrade or downgrade can begin.";

    public PreviousUpgradeCompleted() {
        super(PREVIOUS_UPGRADE_COMPLETED);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        String errorMessage = null;
        UpgradeEntity upgradeInProgress = cluster.getUpgradeInProgress();
        if (null != upgradeInProgress) {
            Direction direction = upgradeInProgress.getDirection();
            String directionText = direction.getText(false);
            String prepositionText = direction.getPreposition();
            errorMessage = MessageFormat.format(ERROR_MESSAGE, directionText, prepositionText, upgradeInProgress.getRepositoryVersion().getVersion(), directionText);
        }
        if (null != errorMessage) {
            LinkedHashSet<String> failedOn = new LinkedHashSet<String>();
            failedOn.add(cluster.getClusterName());
            result.setFailedOn(failedOn);
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason(errorMessage);
        }
        return result;
    }
}

