/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.checks.UpgradeCheckRegistry;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.annotate.JsonProperty;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.INFORMATIONAL_WARNING, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class PluginChecksLoadedCheck
extends ClusterCheck {
    private static final UpgradeCheckDescription PLUGIN_CHECK_LOAD_FAILURE = new UpgradeCheckDescription("PLUGIN_CHECK_LOAD_FAILURE", UpgradeCheckType.CLUSTER, "Plugin Upgrade Checks", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The following upgrade checks could not be loaded and were not run. Although this will not prevent your ability to upgrade, it is advised that you correct these checks before proceeding.").build());
    @Inject
    Provider<UpgradeCheckRegistry> m_upgradeCheckRegistryProvider;

    public PluginChecksLoadedCheck() {
        super(PLUGIN_CHECK_LOAD_FAILURE);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this, UpgradeCheckStatus.PASS);
        Set<String> failedPluginClasses = ((UpgradeCheckRegistry)this.m_upgradeCheckRegistryProvider.get()).getFailedPluginClassNames();
        if (null == failedPluginClasses || failedPluginClasses.isEmpty()) {
            return result;
        }
        Set failedPluginSimpleClasses = failedPluginClasses.stream().map(FailedPluginClassDetail::new).collect(Collectors.toSet());
        result.setStatus(UpgradeCheckStatus.WARNING);
        result.getFailedDetail().addAll(failedPluginSimpleClasses);
        result.setFailReason(this.getFailReason(result, request));
        result.getFailedOn().addAll(failedPluginSimpleClasses.stream().map(detail -> detail.toSimpleString()).collect(Collectors.toSet()));
        return result;
    }

    static class FailedPluginClassDetail {
        final String m_fullyQualifiedClass;
        @JsonProperty(value="package_name")
        final String m_packageName;
        @JsonProperty(value="class_name")
        final String m_className;

        FailedPluginClassDetail(String fullyQualifiedClass) {
            this.m_fullyQualifiedClass = fullyQualifiedClass;
            int indexOfLastDot = fullyQualifiedClass.lastIndexOf(46);
            if (indexOfLastDot >= 0) {
                this.m_packageName = fullyQualifiedClass.substring(0, indexOfLastDot);
                this.m_className = fullyQualifiedClass.substring(indexOfLastDot + 1);
            } else {
                this.m_packageName = "";
                this.m_className = fullyQualifiedClass;
            }
        }

        public String toString() {
            return this.m_fullyQualifiedClass;
        }

        public String toSimpleString() {
            return this.m_className;
        }

        public int hashCode() {
            return Objects.hash(this.m_packageName, this.m_className);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FailedPluginClassDetail other = (FailedPluginClassDetail)obj;
            return Objects.equals(this.m_packageName, other.m_packageName) && Objects.equals(this.m_className, other.m_className);
        }
    }
}

