/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.spi.RepositoryType;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.upgrade.CheckQualification;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import org.apache.commons.lang.ArrayUtils;

public final class OrchestrationQualification
implements CheckQualification {
    private final Class<? extends UpgradeCheck> m_checkClass;

    public OrchestrationQualification(Class<? extends UpgradeCheck> checkClass) {
        this.m_checkClass = checkClass;
    }

    public boolean isApplicable(UpgradeCheckRequest request) throws OBDPException {
        RepositoryVersion repositoryVersion = request.getTargetRepositoryVersion();
        RepositoryType repositoryType = repositoryVersion.getRepositoryType();
        UpgradeCheckInfo annotation = this.m_checkClass.getAnnotation(UpgradeCheckInfo.class);
        if (null == annotation) {
            return true;
        }
        Object[] repositoryTypes = annotation.orchestration();
        return ArrayUtils.isEmpty((Object[])repositoryTypes) || ArrayUtils.contains((Object[])repositoryTypes, (Object)repositoryType);
    }
}

