/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.persist.PersistService;
import id.onyx.obdp.server.audit.AuditLoggerModule;
import id.onyx.obdp.server.controller.ControllerModule;
import id.onyx.obdp.server.ldap.LdapModule;
import id.onyx.obdp.server.orm.DBAccessor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpackInstallChecker {
    private static final String MPACK_STACKS_ARG = "mpack-stacks";
    private static final Logger LOG = LoggerFactory.getLogger(MpackInstallChecker.class);
    private PersistService persistService;
    private DBAccessor dbAccessor;
    private Injector injector;
    private Connection connection;
    private boolean errorsFound = false;

    private static Options getOptions() {
        Options options = new Options();
        options.addOption(Option.builder().longOpt(MPACK_STACKS_ARG).desc("List of stacks defined in the management pack").required().type(String.class).hasArg().valueSeparator(' ').build());
        return options;
    }

    private static MpackContext processArguments(String ... args) {
        DefaultParser cmdLineParser = new DefaultParser();
        MpackContext ctx = null;
        try {
            CommandLine line = cmdLineParser.parse(MpackInstallChecker.getOptions(), args);
            String mpackStacksStr = (String)line.getParsedOptionValue(MPACK_STACKS_ARG);
            HashSet<String> stacksInMpack = new HashSet<String>(Arrays.asList(mpackStacksStr.split(",")));
            ctx = new MpackContext(stacksInMpack);
        }
        catch (Exception exp) {
            System.err.println("Parsing failed. Reason: " + exp.getMessage());
            LOG.error("Parsing failed. Reason: ", (Throwable)exp);
            System.exit(1);
        }
        return ctx;
    }

    public boolean isErrorsFound() {
        return this.errorsFound;
    }

    @Inject
    public MpackInstallChecker(DBAccessor dbAccessor, Injector injector, PersistService persistService) {
        this.dbAccessor = dbAccessor;
        this.injector = injector;
        this.persistService = persistService;
    }

    public void startPersistenceService() {
        this.persistService.start();
    }

    public void stopPersistenceService() {
        this.persistService.stop();
    }

    public Connection getConnection() {
        if (this.connection == null) {
            if (this.dbAccessor == null) {
                this.dbAccessor = (DBAccessor)this.injector.getInstance(DBAccessor.class);
            }
            this.connection = this.dbAccessor.getConnection();
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkClusters(HashSet<String> stacksInMpack) {
        ResultSet rs = null;
        Statement statement = null;
        HashMap<String, Object> clusterStackInfo = new HashMap<String, Object>();
        String GET_STACK_NAME_VERSION_QUERY = "select c.cluster_name, s.stack_name, s.stack_version from clusters c join stack s on c.desired_stack_id = s.stack_id";
        Connection conn = this.getConnection();
        try {
            statement = conn.createStatement(1005, 1008);
            rs = statement.executeQuery(GET_STACK_NAME_VERSION_QUERY);
            if (rs != null) {
                while (rs.next()) {
                    HashMap stackInfoMap = new HashMap();
                    stackInfoMap.put(rs.getString("stack_name"), rs.getString("stack_version"));
                    clusterStackInfo.put(rs.getString("cluster_name"), stackInfoMap);
                }
            }
            for (Map.Entry entry : clusterStackInfo.entrySet()) {
                String clusterName = (String)entry.getKey();
                Map stackInfo = (Map)entry.getValue();
                String stackName = (String)stackInfo.keySet().iterator().next();
                String stackVersion = (String)stackInfo.get(stackName);
                if (stacksInMpack.contains(stackName)) continue;
                String errorMsg = String.format("This Ambari instance is already managing the cluster %s that has the %s-%s stack installed on it. The management pack you are attempting to install only contains stack definitions for %s. Since this management pack does not contain a stack that has already being deployed by Ambari, the --purge option would cause your existing Ambari installation to be unusable. Due to that we cannot install this management pack.", clusterName, stackName, stackVersion, stacksInMpack.toString());
                LOG.error(errorMsg);
                System.err.println(errorMsg);
                this.errorsFound = true;
            }
        }
        catch (SQLException e) {
            System.err.println("SQL Exception occured during check for validating installed clusters. Reason: " + e.getMessage());
            LOG.error("SQL Exception occured during check for validating installed clusters. Reason: ", (Throwable)e);
            this.errorsFound = true;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    System.err.println("SQL Exception occurred during result set closing procedure. Reason: " + e.getMessage());
                    LOG.error("SQL Exception occurred during result set closing procedure. Reason: ", (Throwable)e);
                    this.errorsFound = true;
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    System.err.println("SQL Exception occurred during statement closing procedure. Reason: " + e.getMessage());
                    LOG.error("SQL Exception occurred during statement closing procedure. Reason: ", (Throwable)e);
                    this.errorsFound = true;
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ControllerModule(), new MpackCheckerAuditModule(), new LdapModule()});
        MpackInstallChecker mpackInstallChecker = (MpackInstallChecker)injector.getInstance(MpackInstallChecker.class);
        MpackContext mpackContext = MpackInstallChecker.processArguments(args);
        mpackInstallChecker.startPersistenceService();
        mpackInstallChecker.checkClusters(mpackContext.getStacksInMpack());
        mpackInstallChecker.stopPersistenceService();
        if (mpackInstallChecker.isErrorsFound()) {
            LOG.error("Mpack installation checker failed!");
            System.err.println("Mpack installation checker failed!");
            System.exit(1);
        } else {
            LOG.info("No errors found");
            System.out.println("No errors found");
        }
    }

    private static class MpackContext {
        private HashSet<String> stacksInMpack;

        public MpackContext(HashSet<String> stacksInMpack) {
            this.stacksInMpack = stacksInMpack;
        }

        public HashSet<String> getStacksInMpack() {
            return this.stacksInMpack;
        }
    }

    public static class MpackCheckerAuditModule
    extends AuditLoggerModule {
        @Override
        protected void configure() {
            super.configure();
        }
    }
}

