/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.REPOSITORY_VERSION, required={UpgradeType.NON_ROLLING, UpgradeType.ROLLING})
public class MissingOsInRepoVersionCheck
extends ClusterCheck {
    public static final String SOURCE_OS = "source_os";
    public static final String TARGET_OS = "target_os";
    static final UpgradeCheckDescription MISSING_OS_IN_REPO_VERSION = new UpgradeCheckDescription("MISSING_OS_IN_REPO_VERSION", UpgradeCheckType.CLUSTER, "Missing OS in repository version.", (Map)new ImmutableMap.Builder().put((Object)"source_os", (Object)"The source version must have an entry for each OS type in the cluster").put((Object)"target_os", (Object)"The target version must have an entry for each OS type in the cluster").build());

    public MissingOsInRepoVersionCheck() {
        super(MISSING_OS_IN_REPO_VERSION);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        Set<String> osFamiliesInCluster = this.osFamiliesInCluster(this.cluster(request));
        if (!this.targetOsFamilies(request).containsAll(osFamiliesInCluster)) {
            result.setFailReason(this.getFailReason(TARGET_OS, result, request));
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailedOn(new LinkedHashSet<String>(osFamiliesInCluster));
        } else if (!this.sourceOsFamilies(request).containsAll(osFamiliesInCluster)) {
            result.setFailReason(this.getFailReason(SOURCE_OS, result, request));
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailedOn(new LinkedHashSet<String>(osFamiliesInCluster));
        }
        return result;
    }

    private Cluster cluster(UpgradeCheckRequest prerequisiteCheck) throws OBDPException {
        return ((Clusters)this.clustersProvider.get()).getCluster(prerequisiteCheck.getClusterName());
    }

    private Set<String> osFamiliesInCluster(Cluster cluster) {
        return cluster.getHosts().stream().filter(host -> host.getMaintenanceState(cluster.getClusterId()) == MaintenanceState.OFF).map(Host::getOsFamily).collect(Collectors.toSet());
    }

    private Set<String> sourceOsFamilies(UpgradeCheckRequest request) throws OBDPException {
        StackId stackId = new StackId(request.getTargetRepositoryVersion().getStackId());
        return ((OBDPMetaInfo)this.obdpMetaInfo.get()).getStack(stackId).getRepositoriesByOs().keySet();
    }

    private Set<String> targetOsFamilies(UpgradeCheckRequest request) {
        RepositoryVersion repositoryVersion = request.getTargetRepositoryVersion();
        RepositoryVersionEntity entity = (RepositoryVersionEntity)((RepositoryVersionDAO)this.repositoryVersionDaoProvider.get()).findByPK(repositoryVersion.getId());
        return entity.getRepoOsEntities().stream().map(RepoOsEntity::getFamily).collect(Collectors.toSet());
    }
}

