/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.INFORMATIONAL_WARNING)
public class LZOCheck
extends ClusterCheck {
    static final String IO_COMPRESSION_CODECS = "io.compression.codecs";
    static final String LZO_ENABLE_KEY = "io.compression.codec.lzo.class";
    static final String LZO_ENABLE_VALUE = "com.hadoop.compression.lzo.LzoCodec";
    static final UpgradeCheckDescription LZO_CONFIG_CHECK = new UpgradeCheckDescription("LZO_CONFIG_CHECK", UpgradeCheckType.CLUSTER, "LZO Codec Check", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"You have LZO codec enabled in the core-site config of your cluster. LZO is no longer installed automatically. If any hosts require LZO, it should be installed before starting the upgrade. Consult Ambari documentation for instructions on how to do this.").build());

    public LZOCheck() {
        super(LZO_CONFIG_CHECK);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        String classValue;
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        if (this.config.getGplLicenseAccepted().booleanValue()) {
            return result;
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        UpgradeCheckStatus checkStatus = UpgradeCheckStatus.WARNING;
        String codecs = this.getProperty(request, "core-site", IO_COMPRESSION_CODECS);
        if (codecs != null && codecs.contains(LZO_ENABLE_VALUE)) {
            errorMessages.add(this.getFailReason(IO_COMPRESSION_CODECS, result, request));
        }
        if (LZO_ENABLE_VALUE.equals(classValue = this.getProperty(request, "core-site", LZO_ENABLE_KEY))) {
            errorMessages.add(this.getFailReason(LZO_ENABLE_KEY, result, request));
        }
        if (!errorMessages.isEmpty()) {
            result.setFailReason(StringUtils.join(errorMessages, (String)"You have LZO codec enabled in the core-site config of your cluster. You have to accept GPL license during obdp-server setup to have LZO installed automatically. If any hosts require LZO, it should be installed before starting the upgrade. Consult Ambari documentation for instructions on how to do this."));
            result.getFailedOn().add("LZO");
            result.setStatus(checkStatus);
        }
        return result;
    }
}

