/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.security.encryption.CredentialStoreService;
import id.onyx.obdp.server.security.encryption.CredentialStoreType;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UpgradeCheckInfo(group=UpgradeCheckGroup.KERBEROS, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class KerberosAdminPersistedCredentialCheck
extends ClusterCheck {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosAdminPersistedCredentialCheck.class);
    public static final String KEY_PERSISTED_STORE_NOT_CONFIGURED = "persisted_store_no_configured";
    public static final String KEY_CREDENTIAL_NOT_STORED = "admin_credential_not_stored";
    @Inject
    private CredentialStoreService credentialStoreService;
    @Inject
    private UpgradeHelper upgradeHelper;
    static final UpgradeCheckDescription KERBEROS_ADMIN_CREDENTIAL_CHECK = new UpgradeCheckDescription("KERBEROS_ADMIN_CREDENTIAL_CHECK", UpgradeCheckType.CLUSTER, "The KDC administrator credentials need to be stored in Ambari persisted credential store.", (Map)new ImmutableMap.Builder().put((Object)"persisted_store_no_configured", (Object)"Ambari's credential store has not been configured.  This is needed so the KDC administrator credential may be stored long enough to ensure it will be around if needed during the upgrade process.").put((Object)"admin_credential_not_stored", (Object)"The KDC administrator credential has not been stored in the persisted credential store. Visit the Kerberos administrator page to set the credential. This is needed so the KDC administrator credential may be stored long enough to ensure it will be around if needed during the upgrade process.").build());

    @Inject
    public KerberosAdminPersistedCredentialCheck() {
        super(KERBEROS_ADMIN_CREDENTIAL_CHECK);
    }

    @Override
    public Set<String> getApplicableServices() {
        return Collections.emptySet();
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        if (cluster.getSecurityType() != SecurityType.KERBEROS) {
            return result;
        }
        if (!this.upgradePack(request).anyGroupTaskMatch(task -> task.getType() == Task.Type.REGENERATE_KEYTABS)) {
            LOG.info("Skipping upgrade check {} because there is no {} in the upgrade pack.", (Object)this.getClass().getSimpleName(), (Object)Task.Type.REGENERATE_KEYTABS);
            return result;
        }
        if (!"true".equalsIgnoreCase(this.getProperty(request, "kerberos-env", "manage_identities"))) {
            return result;
        }
        if (!this.credentialStoreService.isInitialized(CredentialStoreType.PERSISTED)) {
            result.setFailReason(this.getFailReason(KEY_PERSISTED_STORE_NOT_CONFIGURED, result, request));
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.getFailedOn().add(request.getClusterName());
        } else if (this.credentialStoreService.getCredential(clusterName, "kdc.admin.credential", CredentialStoreType.PERSISTED) == null) {
            result.setFailReason(this.getFailReason(KEY_CREDENTIAL_NOT_STORED, result, request));
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.getFailedOn().add(request.getClusterName());
        }
        return result;
    }

    private UpgradePack upgradePack(UpgradeCheckRequest request) throws OBDPException {
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(request.getClusterName());
        return this.upgradeHelper.suggestUpgradePack(request.getClusterName(), cluster.getCurrentStackVersion(), new StackId(request.getTargetRepositoryVersion().getStackId()), Direction.UPGRADE, request.getUpgradeType(), null);
    }
}

