/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.DEFAULT, order=3.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class InstallPackagesCheck
extends ClusterCheck {
    static final UpgradeCheckDescription INSTALL_PACKAGES_CHECK = new UpgradeCheckDescription("INSTALL_PACKAGES_CHECK", UpgradeCheckType.CLUSTER, "Install packages must be re-run", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"Re-run Install Packages before starting upgrade").build());

    public InstallPackagesCheck() {
        super(INSTALL_PACKAGES_CHECK);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        RepositoryVersion repositoryVersion = request.getTargetRepositoryVersion();
        StackId targetStackId = new StackId(repositoryVersion.getStackId());
        TreeSet<ClusterCheck.HostDetail> failedHosts = new TreeSet<ClusterCheck.HostDetail>();
        for (Host host : cluster.getHosts()) {
            if (host.getMaintenanceState(cluster.getClusterId()) == MaintenanceState.ON) continue;
            for (HostVersionEntity hve : ((HostVersionDAO)this.hostVersionDaoProvider.get()).findByHost(host.getHostName())) {
                if (!StringUtils.equals((String)hve.getRepositoryVersion().getVersion(), (String)repositoryVersion.getVersion()) || hve.getState() != RepositoryVersionState.INSTALL_FAILED) continue;
                failedHosts.add(new ClusterCheck.HostDetail(host.getHostId(), host.getHostName()));
            }
        }
        if (!failedHosts.isEmpty()) {
            String message = MessageFormat.format("Hosts in cluster [{0},{1},{2},{3}] are in INSTALL_FAILED state because Install Packages had failed. Please re-run Install Packages, if necessary place following hosts in Maintenance mode: {4}", cluster.getClusterName(), targetStackId.getStackName(), targetStackId.getStackVersion(), repositoryVersion.getVersion(), StringUtils.join(failedHosts, (String)", "));
            LinkedHashSet failedHostNames = failedHosts.stream().map(failedHost -> failedHost.hostName).collect(Collectors.toCollection(LinkedHashSet::new));
            result.setFailedOn(failedHostNames);
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason(message);
            result.getFailedDetail().addAll(failedHosts);
            return result;
        }
        result.setStatus(UpgradeCheckStatus.PASS);
        return result;
    }
}

