/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.orm.dao.HostVersionDAO;
import id.onyx.obdp.server.orm.entities.HostVersionEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.RepositoryVersionState;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.EnumSet;
import java.util.Map;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.REPOSITORY_VERSION, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class HostsRepositoryVersionCheck
extends ClusterCheck {
    static final UpgradeCheckDescription HOSTS_REPOSITORY_VERSION = new UpgradeCheckDescription("HOSTS_REPOSITORY_VERSION", UpgradeCheckType.HOST, "All hosts should have target version installed", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The following hosts must have version {{version}} installed: {{fails}}.").build());

    public HostsRepositoryVersionCheck() {
        super(HOSTS_REPOSITORY_VERSION);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        Map<String, Host> clusterHosts = ((Clusters)this.clustersProvider.get()).getHostsForCluster(clusterName);
        for (Host host : clusterHosts.values()) {
            MaintenanceState maintenanceState = host.getMaintenanceState(cluster.getClusterId());
            if (maintenanceState != MaintenanceState.OFF) continue;
            RepositoryVersion repositoryVersion = request.getTargetRepositoryVersion();
            StackId repositoryStackId = new StackId(repositoryVersion.getStackId());
            HostVersionEntity hostVersion = ((HostVersionDAO)this.hostVersionDaoProvider.get()).findByClusterStackVersionAndHost(clusterName, repositoryStackId, repositoryVersion.getVersion(), host.getHostName());
            EnumSet<RepositoryVersionState> okStates = EnumSet.of(RepositoryVersionState.INSTALLED, RepositoryVersionState.NOT_REQUIRED);
            if (hostVersion != null && okStates.contains((Object)hostVersion.getState())) continue;
            result.getFailedOn().add(host.getHostName());
            result.getFailedDetail().add(new ClusterCheck.HostDetail(host.getHostId(), host.getHostName()));
        }
        if (!result.getFailedOn().isEmpty()) {
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason(this.getFailReason(result, request));
        }
        return result;
    }
}

