/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.checks;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import id.onyx.obdp.annotations.UpgradeCheckInfo;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.checks.ClusterCheck;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.RepositoryVersion;
import id.onyx.obdp.spi.upgrade.UpgradeCheck;
import id.onyx.obdp.spi.upgrade.UpgradeCheckDescription;
import id.onyx.obdp.spi.upgrade.UpgradeCheckGroup;
import id.onyx.obdp.spi.upgrade.UpgradeCheckRequest;
import id.onyx.obdp.spi.upgrade.UpgradeCheckResult;
import id.onyx.obdp.spi.upgrade.UpgradeCheckStatus;
import id.onyx.obdp.spi.upgrade.UpgradeCheckType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.util.HashSet;
import java.util.Map;

@Singleton
@UpgradeCheckInfo(group=UpgradeCheckGroup.MAINTENANCE_MODE, order=5.0f, required={UpgradeType.ROLLING, UpgradeType.NON_ROLLING, UpgradeType.HOST_ORDERED})
public class HostsMasterMaintenanceCheck
extends ClusterCheck {
    static final String KEY_NO_UPGRADE_NAME = "no_upgrade_name";
    static final String KEY_NO_UPGRADE_PACK = "no_upgrade_pack";
    static final UpgradeCheckDescription HOSTS_MASTER_MAINTENANCE = new UpgradeCheckDescription("HOSTS_MASTER_MAINTENANCE", UpgradeCheckType.HOST, "Hosts in Maintenance Mode must not have any master components", (Map)new ImmutableMap.Builder().put((Object)"default", (Object)"The following hosts must not be in in Maintenance Mode since they host Master components: {{fails}}.").put((Object)"no_upgrade_name", (Object)"Could not find suitable upgrade pack for %s %s to version {{version}}.").put((Object)"no_upgrade_pack", (Object)"Could not find upgrade pack named %s.").build());

    public HostsMasterMaintenanceCheck() {
        super(HOSTS_MASTER_MAINTENANCE);
    }

    public UpgradeCheckResult perform(UpgradeCheckRequest request) throws OBDPException {
        UpgradeCheckResult result = new UpgradeCheckResult((UpgradeCheck)this);
        String clusterName = request.getClusterName();
        Cluster cluster = ((Clusters)this.clustersProvider.get()).getCluster(clusterName);
        RepositoryVersion repositoryVersion = request.getTargetRepositoryVersion();
        StackId stackId = new StackId(repositoryVersion.getStackId());
        HashSet<String> hostsWithMasterComponent = new HashSet<String>();
        String upgradePackName = ((RepositoryVersionHelper)this.repositoryVersionHelper.get()).getUpgradePackageName(stackId.getStackName(), stackId.getStackVersion(), repositoryVersion.getVersion(), null);
        if (upgradePackName == null) {
            result.setStatus(UpgradeCheckStatus.FAIL);
            String fail = this.getFailReason(KEY_NO_UPGRADE_NAME, result, request);
            result.setFailReason(String.format(fail, stackId.getStackName(), stackId.getStackVersion()));
            return result;
        }
        UpgradePack upgradePack = ((OBDPMetaInfo)this.obdpMetaInfo.get()).getUpgradePacks(stackId.getStackName(), stackId.getStackVersion()).get(upgradePackName);
        if (upgradePack == null) {
            result.setStatus(UpgradeCheckStatus.FAIL);
            String fail = this.getFailReason(KEY_NO_UPGRADE_PACK, result, request);
            result.setFailReason(String.format(fail, upgradePackName));
            return result;
        }
        HashSet<String> componentsFromUpgradePack = new HashSet<String>();
        for (Map<String, UpgradePack.ProcessingComponent> task : upgradePack.getTasks().values()) {
            componentsFromUpgradePack.addAll(task.keySet());
        }
        for (Service service : cluster.getServices().values()) {
            for (ServiceComponent serviceComponent : service.getServiceComponents().values()) {
                if (!serviceComponent.isMasterComponent() || !componentsFromUpgradePack.contains(serviceComponent.getName())) continue;
                hostsWithMasterComponent.addAll(serviceComponent.getServiceComponentHosts().keySet());
            }
        }
        Map<String, Host> clusterHosts = ((Clusters)this.clustersProvider.get()).getHostsForCluster(clusterName);
        for (Map.Entry<String, Host> hostEntry : clusterHosts.entrySet()) {
            Host host = hostEntry.getValue();
            if (host.getMaintenanceState(cluster.getClusterId()) != MaintenanceState.ON || !hostsWithMasterComponent.contains(host.getHostName())) continue;
            result.getFailedOn().add(host.getHostName());
            result.getFailedDetail().add(new ClusterCheck.HostDetail(host.getHostId(), host.getHostName()));
        }
        if (!result.getFailedOn().isEmpty()) {
            result.setStatus(UpgradeCheckStatus.FAIL);
            result.setFailReason(this.getFailReason(result, request));
        }
        return result;
    }
}

